/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.tck.artifacts.basicchunk;

import com.ibm.jbatch.tck.artifacts.basicchunk.BasicItem;
import com.ibm.jbatch.tck.artifacts.basicchunk.BasicReaderException;
import jakarta.batch.api.BatchProperty;
import jakarta.batch.api.chunk.AbstractItemReader;
import jakarta.batch.runtime.context.JobContext;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.Serializable;

@Named(value="basicReader")
public class BasicReader
extends AbstractItemReader {
    @Inject
    JobContext jobCtx;
    @Inject
    @BatchProperty(name="number.of.items.to.be.read")
    String injectedNumberOfItemsToBeRead;
    private int numberOfItemsToBeRead = 10;
    @Inject
    @BatchProperty(name="throw.reader.exception.for.these.items")
    String injectedThrowReaderExceptionForTheseItems;
    private int[] throwReaderExceptionForTheseItems = new int[0];
    private int currentItemId = -1;
    private BasicItem currentItem = null;

    public void open(Serializable checkpoint) {
        if (this.injectedNumberOfItemsToBeRead != null) {
            this.numberOfItemsToBeRead = Integer.parseInt(this.injectedNumberOfItemsToBeRead);
        }
        if (this.injectedThrowReaderExceptionForTheseItems != null) {
            String[] exceptionsStringArray = this.injectedThrowReaderExceptionForTheseItems.split(",");
            this.throwReaderExceptionForTheseItems = new int[exceptionsStringArray.length];
            for (int i = 0; i < exceptionsStringArray.length; ++i) {
                this.throwReaderExceptionForTheseItems[i] = Integer.parseInt(exceptionsStringArray[i]);
            }
        }
    }

    public BasicItem readItem() throws Exception {
        ++this.currentItemId;
        if (this.currentItemId < this.numberOfItemsToBeRead) {
            this.currentItem = new BasicItem(this.currentItemId);
            if (this.readerExceptionShouldBeThrownForCurrentItem()) {
                this.jobCtx.setExitStatus("BasicReaderException:Item#" + this.currentItem.getId());
                throw new BasicReaderException("BasicReaderException thrown for item " + this.currentItem.getId());
            }
            this.currentItem.setRead(true);
            return this.currentItem;
        }
        return null;
    }

    private boolean readerExceptionShouldBeThrownForCurrentItem() {
        for (int i : this.throwReaderExceptionForTheseItems) {
            if (this.currentItem.getId() != i) continue;
            return true;
        }
        return false;
    }
}

