/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.tck.artifacts.specialized;

import com.ibm.jbatch.tck.artifacts.reusable.MyPersistentRestartUserData;
import jakarta.batch.api.BatchProperty;
import jakarta.batch.api.chunk.AbstractCheckpointAlgorithm;
import jakarta.batch.runtime.context.StepContext;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.Serializable;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;

@Named(value="myCustomCheckpointAlgorithm")
public class MyCustomCheckpointAlgorithm
extends AbstractCheckpointAlgorithm {
    private static final String className = MyCustomCheckpointAlgorithm.class.getName();
    private static Logger logger = Logger.getLogger(MyCustomCheckpointAlgorithm.class.getPackage().getName());
    boolean inCheckpoint = false;
    int checkpointIterations = 1;
    int threshold;
    long timeStarted = 0L;
    int requests;
    @Inject
    private StepContext stepCtx = null;
    @Inject
    @BatchProperty(name="writepoints")
    String writePointsString;
    @Inject
    @BatchProperty(name="next.writepoints")
    String nextWritePointsString;
    int[] writePoints;
    boolean init = false;

    public void init() {
        MyPersistentRestartUserData myData = null;
        myData = (MyPersistentRestartUserData)this.stepCtx.getPersistentUserData();
        if (myData != null) {
            this.stepCtx.setPersistentUserData((Serializable)new MyPersistentRestartUserData(myData.getExecutionNumber() + 1, null));
            logger.fine("AJM: iteration = " + ((MyPersistentRestartUserData)this.stepCtx.getPersistentUserData()).getExecutionNumber());
            this.writePointsString = ((MyPersistentRestartUserData)this.stepCtx.getPersistentUserData()).getNextWritePoints();
        } else {
            this.stepCtx.setPersistentUserData((Serializable)new MyPersistentRestartUserData(1, this.nextWritePointsString));
        }
        String[] writePointsStrArr = this.writePointsString.split(",");
        this.writePoints = new int[this.writePointsString.length()];
        for (int i = 0; i < writePointsStrArr.length; ++i) {
            this.writePoints[i] = Integer.parseInt(writePointsStrArr[i]);
            logger.fine("CUSTOMCHKPT: writePoints[" + i + "] = " + this.writePoints[i]);
        }
        this.threshold = this.writePoints[this.checkpointIterations];
        this.requests = this.writePoints[0];
        this.init = true;
    }

    public boolean isReadyToCheckpoint() throws Exception {
        boolean ready;
        String method = "isReadyToCheckpoint";
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(className, method);
        }
        if (!this.init) {
            if (((MyPersistentRestartUserData)this.stepCtx.getPersistentUserData()).getExecutionNumber() == 2) {
                this.writePointsString = ((MyPersistentRestartUserData)this.stepCtx.getPersistentUserData()).getNextWritePoints();
            }
            String[] writePointsStrArr = this.writePointsString.split(",");
            this.writePoints = new int[this.writePointsString.length()];
            for (int i = 0; i < writePointsStrArr.length; ++i) {
                logger.fine("CUSTOMCHKPT: writePointsStrArr[" + i + "] = " + writePointsStrArr[i]);
                this.writePoints[i] = Integer.parseInt(writePointsStrArr[i]);
                logger.fine("CUSTOMCHKPT: writePoints[" + i + "] = " + this.writePoints[i]);
            }
            this.threshold = this.writePoints[this.checkpointIterations];
            this.requests = this.writePoints[0];
            this.init = true;
        }
        ++this.requests;
        boolean bl = ready = this.requests >= this.threshold;
        if (ready) {
            ++this.checkpointIterations;
            this.threshold = this.writePoints[this.checkpointIterations];
            long millis = new Date().getTime() - this.timeStarted;
            if (millis > 0L) {
                String rate = Integer.valueOf(Long.valueOf((long)(this.requests * 1000) / millis).intValue()).toString();
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine(" - true [requests/second " + rate + "]");
                }
            } else if (logger.isLoggable(Level.FINE)) {
                logger.fine(" - true [requests " + this.requests + "]");
            }
        }
        return ready;
    }

    private class MyTransient {
        int data = 0;

        MyTransient(int x) {
            this.data = x;
        }
    }
}

