/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.tck.tests.jslxml;

import com.ibm.jbatch.tck.utils.AssertionUtils;
import com.ibm.jbatch.tck.utils.BaseJUnit5Test;
import com.ibm.jbatch.tck.utils.JobOperatorBridge;
import com.ibm.jbatch.tck.utils.TCKJobExecutionWrapper;
import ee.jakarta.tck.batch.util.Reporter;
import jakarta.batch.operations.JobStartException;
import jakarta.batch.runtime.BatchStatus;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class SplitTransitioningTests
extends BaseJUnit5Test {
    private static JobOperatorBridge jobOp = null;

    @Test
    public void testSplitTransitionToStep() throws Exception {
        String METHOD = "testSplitTransitionToStep";
        try {
            Reporter.log((String)"starting job");
            TCKJobExecutionWrapper jobExec = jobOp.startJobAndWaitForResult("split_transition_to_step", null);
            Reporter.log((String)("Job Status = " + jobExec.getBatchStatus()));
            AssertionUtils.assertWithMessage("Split transitioned to step", "step1", jobExec.getExitStatus());
            AssertionUtils.assertWithMessage("Job completed", BatchStatus.COMPLETED, jobExec.getBatchStatus());
            Reporter.log((String)"job completed");
        }
        catch (Exception e) {
            SplitTransitioningTests.handleException(METHOD, e);
        }
    }

    @Test
    public void testSplitTransitionToStepOutOfScope() throws Exception {
        String METHOD = "testSplitTransitionToStepOutOfScope";
        try {
            Reporter.log((String)"starting job");
            boolean seenException = false;
            TCKJobExecutionWrapper jobExec = null;
            try {
                jobExec = jobOp.startJobAndWaitForResult("split_transition_to_step_out_of_scope", null);
            }
            catch (JobStartException e) {
                Reporter.log((String)("Caught JobStartException:  " + e.getLocalizedMessage()));
                seenException = true;
            }
            if (!seenException) {
                Reporter.log((String)("Didn't catch JobstartException, Job Batch Status = " + jobExec.getBatchStatus()));
                AssertionUtils.assertWithMessage("Job should have failed because of out of scope execution elements.", BatchStatus.FAILED, jobExec.getBatchStatus());
            }
        }
        catch (Exception e) {
            SplitTransitioningTests.handleException(METHOD, e);
        }
    }

    @Test
    public void testSplitTransitionToDecision() throws Exception {
        String METHOD = "testSplitTransitionToDecision";
        try {
            String exitStatus = "ThatsAllFolks";
            Reporter.log((String)"starting job");
            TCKJobExecutionWrapper jobExec = jobOp.startJobAndWaitForResult("split_transition_to_decision", null);
            Reporter.log((String)("Job Status = " + jobExec.getBatchStatus()));
            AssertionUtils.assertWithMessage("Job Exit Status is from decider", exitStatus, jobExec.getExitStatus());
            AssertionUtils.assertWithMessage("Job completed", BatchStatus.COMPLETED, jobExec.getBatchStatus());
            Reporter.log((String)"job completed");
        }
        catch (Exception e) {
            SplitTransitioningTests.handleException(METHOD, e);
        }
    }

    private static void handleException(String methodName, Exception e) throws Exception {
        Reporter.log((String)("Caught exception: " + e.getMessage() + "<p>"));
        Reporter.log((String)(methodName + " failed<p>"));
        throw e;
    }

    @BeforeAll
    public static void beforeTest() throws ClassNotFoundException {
        jobOp = new JobOperatorBridge();
    }

    @AfterAll
    public static void afterTest() {
        jobOp = null;
    }
}

