/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.tasks;

import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.unboundidds.tasks.FailedDependencyAction;
import com.unboundid.ldap.sdk.unboundidds.tasks.Task;
import com.unboundid.ldap.sdk.unboundidds.tasks.TaskException;
import com.unboundid.ldap.sdk.unboundidds.tasks.TaskMessages;
import com.unboundid.ldap.sdk.unboundidds.tasks.TaskProperty;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class ImportTask
extends Task {
    static final String IMPORT_TASK_CLASS = "com.unboundid.directory.server.tasks.ImportTask";
    private static final String ATTR_APPEND = "ds-task-import-append";
    private static final String ATTR_BACKEND_ID = "ds-task-import-backend-id";
    private static final String ATTR_CLEAR_BACKEND = "ds-task-import-clear-backend";
    private static final String ATTR_EXCLUDE_ATTRIBUTE = "ds-task-import-exclude-attribute";
    private static final String ATTR_EXCLUDE_BRANCH = "ds-task-import-exclude-branch";
    private static final String ATTR_EXCLUDE_FILTER = "ds-task-import-exclude-filter";
    private static final String ATTR_INCLUDE_ATTRIBUTE = "ds-task-import-include-attribute";
    private static final String ATTR_INCLUDE_BRANCH = "ds-task-import-include-branch";
    private static final String ATTR_INCLUDE_FILTER = "ds-task-import-include-filter";
    private static final String ATTR_IS_COMPRESSED = "ds-task-import-is-compressed";
    private static final String ATTR_IS_ENCRYPTED = "ds-task-import-is-encrypted";
    private static final String ATTR_LDIF_FILE = "ds-task-import-ldif-file";
    private static final String ATTR_OVERWRITE_REJECTS = "ds-task-import-overwrite-rejects";
    private static final String ATTR_REJECT_FILE = "ds-task-import-reject-file";
    private static final String ATTR_REPLACE_EXISTING = "ds-task-import-replace-existing";
    private static final String ATTR_SKIP_SCHEMA_VALIDATION = "ds-task-import-skip-schema-validation";
    private static final String ATTR_STRIP_TRAILING_SPACES = "ds-task-import-strip-trailing-spaces";
    private static final TaskProperty PROPERTY_BACKEND_ID = new TaskProperty("ds-task-import-backend-id", TaskMessages.INFO_DISPLAY_NAME_BACKEND_ID.get(), TaskMessages.INFO_DESCRIPTION_BACKEND_ID_IMPORT.get(), String.class, false, false, false);
    private static final TaskProperty PROPERTY_LDIF_FILE = new TaskProperty("ds-task-import-ldif-file", TaskMessages.INFO_DISPLAY_NAME_LDIF_FILE.get(), TaskMessages.INFO_DESCRIPTION_LDIF_FILE_IMPORT.get(), String.class, true, true, false);
    private static final TaskProperty PROPERTY_APPEND = new TaskProperty("ds-task-import-append", TaskMessages.INFO_DISPLAY_NAME_APPEND_TO_DB.get(), TaskMessages.INFO_DESCRIPTION_APPEND_TO_DB.get(), Boolean.class, false, false, true);
    private static final TaskProperty PROPERTY_REPLACE_EXISTING = new TaskProperty("ds-task-import-replace-existing", TaskMessages.INFO_DISPLAY_NAME_REPLACE_EXISTING.get(), TaskMessages.INFO_DESCRIPTION_REPLACE_EXISTING.get(), Boolean.class, false, false, true);
    private static final TaskProperty PROPERTY_REJECT_FILE = new TaskProperty("ds-task-import-reject-file", TaskMessages.INFO_DISPLAY_NAME_REJECT_FILE.get(), TaskMessages.INFO_DESCRIPTION_REJECT_FILE.get(), String.class, false, false, false);
    private static final TaskProperty PROPERTY_OVERWRITE_REJECTS = new TaskProperty("ds-task-import-overwrite-rejects", TaskMessages.INFO_DISPLAY_NAME_OVERWRITE_REJECTS.get(), TaskMessages.INFO_DESCRIPTION_OVERWRITE_REJECTS.get(), Boolean.class, false, false, true);
    private static final TaskProperty PROPERTY_CLEAR_BACKEND = new TaskProperty("ds-task-import-clear-backend", TaskMessages.INFO_DISPLAY_NAME_CLEAR_BACKEND.get(), TaskMessages.INFO_DESCRIPTION_CLEAR_BACKEND.get(), Boolean.class, false, false, true);
    private static final TaskProperty PROPERTY_INCLUDE_BRANCH = new TaskProperty("ds-task-import-include-branch", TaskMessages.INFO_DISPLAY_NAME_INCLUDE_BRANCH.get(), TaskMessages.INFO_DESCRIPTION_INCLUDE_BRANCH_IMPORT.get(), String.class, false, true, true);
    private static final TaskProperty PROPERTY_EXCLUDE_BRANCH = new TaskProperty("ds-task-import-exclude-branch", TaskMessages.INFO_DISPLAY_NAME_EXCLUDE_BRANCH.get(), TaskMessages.INFO_DESCRIPTION_EXCLUDE_BRANCH_IMPORT.get(), String.class, false, true, true);
    private static final TaskProperty PROPERTY_INCLUDE_FILTER = new TaskProperty("ds-task-import-include-filter", TaskMessages.INFO_DISPLAY_NAME_INCLUDE_FILTER.get(), TaskMessages.INFO_DESCRIPTION_INCLUDE_FILTER_IMPORT.get(), String.class, false, true, true);
    private static final TaskProperty PROPERTY_EXCLUDE_FILTER = new TaskProperty("ds-task-import-exclude-filter", TaskMessages.INFO_DISPLAY_NAME_EXCLUDE_FILTER.get(), TaskMessages.INFO_DESCRIPTION_EXCLUDE_FILTER_IMPORT.get(), String.class, false, true, true);
    private static final TaskProperty PROPERTY_INCLUDE_ATTRIBUTE = new TaskProperty("ds-task-import-include-attribute", TaskMessages.INFO_DISPLAY_NAME_INCLUDE_ATTRIBUTE.get(), TaskMessages.INFO_DESCRIPTION_INCLUDE_ATTRIBUTE_IMPORT.get(), String.class, false, true, true);
    private static final TaskProperty PROPERTY_EXCLUDE_ATTRIBUTE = new TaskProperty("ds-task-import-exclude-attribute", TaskMessages.INFO_DISPLAY_NAME_EXCLUDE_ATTRIBUTE.get(), TaskMessages.INFO_DESCRIPTION_EXCLUDE_ATTRIBUTE_IMPORT.get(), String.class, false, true, true);
    private static final TaskProperty PROPERTY_IS_COMPRESSED = new TaskProperty("ds-task-import-is-compressed", TaskMessages.INFO_DISPLAY_NAME_IS_COMPRESSED_IMPORT.get(), TaskMessages.INFO_DESCRIPTION_IS_COMPRESSED_IMPORT.get(), Boolean.class, false, false, false);
    private static final TaskProperty PROPERTY_IS_ENCRYPTED = new TaskProperty("ds-task-import-is-encrypted", TaskMessages.INFO_DISPLAY_NAME_IS_ENCRYPTED_IMPORT.get(), TaskMessages.INFO_DESCRIPTION_IS_ENCRYPTED_IMPORT.get(), Boolean.class, false, false, false);
    private static final TaskProperty PROPERTY_SKIP_SCHEMA_VALIDATION = new TaskProperty("ds-task-import-skip-schema-validation", TaskMessages.INFO_DISPLAY_NAME_SKIP_SCHEMA_VALIDATION.get(), TaskMessages.INFO_DESCRIPTION_SKIP_SCHEMA_VALIDATION.get(), Boolean.class, false, false, false);
    private static final TaskProperty PROPERTY_STRIP_TRAILING_SPACES = new TaskProperty("ds-task-import-strip-trailing-spaces", TaskMessages.INFO_DISPLAY_NAME_STRIP_TRAILING_SPACES.get(), TaskMessages.INFO_DESCRIPTION_STRIP_TRAILING_SPACES.get(), Boolean.class, false, false, false);
    private static final String OC_IMPORT_TASK = "ds-task-import";
    private static final long serialVersionUID = -8451067488894354839L;
    private final boolean append;
    private final boolean clearBackend;
    private final boolean isCompressed;
    private final boolean isEncrypted;
    private final boolean overwriteRejects;
    private final boolean replaceExisting;
    private final boolean skipSchemaValidation;
    private final boolean stripTrailingSpaces;
    private final List<String> excludeAttributes;
    private final List<String> excludeBranches;
    private final List<String> excludeFilters;
    private final List<String> includeAttributes;
    private final List<String> includeBranches;
    private final List<String> includeFilters;
    private final List<String> ldifFiles;
    private final String backendID;
    private final String rejectFile;

    public ImportTask() {
        this.append = false;
        this.clearBackend = false;
        this.isCompressed = false;
        this.isEncrypted = false;
        this.overwriteRejects = false;
        this.replaceExisting = false;
        this.skipSchemaValidation = false;
        this.stripTrailingSpaces = false;
        this.excludeAttributes = null;
        this.excludeBranches = null;
        this.excludeFilters = null;
        this.includeAttributes = null;
        this.includeBranches = null;
        this.includeFilters = null;
        this.ldifFiles = null;
        this.backendID = null;
        this.rejectFile = null;
    }

    public ImportTask(String taskID, String backendID, String ldifFile) {
        this(taskID, Arrays.asList(ldifFile), backendID, false, false, null, false, true, null, null, null, null, null, null, false, false, false, null, null, null, null, null);
        Validator.ensureNotNull(ldifFile);
    }

    public ImportTask(String taskID, List<String> ldifFiles, String backendID, boolean append, boolean replaceExisting, String rejectFile, boolean overwriteRejects, boolean clearBackend, List<String> includeBranches, List<String> excludeBranches, List<String> includeFilters, List<String> excludeFilters, List<String> includeAttributes, List<String> excludeAttributes, boolean isCompressed, boolean isEncrypted, boolean skipSchemaValidation, Date scheduledStartTime, List<String> dependencyIDs, FailedDependencyAction failedDependencyAction, List<String> notifyOnCompletion, List<String> notifyOnError) {
        this(taskID, ldifFiles, backendID, append, replaceExisting, rejectFile, overwriteRejects, clearBackend, includeBranches, excludeBranches, includeFilters, excludeFilters, includeAttributes, excludeAttributes, isCompressed, isEncrypted, skipSchemaValidation, false, scheduledStartTime, dependencyIDs, failedDependencyAction, notifyOnCompletion, notifyOnError);
    }

    public ImportTask(String taskID, List<String> ldifFiles, String backendID, boolean append, boolean replaceExisting, String rejectFile, boolean overwriteRejects, boolean clearBackend, List<String> includeBranches, List<String> excludeBranches, List<String> includeFilters, List<String> excludeFilters, List<String> includeAttributes, List<String> excludeAttributes, boolean isCompressed, boolean isEncrypted, boolean skipSchemaValidation, boolean stripTrailingSpaces, Date scheduledStartTime, List<String> dependencyIDs, FailedDependencyAction failedDependencyAction, List<String> notifyOnCompletion, List<String> notifyOnError) {
        super(taskID, IMPORT_TASK_CLASS, scheduledStartTime, dependencyIDs, failedDependencyAction, notifyOnCompletion, notifyOnError);
        Validator.ensureNotNull(ldifFiles);
        Validator.ensureFalse(ldifFiles.isEmpty(), "ImportTask.ldifFiles must not be empty.");
        Validator.ensureFalse(backendID == null && (includeBranches == null || includeBranches.isEmpty()));
        Validator.ensureTrue(clearBackend || append || includeBranches != null && !includeBranches.isEmpty());
        this.ldifFiles = Collections.unmodifiableList(ldifFiles);
        this.backendID = backendID;
        this.append = append;
        this.replaceExisting = replaceExisting;
        this.rejectFile = rejectFile;
        this.overwriteRejects = overwriteRejects;
        this.clearBackend = clearBackend;
        this.isCompressed = isCompressed;
        this.isEncrypted = isEncrypted;
        this.skipSchemaValidation = skipSchemaValidation;
        this.stripTrailingSpaces = stripTrailingSpaces;
        this.includeBranches = includeBranches == null ? Collections.emptyList() : Collections.unmodifiableList(includeBranches);
        this.excludeBranches = excludeBranches == null ? Collections.emptyList() : Collections.unmodifiableList(excludeBranches);
        this.includeFilters = includeFilters == null ? Collections.emptyList() : Collections.unmodifiableList(includeFilters);
        this.excludeFilters = excludeFilters == null ? Collections.emptyList() : Collections.unmodifiableList(excludeFilters);
        this.includeAttributes = includeAttributes == null ? Collections.emptyList() : Collections.unmodifiableList(includeAttributes);
        this.excludeAttributes = excludeAttributes == null ? Collections.emptyList() : Collections.unmodifiableList(excludeAttributes);
    }

    public ImportTask(Entry entry) throws TaskException {
        super(entry);
        String[] files = entry.getAttributeValues(ATTR_LDIF_FILE);
        if (files == null || files.length == 0) {
            throw new TaskException(TaskMessages.ERR_IMPORT_TASK_NO_LDIF.get(this.getTaskEntryDN()));
        }
        this.ldifFiles = Collections.unmodifiableList(Arrays.asList(files));
        this.backendID = entry.getAttributeValue(ATTR_BACKEND_ID);
        this.append = ImportTask.parseBooleanValue(entry, ATTR_APPEND, false);
        this.replaceExisting = ImportTask.parseBooleanValue(entry, ATTR_REPLACE_EXISTING, false);
        this.rejectFile = entry.getAttributeValue(ATTR_REJECT_FILE);
        this.overwriteRejects = ImportTask.parseBooleanValue(entry, ATTR_OVERWRITE_REJECTS, false);
        this.clearBackend = ImportTask.parseBooleanValue(entry, ATTR_CLEAR_BACKEND, false);
        this.includeBranches = ImportTask.parseStringList(entry, ATTR_INCLUDE_BRANCH);
        this.excludeBranches = ImportTask.parseStringList(entry, ATTR_EXCLUDE_BRANCH);
        this.includeFilters = ImportTask.parseStringList(entry, ATTR_INCLUDE_FILTER);
        this.excludeFilters = ImportTask.parseStringList(entry, ATTR_EXCLUDE_FILTER);
        this.includeAttributes = ImportTask.parseStringList(entry, ATTR_INCLUDE_ATTRIBUTE);
        this.excludeAttributes = ImportTask.parseStringList(entry, ATTR_EXCLUDE_ATTRIBUTE);
        this.isCompressed = ImportTask.parseBooleanValue(entry, ATTR_IS_COMPRESSED, false);
        this.isEncrypted = ImportTask.parseBooleanValue(entry, ATTR_IS_ENCRYPTED, false);
        this.skipSchemaValidation = ImportTask.parseBooleanValue(entry, ATTR_SKIP_SCHEMA_VALIDATION, false);
        this.stripTrailingSpaces = ImportTask.parseBooleanValue(entry, ATTR_STRIP_TRAILING_SPACES, false);
    }

    public ImportTask(Map<TaskProperty, List<Object>> properties) throws TaskException {
        super(IMPORT_TASK_CLASS, properties);
        boolean a = false;
        boolean c = false;
        boolean cB = true;
        boolean e = false;
        boolean o = false;
        boolean r = false;
        boolean ss = false;
        boolean st = false;
        String b = null;
        String rF = null;
        String[] eA = StaticUtils.NO_STRINGS;
        String[] eB = StaticUtils.NO_STRINGS;
        String[] eF = StaticUtils.NO_STRINGS;
        String[] iA = StaticUtils.NO_STRINGS;
        String[] iB = StaticUtils.NO_STRINGS;
        String[] iF = StaticUtils.NO_STRINGS;
        String[] l = StaticUtils.NO_STRINGS;
        for (Map.Entry<TaskProperty, List<Object>> entry : properties.entrySet()) {
            TaskProperty p = entry.getKey();
            String attrName = p.getAttributeName();
            List<Object> values = entry.getValue();
            if (attrName.equalsIgnoreCase(ATTR_BACKEND_ID)) {
                b = ImportTask.parseString(p, values, b);
                continue;
            }
            if (attrName.equalsIgnoreCase(ATTR_LDIF_FILE)) {
                l = ImportTask.parseStrings(p, values, l);
                continue;
            }
            if (attrName.equalsIgnoreCase(ATTR_APPEND)) {
                a = ImportTask.parseBoolean(p, values, a);
                continue;
            }
            if (attrName.equalsIgnoreCase(ATTR_REPLACE_EXISTING)) {
                r = ImportTask.parseBoolean(p, values, r);
                continue;
            }
            if (attrName.equalsIgnoreCase(ATTR_REJECT_FILE)) {
                rF = ImportTask.parseString(p, values, rF);
                continue;
            }
            if (attrName.equalsIgnoreCase(ATTR_OVERWRITE_REJECTS)) {
                o = ImportTask.parseBoolean(p, values, o);
                continue;
            }
            if (attrName.equalsIgnoreCase(ATTR_CLEAR_BACKEND)) {
                cB = ImportTask.parseBoolean(p, values, cB);
                continue;
            }
            if (attrName.equalsIgnoreCase(ATTR_INCLUDE_BRANCH)) {
                iB = ImportTask.parseStrings(p, values, iB);
                continue;
            }
            if (attrName.equalsIgnoreCase(ATTR_EXCLUDE_BRANCH)) {
                eB = ImportTask.parseStrings(p, values, eB);
                continue;
            }
            if (attrName.equalsIgnoreCase(ATTR_INCLUDE_FILTER)) {
                iF = ImportTask.parseStrings(p, values, iF);
                continue;
            }
            if (attrName.equalsIgnoreCase(ATTR_EXCLUDE_FILTER)) {
                eF = ImportTask.parseStrings(p, values, eF);
                continue;
            }
            if (attrName.equalsIgnoreCase(ATTR_INCLUDE_ATTRIBUTE)) {
                iA = ImportTask.parseStrings(p, values, iA);
                continue;
            }
            if (attrName.equalsIgnoreCase(ATTR_EXCLUDE_ATTRIBUTE)) {
                eA = ImportTask.parseStrings(p, values, eA);
                continue;
            }
            if (attrName.equalsIgnoreCase(ATTR_IS_COMPRESSED)) {
                c = ImportTask.parseBoolean(p, values, c);
                continue;
            }
            if (attrName.equalsIgnoreCase(ATTR_IS_ENCRYPTED)) {
                e = ImportTask.parseBoolean(p, values, e);
                continue;
            }
            if (attrName.equalsIgnoreCase(ATTR_SKIP_SCHEMA_VALIDATION)) {
                ss = ImportTask.parseBoolean(p, values, ss);
                continue;
            }
            if (!attrName.equalsIgnoreCase(ATTR_STRIP_TRAILING_SPACES)) continue;
            st = ImportTask.parseBoolean(p, values, st);
        }
        if (b == null && iB.length == 0) {
            throw new TaskException(TaskMessages.ERR_IMPORT_TASK_NO_BACKEND_ID_OR_INCLUDE_BRANCHES.get(this.getTaskEntryDN()));
        }
        if (l == null) {
            throw new TaskException(TaskMessages.ERR_IMPORT_TASK_NO_LDIF.get(this.getTaskEntryDN()));
        }
        this.backendID = b;
        this.ldifFiles = Collections.unmodifiableList(Arrays.asList(l));
        this.append = a;
        this.replaceExisting = r;
        this.rejectFile = rF;
        this.overwriteRejects = o;
        this.clearBackend = cB;
        this.includeAttributes = Collections.unmodifiableList(Arrays.asList(iA));
        this.excludeAttributes = Collections.unmodifiableList(Arrays.asList(eA));
        this.includeBranches = Collections.unmodifiableList(Arrays.asList(iB));
        this.excludeBranches = Collections.unmodifiableList(Arrays.asList(eB));
        this.includeFilters = Collections.unmodifiableList(Arrays.asList(iF));
        this.excludeFilters = Collections.unmodifiableList(Arrays.asList(eF));
        this.isCompressed = c;
        this.isEncrypted = e;
        this.skipSchemaValidation = ss;
        this.stripTrailingSpaces = st;
    }

    @Override
    public String getTaskName() {
        return TaskMessages.INFO_TASK_NAME_IMPORT.get();
    }

    @Override
    public String getTaskDescription() {
        return TaskMessages.INFO_TASK_DESCRIPTION_IMPORT.get();
    }

    public List<String> getLDIFFiles() {
        return this.ldifFiles;
    }

    public String getBackendID() {
        return this.backendID;
    }

    public boolean append() {
        return this.append;
    }

    public boolean replaceExistingEntries() {
        return this.replaceExisting;
    }

    public String getRejectFile() {
        return this.rejectFile;
    }

    public boolean overwriteRejectFile() {
        return this.overwriteRejects;
    }

    public boolean clearBackend() {
        return this.clearBackend;
    }

    public List<String> getIncludeBranches() {
        return this.includeBranches;
    }

    public List<String> getExcludeBranches() {
        return this.excludeBranches;
    }

    public List<String> getIncludeFilters() {
        return this.includeFilters;
    }

    public List<String> getExcludeFilters() {
        return this.excludeFilters;
    }

    public List<String> getIncludeAttributes() {
        return this.includeAttributes;
    }

    public List<String> getExcludeAttributes() {
        return this.excludeAttributes;
    }

    public boolean isCompressed() {
        return this.isCompressed;
    }

    public boolean isEncrypted() {
        return this.isEncrypted;
    }

    public boolean skipSchemaValidation() {
        return this.skipSchemaValidation;
    }

    public boolean stripTrailingSpaces() {
        return this.stripTrailingSpaces;
    }

    @Override
    protected List<String> getAdditionalObjectClasses() {
        return Arrays.asList(OC_IMPORT_TASK);
    }

    @Override
    protected List<Attribute> getAdditionalAttributes() {
        ArrayList<Attribute> attrs = new ArrayList<Attribute>(16);
        attrs.add(new Attribute(ATTR_LDIF_FILE, this.ldifFiles));
        attrs.add(new Attribute(ATTR_APPEND, String.valueOf(this.append)));
        attrs.add(new Attribute(ATTR_REPLACE_EXISTING, String.valueOf(this.replaceExisting)));
        attrs.add(new Attribute(ATTR_OVERWRITE_REJECTS, String.valueOf(this.overwriteRejects)));
        attrs.add(new Attribute(ATTR_CLEAR_BACKEND, String.valueOf(this.clearBackend)));
        attrs.add(new Attribute(ATTR_IS_COMPRESSED, String.valueOf(this.isCompressed)));
        attrs.add(new Attribute(ATTR_IS_ENCRYPTED, String.valueOf(this.isEncrypted)));
        attrs.add(new Attribute(ATTR_SKIP_SCHEMA_VALIDATION, String.valueOf(this.skipSchemaValidation)));
        if (this.stripTrailingSpaces) {
            attrs.add(new Attribute(ATTR_STRIP_TRAILING_SPACES, String.valueOf(this.stripTrailingSpaces)));
        }
        if (this.backendID != null) {
            attrs.add(new Attribute(ATTR_BACKEND_ID, this.backendID));
        }
        if (this.rejectFile != null) {
            attrs.add(new Attribute(ATTR_REJECT_FILE, this.rejectFile));
        }
        if (!this.includeBranches.isEmpty()) {
            attrs.add(new Attribute(ATTR_INCLUDE_BRANCH, this.includeBranches));
        }
        if (!this.excludeBranches.isEmpty()) {
            attrs.add(new Attribute(ATTR_EXCLUDE_BRANCH, this.excludeBranches));
        }
        if (!this.includeAttributes.isEmpty()) {
            attrs.add(new Attribute(ATTR_INCLUDE_ATTRIBUTE, this.includeAttributes));
        }
        if (!this.excludeAttributes.isEmpty()) {
            attrs.add(new Attribute(ATTR_EXCLUDE_ATTRIBUTE, this.excludeAttributes));
        }
        if (!this.includeFilters.isEmpty()) {
            attrs.add(new Attribute(ATTR_INCLUDE_FILTER, this.includeFilters));
        }
        if (!this.excludeFilters.isEmpty()) {
            attrs.add(new Attribute(ATTR_EXCLUDE_FILTER, this.excludeFilters));
        }
        return attrs;
    }

    @Override
    public List<TaskProperty> getTaskSpecificProperties() {
        List<TaskProperty> propList = Arrays.asList(PROPERTY_BACKEND_ID, PROPERTY_LDIF_FILE, PROPERTY_APPEND, PROPERTY_REPLACE_EXISTING, PROPERTY_REJECT_FILE, PROPERTY_OVERWRITE_REJECTS, PROPERTY_CLEAR_BACKEND, PROPERTY_INCLUDE_BRANCH, PROPERTY_EXCLUDE_BRANCH, PROPERTY_INCLUDE_FILTER, PROPERTY_EXCLUDE_FILTER, PROPERTY_INCLUDE_ATTRIBUTE, PROPERTY_EXCLUDE_ATTRIBUTE, PROPERTY_IS_COMPRESSED, PROPERTY_IS_ENCRYPTED, PROPERTY_SKIP_SCHEMA_VALIDATION, PROPERTY_STRIP_TRAILING_SPACES);
        return Collections.unmodifiableList(propList);
    }

    @Override
    public Map<TaskProperty, List<Object>> getTaskPropertyValues() {
        LinkedHashMap<TaskProperty, List<Object>> props = new LinkedHashMap<TaskProperty, List<Object>>();
        if (this.backendID == null) {
            props.put(PROPERTY_BACKEND_ID, Collections.emptyList());
        } else {
            props.put(PROPERTY_BACKEND_ID, Collections.unmodifiableList(Arrays.asList(this.backendID)));
        }
        props.put(PROPERTY_LDIF_FILE, Collections.unmodifiableList(this.ldifFiles));
        props.put(PROPERTY_APPEND, Collections.unmodifiableList(Arrays.asList(this.append)));
        props.put(PROPERTY_REPLACE_EXISTING, Collections.unmodifiableList(Arrays.asList(this.replaceExisting)));
        if (this.rejectFile == null) {
            props.put(PROPERTY_REJECT_FILE, Collections.emptyList());
        } else {
            props.put(PROPERTY_REJECT_FILE, Collections.unmodifiableList(Arrays.asList(this.rejectFile)));
        }
        props.put(PROPERTY_OVERWRITE_REJECTS, Collections.unmodifiableList(Arrays.asList(this.overwriteRejects)));
        props.put(PROPERTY_CLEAR_BACKEND, Collections.unmodifiableList(Arrays.asList(this.clearBackend)));
        props.put(PROPERTY_INCLUDE_BRANCH, Collections.unmodifiableList(this.includeBranches));
        props.put(PROPERTY_EXCLUDE_BRANCH, Collections.unmodifiableList(this.excludeBranches));
        props.put(PROPERTY_INCLUDE_FILTER, Collections.unmodifiableList(this.includeFilters));
        props.put(PROPERTY_EXCLUDE_FILTER, Collections.unmodifiableList(this.excludeFilters));
        props.put(PROPERTY_INCLUDE_ATTRIBUTE, Collections.unmodifiableList(this.includeAttributes));
        props.put(PROPERTY_EXCLUDE_ATTRIBUTE, Collections.unmodifiableList(this.excludeAttributes));
        props.put(PROPERTY_IS_COMPRESSED, Collections.unmodifiableList(Arrays.asList(this.isCompressed)));
        props.put(PROPERTY_IS_ENCRYPTED, Collections.unmodifiableList(Arrays.asList(this.isEncrypted)));
        props.put(PROPERTY_SKIP_SCHEMA_VALIDATION, Collections.unmodifiableList(Arrays.asList(this.skipSchemaValidation)));
        props.put(PROPERTY_STRIP_TRAILING_SPACES, Collections.unmodifiableList(Arrays.asList(this.stripTrailingSpaces)));
        props.putAll(super.getTaskPropertyValues());
        return Collections.unmodifiableMap(props);
    }
}

