/*
 * Decompiled with CFR 0.152.
 */
package jdk.incubator.http;

import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import jdk.incubator.http.AsyncSSLConnection;
import jdk.incubator.http.Exchange;
import jdk.incubator.http.Http1Exchange;
import jdk.incubator.http.Http2ClientImpl;
import jdk.incubator.http.Http2Connection;
import jdk.incubator.http.HttpClient;
import jdk.incubator.http.HttpConnection;
import jdk.incubator.http.HttpRequestImpl;
import jdk.incubator.http.HttpResponse;
import jdk.incubator.http.Response;
import jdk.incubator.http.SSLConnection;
import jdk.incubator.http.internal.common.MinimalFuture;

abstract class ExchangeImpl<T> {
    final Exchange<T> exchange;

    ExchangeImpl(Exchange<T> exchange) {
        this.exchange = exchange;
    }

    final Exchange<T> getExchange() {
        return this.exchange;
    }

    abstract HttpConnection connection();

    static <U> ExchangeImpl<U> get(Exchange<U> exchange, HttpConnection httpConnection) throws IOException, InterruptedException {
        Http2Connection http2Connection;
        HttpRequestImpl httpRequestImpl = exchange.request();
        if (exchange.version() == HttpClient.Version.HTTP_1_1) {
            return new Http1Exchange<U>(exchange, httpConnection);
        }
        Http2ClientImpl http2ClientImpl = exchange.client().client2();
        HttpRequestImpl httpRequestImpl2 = exchange.request();
        try {
            http2Connection = http2ClientImpl.getConnectionFor(httpRequestImpl2);
        }
        catch (Http2Connection.ALPNException aLPNException) {
            AsyncSSLConnection asyncSSLConnection = aLPNException.getConnection();
            asyncSSLConnection.stopAsyncReading();
            SSLConnection sSLConnection = new SSLConnection(asyncSSLConnection);
            Http1Exchange<U> http1Exchange = new Http1Exchange<U>(exchange, sSLConnection);
            return http1Exchange;
        }
        if (http2Connection == null) {
            Http1Exchange<U> http1Exchange = new Http1Exchange<U>(exchange, httpConnection);
            exchange.h2Upgrade();
            return http1Exchange;
        }
        return http2Connection.createStream(exchange);
    }

    abstract void sendHeadersOnly() throws IOException, InterruptedException;

    CompletableFuture<ExchangeImpl<T>> sendHeadersAsync() {
        return MinimalFuture.supply(() -> {
            this.sendHeadersOnly();
            return this;
        });
    }

    abstract Response getResponse() throws IOException;

    abstract T readBody(HttpResponse.BodyHandler<T> var1, boolean var2) throws IOException;

    abstract CompletableFuture<T> readBodyAsync(HttpResponse.BodyHandler<T> var1, boolean var2, Executor var3);

    abstract CompletableFuture<Response> getResponseAsync(Executor var1);

    abstract void sendBody() throws IOException, InterruptedException;

    CompletableFuture<ExchangeImpl<T>> sendBodyAsync() {
        return MinimalFuture.supply(() -> {
            this.sendBody();
            return this;
        });
    }

    abstract void cancel();

    abstract void cancel(IOException var1);
}

