/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.spec.context.server;

import ee.jakarta.tck.ws.rs.common.JAXRSCommonClient;
import ee.jakarta.tck.ws.rs.common.client.JaxrsCommonClient;
import ee.jakarta.tck.ws.rs.common.provider.PrintingErrorHandler;
import ee.jakarta.tck.ws.rs.common.provider.StringBean;
import ee.jakarta.tck.ws.rs.common.provider.StringBeanEntityProvider;
import ee.jakarta.tck.ws.rs.lib.util.TestUtil;
import ee.jakarta.tck.ws.rs.spec.context.server.Resource;
import ee.jakarta.tck.ws.rs.spec.context.server.SingletonWithInjectables;
import ee.jakarta.tck.ws.rs.spec.context.server.StringBeanEntityProviderWithInjectables;
import ee.jakarta.tck.ws.rs.spec.context.server.TSAppConfig;
import java.io.IOException;
import java.io.InputStream;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
public class JAXRSClientIT
extends JaxrsCommonClient {
    public JAXRSClientIT() {
        this.setup();
        this.setContextRoot("/jaxrs_spec_context_server_web/resource");
    }

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        InputStream inStream = JAXRSClientIT.class.getClassLoader().getResourceAsStream("ee/jakarta/tck/ws/rs/spec/context/server/web.xml.template");
        String webXml = JAXRSClientIT.editWebXmlString(inStream);
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"jaxrs_spec_context_server_web.war");
        archive.addClasses(new Class[]{TSAppConfig.class, Resource.class, SingletonWithInjectables.class, StringBeanEntityProviderWithInjectables.class, StringBeanEntityProvider.class, PrintingErrorHandler.class, StringBean.class});
        archive.setWebXML((Asset)new StringAsset(webXml));
        return archive;
    }

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        TestUtil.logMsg("STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        TestUtil.logMsg("FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Test
    public void serverWriterInjectionTest() throws JAXRSCommonClient.Fault {
        this.setRequestContentEntity("");
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, "writer"));
        this.invoke();
        this.assertInjection("@Context injection did not work properly:");
    }

    @Test
    public void serverReaderInjectionTest() throws JAXRSCommonClient.Fault {
        this.setRequestContentEntity("");
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, "reader"));
        this.invoke();
        this.assertInjection("@Context injection did not work properly:");
    }

    @Test
    public void resourceInjectionTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "instance"));
        this.invoke();
        this.assertInjection("@Context injection did not work properly:");
    }

    @Test
    public void applicationInjectionTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "application"));
        this.invoke();
        this.assertInjection("@Context injection did not work properly:");
    }

    @Test
    public void methodArgumentsInjectionTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "method"));
        this.invoke();
        this.assertInjection("@Context injection did not work properly:");
    }

    private void assertInjection(String body, Object failMessage) throws JAXRSCommonClient.Fault {
        String notInjected = StringBeanEntityProviderWithInjectables.notInjected(body);
        JAXRSClientIT.assertEquals("111111111", body, failMessage, notInjected, "has not been injected");
        JAXRSClientIT.logMsg("@Context injected as expected");
    }

    private void assertInjection(Object failMessage) throws JAXRSCommonClient.Fault {
        String body = this.getResponseBody();
        this.assertInjection(body, failMessage);
    }
}

