/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.pdt.introspector.core.launcher;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.egf.core.producer.InvocationException;
import org.eclipse.egf.ftask.producer.context.ITaskProductionContext;
import org.eclipse.egf.ftask.producer.invocation.ITaskProduction;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.statushandlers.StatusManager;
import org.polarsys.kitalpha.pdt.introspector.core.IntrospectionContext;
import org.polarsys.kitalpha.pdt.introspector.core.exceptions.IntrospectionExceptions;
import org.polarsys.kitalpha.pdt.introspector.core.launcher.Introspector;
import org.polarsys.kitalpha.pdt.introspector.core.messages.Messages;
import org.polarsys.kitalpha.pdt.introspector.core.services.PlatformServices;
import org.polarsys.kitalpha.pdt.introspector.preferences.utils.IntrospectorPreferenceUtils;
import org.polarsys.kitalpha.pdt.metamodel.model.platform.EclipseModel;
import org.polarsys.kitalpha.pdt.metamodel.model.platform.PlatformFactory;
import org.polarsys.kitalpha.resourcereuse.model.SearchCriteria;

public class Introspection
implements IActionDelegate,
ITaskProduction {
    private static String modelPath;
    public static final IntrospectionContext introContext;
    private static IFolder folder;
    private IPath path;
    private String projectName;
    private String outputFolder;
    private EclipseModel result = null;

    static {
        introContext = new IntrospectionContext();
    }

    public static EclipseModel launchIntrospectionUsingSpecificContext() {
        EclipseModel myEclipseModel = PlatformFactory.eINSTANCE.createEclipseModel();
        try {
            myEclipseModel = Introspector.introspect(myEclipseModel, null, introContext, null);
        }
        catch (IntrospectionExceptions e) {
            Status errorStatus = new Status(4, "org.polarsys.kitalpha.pdt.introspector.core", Messages.ErrorPlatformInterospectionInvocation, (Throwable)e);
            StatusManager.getManager().handle((IStatus)errorStatus);
        }
        return myEclipseModel;
    }

    public static IntrospectionContext getIntroContextInstance() {
        return introContext;
    }

    public static void setUpContextRelativeToAutoDeliveryAndLaunchIntrospection() {
        introContext.setActivateIncrementalIntrospection(false);
        introContext.setCreatePackages(false);
        introContext.setStoreIntrospectionIssues(false);
        introContext.setIntrospectionPerimeter(Messages.WorkspaceOnlyIntrospectionPerimeter);
    }

    public static void setUpContextAccordingToPreferences() {
        String introspectionPerimeter = IntrospectorPreferenceUtils.getIntrospectionPerimeter();
        introContext.setIntrospectionPerimeter(introspectionPerimeter);
        boolean activateIncrementalIntrospection = IntrospectorPreferenceUtils.getActivateIncrementalIntrospection();
        introContext.setActivateIncrementalIntrospection(activateIncrementalIntrospection);
        String incrementalIntrospection = IntrospectorPreferenceUtils.getIncrementalIntrospection();
        introContext.setIncrementalIntrospection(incrementalIntrospection);
        boolean createPackages = IntrospectorPreferenceUtils.getCreatePackageSetting();
        introContext.setCreatePackages(createPackages);
        boolean storeIntrospectionIssue = IntrospectorPreferenceUtils.getStoreIntrospectionIssue();
        introContext.setStoreIntrospectionIssues(storeIntrospectionIssue);
        boolean qualifierMatch = IntrospectorPreferenceUtils.getQualifierMatch();
        introContext.setQualifierMatch(qualifierMatch);
        SearchCriteria criteria = IntrospectorPreferenceUtils.getCriteria();
        introContext.setCriteria(criteria);
    }

    public void run(IAction action) {
        ProgressMonitorDialog pd = new ProgressMonitorDialog(null);
        try {
            pd.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    Introspection.startIntrospection(monitor, folder, true);
                }
            });
        }
        catch (InvocationTargetException e) {
            Status errorStatus = new Status(4, "org.polarsys.kitalpha.pdt.introspector.core", Messages.ErrorPlatformInterospectionInvocation, (Throwable)e);
            StatusManager.getManager().handle((IStatus)errorStatus);
        }
        catch (InterruptedException e) {
            Status warningStatus = new Status(2, "org.polarsys.kitalpha.pdt.introspector.core", Messages.WarningPlatformIntrospectionException, (Throwable)e);
            StatusManager.getManager().handle((IStatus)warningStatus);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            Iterator iterator = structuredSelection.iterator();
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IWorkspaceRoot root = workspace.getRoot();
            IPath location = root.getLocation();
            while (iterator.hasNext()) {
                Object obj = iterator.next();
                if (!(obj instanceof IFolder)) continue;
                folder = (IFolder)obj;
                IPath fullPath = folder.getFullPath();
                File file = new File(String.valueOf(location.toString()) + fullPath.toString());
                modelPath = file.getAbsolutePath();
            }
        }
    }

    public void preExecute(ITaskProductionContext productionContext, IProgressMonitor monitor) throws InvocationException {
        this.projectName = (String)productionContext.getInputValue((Object)"projectName", String.class);
        this.outputFolder = (String)productionContext.getInputValue((Object)"outputFolder", String.class);
        this.path = new Path(String.valueOf(this.projectName) + "/" + this.outputFolder);
        folder = ResourcesPlugin.getWorkspace().getRoot().getFolder(this.path);
        if (!folder.exists()) {
            try {
                folder.create(true, true, null);
            }
            catch (CoreException e) {
                String message = NLS.bind((String)Messages.FolderDoesNotExist_Creation_Information, (Object)folder.getLocation());
                Status infoStatus = new Status(1, "org.polarsys.kitalpha.pdt.introspector.core", message);
                StatusManager.getManager().handle((IStatus)infoStatus);
            }
        }
        modelPath = folder.getLocation().toString();
    }

    public void doExecute(ITaskProductionContext productionContext, IProgressMonitor monitor) throws InvocationException {
        Introspection.startIntrospection(monitor, folder, true);
    }

    public void postExecute(ITaskProductionContext productionContext, IProgressMonitor monitor) throws InvocationException {
        if (!monitor.isCanceled()) {
            ResourceSet resourceSet = introContext.getResourceSet();
            PlatformServices.savePlatformModel(this.result, modelPath, resourceSet, introContext);
            introContext.reset();
        }
    }

    public static void startIntrospection(IProgressMonitor monitor, IFolder destinationFolder, boolean usePreferences) {
        EclipseModel myEclipseModel = PlatformFactory.eINSTANCE.createEclipseModel();
        String modelName = introContext.getModelName();
        if (!modelName.isEmpty()) {
            myEclipseModel.setName(modelName);
        } else {
            myEclipseModel.setName("Eclipse Model");
        }
        if (usePreferences) {
            Introspection.setUpContextAccordingToPreferences();
        }
        folder = destinationFolder;
        EclipseModel result = null;
        try {
            result = Introspector.introspect(myEclipseModel, monitor, introContext, folder);
        }
        catch (IntrospectionExceptions e) {
            Status warningStatus = new Status(2, "org.polarsys.kitalpha.pdt.introspector.core", Messages.WarningPlatformIntrospectionException, (Throwable)e);
            StatusManager.getManager().handle((IStatus)warningStatus);
            introContext.reset();
        }
        if (!monitor.isCanceled()) {
            ResourceSet resourceSet = introContext.getResourceSet();
            modelPath = folder.getLocation().toString();
            PlatformServices.savePlatformModel(result, modelPath, resourceSet, introContext);
            introContext.reset();
        }
    }
}

