/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.man.help;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.help.ITopic;
import org.eclipse.help.IUAElement;
import org.eclipse.linuxtools.internal.man.help.PageTopic;

public class SectionTopic
implements ITopic,
Comparable<SectionTopic> {
    private final String displaySectionId;
    private final String label;
    private final Set<PageTopic> pages = new HashSet<PageTopic>();

    public SectionTopic(String displaySectionId, String label) {
        this.displaySectionId = displaySectionId;
        this.label = label;
    }

    public void addPage(String sectionId, String pageId) {
        PageTopic page = new PageTopic(sectionId, pageId);
        this.pages.add(page);
    }

    public boolean isEnabled(IEvaluationContext context) {
        return true;
    }

    public IUAElement[] getChildren() {
        return this.getSubtopics();
    }

    public String getHref() {
        return null;
    }

    public String getLabel() {
        return this.label;
    }

    public ITopic[] getSubtopics() {
        ArrayList<PageTopic> pageList = new ArrayList<PageTopic>(this.pages);
        Collections.sort(pageList);
        return pageList.toArray(new PageTopic[pageList.size()]);
    }

    @Override
    public int compareTo(SectionTopic o) {
        return this.displaySectionId.compareTo(o.displaySectionId);
    }
}

