/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.rpm.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.linuxtools.rpm.core.IProjectConfiguration;

public class RPMBuildConfiguration
implements IProjectConfiguration {
    private IProject project;
    private IFolder rpmsFolder;
    private IFolder srpmsFolder;
    private IFolder specsFolder;
    private IFolder sourcesFolder;
    private IFolder buildFolder;
    private List<String> configDefines = new ArrayList<String>();

    public RPMBuildConfiguration(IProject project) throws CoreException {
        this.project = project;
        this.initialize();
    }

    private void initialize() throws CoreException {
        String pluginID = "org.eclipse.linuxtools.rpm.core";
        String sourcesPath = this.project.getPersistentProperty(new QualifiedName(pluginID, "SOURCES"));
        if (sourcesPath == null) {
            this.sourcesFolder = this.project.getFolder("SOURCES");
            if (!this.sourcesFolder.exists()) {
                this.sourcesFolder.create(false, true, null);
            }
            this.project.setPersistentProperty(new QualifiedName(pluginID, "SOURCES"), this.sourcesFolder.getName());
        } else {
            this.sourcesFolder = this.project.getFolder(sourcesPath);
            if (!this.sourcesFolder.exists()) {
                this.sourcesFolder.create(false, true, null);
            }
        }
        String srcRpmPath = this.project.getPersistentProperty(new QualifiedName(pluginID, "SRPMS"));
        if (srcRpmPath == null) {
            this.srpmsFolder = this.project.getFolder("SRPMS");
            if (!this.srpmsFolder.exists()) {
                this.srpmsFolder.create(false, true, null);
            }
            this.srpmsFolder.setDerived(true, (IProgressMonitor)new NullProgressMonitor());
            this.project.setPersistentProperty(new QualifiedName(pluginID, "SRPMS"), this.srpmsFolder.getName());
        } else {
            this.srpmsFolder = this.project.getFolder(srcRpmPath);
            if (!this.srpmsFolder.exists()) {
                this.srpmsFolder.create(false, true, null);
            }
        }
        String buildPath = this.project.getPersistentProperty(new QualifiedName(pluginID, "BUILD"));
        if (buildPath == null) {
            this.buildFolder = this.project.getFolder("BUILD");
            if (!this.buildFolder.exists()) {
                this.buildFolder.create(false, true, null);
            }
            this.buildFolder.setDerived(true, (IProgressMonitor)new NullProgressMonitor());
            this.project.setPersistentProperty(new QualifiedName(pluginID, "BUILD"), this.buildFolder.getName());
        } else {
            this.buildFolder = this.project.getFolder(buildPath);
            if (!this.buildFolder.exists()) {
                this.buildFolder.create(false, true, null);
            }
        }
        String rpmPath = this.project.getPersistentProperty(new QualifiedName(pluginID, "RPMS"));
        if (rpmPath == null) {
            this.rpmsFolder = this.project.getFolder("RPMS");
            if (!this.rpmsFolder.exists()) {
                this.rpmsFolder.create(false, true, null);
            }
            this.rpmsFolder.setDerived(true, (IProgressMonitor)new NullProgressMonitor());
            this.project.setPersistentProperty(new QualifiedName(pluginID, "RPMS"), this.rpmsFolder.getName());
        } else {
            this.rpmsFolder = this.project.getFolder(rpmPath);
            if (!this.rpmsFolder.exists()) {
                this.rpmsFolder.create(false, true, null);
            }
        }
        String specPath = this.project.getPersistentProperty(new QualifiedName(pluginID, "SPECS"));
        if (specPath == null) {
            this.specsFolder = this.project.getFolder("SPECS");
            if (!this.specsFolder.exists()) {
                this.specsFolder.create(false, true, null);
            }
            this.project.setPersistentProperty(new QualifiedName(pluginID, "SPECS"), this.specsFolder.getName());
        } else {
            this.specsFolder = this.project.getFolder(specPath);
            if (!this.specsFolder.exists()) {
                this.specsFolder.create(false, true, null);
            }
        }
        this.configDefines.add("--define");
        if (this.project.getLocationURI() == null) {
            this.configDefines.add("_sourcedir " + this.sourcesFolder.getLocation().toOSString());
            this.configDefines.add("--define");
            this.configDefines.add("_srcrpmdir " + this.srpmsFolder.getLocation().toOSString());
            this.configDefines.add("--define");
            this.configDefines.add("_builddir " + this.buildFolder.getLocation().toOSString());
            this.configDefines.add("--define");
            this.configDefines.add("_rpmdir " + this.rpmsFolder.getLocation().toOSString());
            this.configDefines.add("--define");
            this.configDefines.add("_specdir " + this.specsFolder.getLocation().toOSString());
        } else {
            String mainFolder = this.project.getLocationURI().getPath();
            this.configDefines.add("_sourcedir " + mainFolder + "/SOURCES");
            this.configDefines.add("--define");
            this.configDefines.add("_srcrpmdir " + mainFolder + "/SRPMS");
            this.configDefines.add("--define");
            this.configDefines.add("_builddir " + mainFolder + "/BUILD");
            this.configDefines.add("--define");
            this.configDefines.add("_rpmdir " + mainFolder + "/RPMS");
            this.configDefines.add("--define");
            this.configDefines.add("_specdir " + mainFolder + "/SPECS");
        }
    }

    public IFolder getBuildFolder() {
        return this.buildFolder;
    }

    public IFolder getRpmsFolder() {
        return this.rpmsFolder;
    }

    public IFolder getSourcesFolder() {
        return this.sourcesFolder;
    }

    public IFolder getSpecsFolder() {
        return this.specsFolder;
    }

    public IFolder getSrpmsFolder() {
        return this.srpmsFolder;
    }

    @Override
    public List<String> getConfigDefines() {
        return this.configDefines;
    }
}

