/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.engine.vm;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.m2m.atl.common.ATLLogger;
import org.eclipse.m2m.atl.engine.vm.ModelLoader;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMModel;

public abstract class AtlModelHandler {
    public static final String AMH_EMF = "EMF";
    private static String[] modelHandlers;
    private static Map defaultModelHandlers;

    static {
        defaultModelHandlers = new HashMap();
    }

    public static void registerDefaultHandler(String repository, AtlModelHandler handler) {
        defaultModelHandlers.put(repository, handler);
    }

    public static AtlModelHandler getDefault(String repository) {
        AtlModelHandler ret = (AtlModelHandler)defaultModelHandlers.get(repository);
        if (ret == null) {
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            if (registry == null) {
                throw new RuntimeException("Eclipse platform extension registry not found. Dynamic repository lookup does not work outside Eclipse.");
            }
            IExtensionPoint point = registry.getExtensionPoint("org.eclipse.m2m.atl.engine.vm.modelhandler");
            IExtension[] extensions = point.getExtensions();
            int i = 0;
            block2: while (i < extensions.length) {
                IConfigurationElement[] elements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < elements.length) {
                    try {
                        if (elements[j].getAttribute("name").equals(repository)) {
                            ret = (AtlModelHandler)elements[j].createExecutableExtension("class");
                            defaultModelHandlers.put(repository, ret);
                            break block2;
                        }
                    }
                    catch (CoreException e) {
                        ATLLogger.log((Level)Level.SEVERE, (String)e.getLocalizedMessage(), (Throwable)e);
                    }
                    ++j;
                }
                ++i;
            }
        }
        if (ret == null) {
            throw new RuntimeException("Model handler for " + repository + " not found. You may need to install a model handler plugin.");
        }
        return ret;
    }

    public static String[] getModelHandlers() {
        if (modelHandlers == null) {
            ArrayList<String> mhs = new ArrayList<String>();
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IExtensionPoint point = registry.getExtensionPoint("org.eclipse.m2m.atl.engine.vm.modelhandler");
            IExtension[] extensions = point.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] elements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < elements.length) {
                    mhs.add(elements[j].getAttribute("name"));
                    ++j;
                }
                ++i;
            }
            modelHandlers = mhs.toArray(new String[0]);
        }
        return modelHandlers;
    }

    public static String getHandlerName(ASMModel model) {
        String ret = null;
        Iterator i = defaultModelHandlers.keySet().iterator();
        while (i.hasNext() && ret == null) {
            String amhName = (String)i.next();
            AtlModelHandler amh = AtlModelHandler.getDefault(amhName);
            if (!amh.isHandling(model)) continue;
            ret = amhName;
        }
        return ret;
    }

    public static AtlModelHandler getHandler(ASMModel model) {
        return (AtlModelHandler)defaultModelHandlers.get(AtlModelHandler.getHandlerName(model));
    }

    public abstract boolean isHandling(ASMModel var1);

    public abstract ModelLoader createModelLoader();
}

