/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.emftvm.util;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.m2m.atl.common.ATLLogger;
import org.eclipse.m2m.atl.emftvm.CodeBlock;
import org.eclipse.m2m.atl.emftvm.EmftvmFactory;
import org.eclipse.m2m.atl.emftvm.ExecEnv;
import org.eclipse.m2m.atl.emftvm.Model;
import org.eclipse.m2m.atl.emftvm.Module;
import org.eclipse.m2m.atl.emftvm.Operation;
import org.eclipse.m2m.atl.emftvm.trace.SourceElement;
import org.eclipse.m2m.atl.emftvm.trace.SourceElementList;
import org.eclipse.m2m.atl.emftvm.trace.TargetElement;
import org.eclipse.m2m.atl.emftvm.trace.TraceLinkSet;
import org.eclipse.m2m.atl.emftvm.trace.TracedRule;
import org.eclipse.m2m.atl.emftvm.util.EMFTVMUtil;
import org.eclipse.m2m.atl.emftvm.util.LazyBag;
import org.eclipse.m2m.atl.emftvm.util.LazyBagOnCollection;
import org.eclipse.m2m.atl.emftvm.util.LazyCollection;
import org.eclipse.m2m.atl.emftvm.util.LazyList;
import org.eclipse.m2m.atl.emftvm.util.LazyListOnCollection;
import org.eclipse.m2m.atl.emftvm.util.LazyOrderedSet;
import org.eclipse.m2m.atl.emftvm.util.LazySet;
import org.eclipse.m2m.atl.emftvm.util.LazySetOnSet;
import org.eclipse.m2m.atl.emftvm.util.NativeCodeBlock;
import org.eclipse.m2m.atl.emftvm.util.NativeTypes;
import org.eclipse.m2m.atl.emftvm.util.StackFrame;
import org.eclipse.m2m.atl.emftvm.util.Tuple;
import org.eclipse.m2m.atl.emftvm.util.Types;
import org.eclipse.m2m.atl.emftvm.util.VMException;

public final class OCLOperations {
    private static OCLOperations instance;
    private final Module oclModule = EmftvmFactory.eINSTANCE.createModule();

    private OCLOperations() {
        this.oclModule.setName("OCL");
        this.createOperations();
    }

    public static OCLOperations getInstance() {
        if (instance == null) {
            instance = new OCLOperations();
        }
        return instance;
    }

    private void createOperations() {
        this.createOperation(false, "debug", Types.OCL_ANY_TYPE, Types.OCL_ANY_TYPE, new String[0][][], new NativeCodeBlock(){

            public Object execute(StackFrame frame) {
                Object object = frame.getLocal(0, 0);
                StringBuffer buf = new StringBuffer();
                if (object instanceof String) {
                    buf.append('\'');
                    buf.append((String)object);
                    buf.append('\'');
                } else if (object instanceof LazyCollection) {
                    buf.append(((LazyCollection)object).asString(frame.getEnv()));
                } else {
                    buf.append(EMFTVMUtil.toPrettyString(object, frame.getEnv()));
                }
                ATLLogger.info((String)buf.toString());
                return object;
            }
        });
        this.createOperation(false, "debug", Types.OCL_ANY_TYPE, Types.OCL_ANY_TYPE, new String[][][]{{{"message"}, Types.STRING_TYPE}}, new NativeCodeBlock(){

            public Object execute(StackFrame frame) {
                Object object = frame.getLocal(0, 0);
                StringBuffer buf = new StringBuffer((String)frame.getLocal(0, 1));
                buf.append(": ");
                if (object instanceof String) {
                    buf.append('\'');
                    buf.append((String)object);
                    buf.append('\'');
                } else if (object instanceof LazyCollection) {
                    buf.append(((LazyCollection)object).asString(frame.getEnv()));
                } else {
                    buf.append(EMFTVMUtil.toPrettyString(object, frame.getEnv()));
                }
                ATLLogger.info((String)buf.toString());
                return object;
            }
        });
        this.createOperation(false, "toString", Types.OCL_ANY_TYPE, Types.STRING_TYPE, new String[0][][], new NativeCodeBlock(){

            public Object execute(StackFrame frame) {
                Object object = frame.getLocal(0, 0);
                return EMFTVMUtil.toPrettyString(object, frame.getEnv());
            }
        });
        this.createOperation(false, "oclAsType", Types.OCL_ANY_TYPE, Types.OCL_ANY_TYPE, new String[][][]{{{"type"}, Types.CLASSIFIER_TYPE}}, new NativeCodeBlock(){

            public Object execute(StackFrame frame) {
                Object object = frame.getLocal(0, 0);
                EClassifier type = (EClassifier)frame.getLocal(0, 1);
                if (!type.isInstance(object)) {
                    throw new IllegalArgumentException(String.format("%s is not an instance of %s", object, type));
                }
                return object;
            }
        });
        this.createOperation(false, "oclAsType", Types.OCL_ANY_TYPE, Types.OCL_ANY_TYPE, new String[][][]{{{"type"}, Types.JAVA_CLASS_TYPE}}, new NativeCodeBlock(){

            public Object execute(StackFrame frame) {
                Object object = frame.getLocal(0, 0);
                Class type = (Class)frame.getLocal(0, 1);
                if (!type.isInstance(object)) {
                    throw new IllegalArgumentException(String.format("%s is not an instance of %s", object, type));
                }
                return object;
            }
        });
        this.createOperation(false, "oclIsTypeOf", Types.OCL_ANY_TYPE, Types.BOOLEAN_TYPE, new String[][][]{{{"type"}, Types.CLASSIFIER_TYPE}}, new NativeCodeBlock(){

            public Object execute(StackFrame frame) {
                Object o = frame.getLocal(0, 0);
                EClassifier type = (EClassifier)frame.getLocal(0, 1);
                if (type instanceof EClass) {
                    if (o instanceof EObject && ((EObject)o).eClass() == type) {
                        return true;
                    }
                    return false;
                }
                if (o != null) {
                    Class ic = type.getInstanceClass();
                    if (ic == null) {
                        throw new IllegalArgumentException(String.format("EClassifier %s must have an instance class", type));
                    }
                    if (o.getClass() == ic) {
                        return true;
                    }
                    return false;
                }
                return false;
            }
        });
        this.createOperation(false, "oclIsTypeOf", Types.OCL_ANY_TYPE, Types.BOOLEAN_TYPE, new String[][][]{{{"type"}, Types.JAVA_CLASS_TYPE}}, new NativeCodeBlock(){

            public Object execute(StackFrame frame) {
                Object o = frame.getLocal(0, 0);
                Class type = (Class)frame.getLocal(0, 1);
                return o != null ? o.getClass() == type : false;
            }
        });
        this.createOperation(false, "oclIsKindOf", Types.OCL_ANY_TYPE, Types.BOOLEAN_TYPE, new String[][][]{{{"type"}, Types.CLASSIFIER_TYPE}}, new NativeCodeBlock(){

            public Object execute(StackFrame frame) {
                Object o = frame.getLocal(0, 0);
                EClassifier type = (EClassifier)frame.getLocal(0, 1);
                return type.isInstance(o);
            }
        });
        this.createOperation(false, "oclIsKindOf", Types.OCL_ANY_TYPE, Types.BOOLEAN_TYPE, new String[][][]{{{"type"}, Types.JAVA_CLASS_TYPE}}, new NativeCodeBlock(){

            public Object execute(StackFrame frame) {
                Object o = frame.getLocal(0, 0);
                Class type = (Class)frame.getLocal(0, 1);
                return type.isInstance(o);
            }
        });
        this.createOperation(false, "oclType", Types.OCL_ANY_TYPE, Types.OCL_ANY_TYPE, new String[0][][], new NativeCodeBlock(){

            public Object execute(StackFrame frame) {
                Object o = frame.getLocal(0, 0);
                if (o instanceof EObject) {
                    return ((EObject)o).eClass();
                }
                if (o != null) {
                    return o.getClass();
                }
                return Void.TYPE;
            }
        });
        this.createOperation(false, "=", Types.OCL_ANY_TYPE, Types.BOOLEAN_TYPE, new String[][][]{{{"o"}, Types.OCL_ANY_TYPE}}, new NativeCodeBlock(){

            public Object execute(StackFrame frame) {
                Object o = frame.getLocal(0, 0);
                Object o2 = frame.getLocal(0, 1);
                return o == null ? o2 == null : o.equals(o2);
            }
        });
        this.createOperation(false, "=~", Types.OCL_ANY_TYPE, Types.BOOLEAN_TYPE, new String[][][]{{{"o"}, Types.OCL_ANY_TYPE}}, new NativeCodeBlock(){

            public Object execute(StackFrame frame) {
                Object o = frame.getLocal(0, 0);
                Object o2 = frame.getLocal(0, 1);
                return o == null ? o2 == null : o.equals(o2);
            }
        });
        this.createOperation(false, "=~|", Types.OCL_ANY_TYPE, Types.BOOLEAN_TYPE, new String[][][]{{{"o"}, Types.OCL_ANY_TYPE}}, new NativeCodeBlock(){

            public Object execute(StackFrame frame) {
                Object o = frame.getLocal(0, 0);
                Object o2 = frame.getLocal(0, 1);
                return o == null ? o2 == null : o.equals(o2);
            }
        });
        this.createOperation(false, "<>", Types.OCL_ANY_TYPE, Types.BOOLEAN_TYPE, new String[][][]{{{"o"}, Types.OCL_ANY_TYPE}}, new NativeCodeBlock(){

            public Object execute(StackFrame frame) {
                Object o = frame.getLocal(0, 0);
                Object o2 = frame.getLocal(0, 1);
                return !(o == null ? o2 == null : o.equals(o2));
            }
        });
        this.createOperation(false, "isInModel", Types.OCL_ANY_TYPE, Types.BOOLEAN_TYPE, new String[][][]{{{"model"}, Types.STRING_TYPE}}, new NativeCodeBlock(){

            public Object execute(StackFrame frame) {
                Object o = frame.getLocal(0, 0);
                if (o instanceof EObject) {
                    String mName = (String)frame.getLocal(0, 1);
                    ExecEnv env = frame.getEnv();
                    Model model = env.getInputModels().get(mName);
                    if (model == null) {
                        model = env.getInoutModels().get(mName);
                    }
                    if (model == null) {
                        model = env.getOutputModels().get(mName);
                    }
                    if (model != null) {
                        if (model.getResource() == ((EObject)o).eResource()) {
                            return true;
                        }
                        return false;
                    }
                    return false;
                }
                return false;
            }
        });
        this.createOperation(false, "refImmediateComposite", Types.OCL_ANY_TYPE, Types.OCL_ANY_TYPE, new String[0][][], new NativeCodeBlock(){

            public Object execute(StackFrame frame) {
                Object object = frame.getLocal(0, 0);
                if (object instanceof EObject) {
                    return ((EObject)object).eContainer();
                }
                throw new VMException(frame, String.format("Cannot retrieve immediate composite for regular objects: %s", object));
            }
        });
        this.createOperation(false, "refGetValue", Types.OCL_ANY_TYPE, Types.OCL_ANY_TYPE, new String[][][]{{{"propname"}, Types.STRING_TYPE}}, new NativeCodeBlock(){

            public Object execute(StackFrame frame) {
                Object object = frame.getLocal(0, 0);
                if (object instanceof EObject) {
                    String propname = (String)frame.getLocal(0, 1);
                    EObject eo = (EObject)object;
                    EClass ecls = eo.eClass();
                    EStructuralFeature sf = ecls.getEStructuralFeature(propname);
                    if (sf == null) {
                        throw new VMException(frame, String.format("Cannot find property %s::%s", ecls.getName(), propname));
                    }
                    return ((EObject)object).eGet(sf);
                }
                throw new VMException(frame, String.format("Cannot retrieve properties for regular objects: %s", object));
            }
        });
        this.createOperation(false, "refSetValue", Types.OCL_ANY_TYPE, Types.OCL_ANY_TYPE, new String[][][]{{{"propname"}, Types.STRING_TYPE}, {{"value"}, Types.OCL_ANY_TYPE}}, new NativeCodeBlock(){

            public Object execute(StackFrame frame) {
                Object object = frame.getLocal(0, 0);
                if (object instanceof EObject) {
                    String propname = (String)frame.getLocal(0, 1);
                    Object value = frame.getLocal(0, 2);
                    EObject eo = (EObject)object;
                    EClass ecls = eo.eClass();
                    EStructuralFeature sf = ecls.getEStructuralFeature(propname);
                    if (sf == null) {
                        throw new VMException(frame, String.format("Cannot find property %s::%s", ecls.getName(), propname));
                    }
                    ((EObject)object).eSet(sf, value);
                    return object;
                }
                throw new VMException(frame, String.format("Cannot set properties for regular objects: %s", object));
            }
        });
        this.createOperation(false, "refUnsetValue", Types.OCL_ANY_TYPE, Types.OCL_ANY_TYPE, new String[][][]{{{"propname"}, Types.STRING_TYPE}}, new NativeCodeBlock(){

            public Object execute(StackFrame frame) {
                Object object = frame.getLocal(0, 0);
                if (object instanceof EObject) {
                    String propname = (String)frame.getLocal(0, 1);
                    EObject eo = (EObject)object;
                    EClass ecls = eo.eClass();
                    EStructuralFeature sf = ecls.getEStructuralFeature(propname);
                    if (sf == null) {
                        throw new VMException(frame, String.format("Cannot find property %s::%s", ecls.getName(), propname));
                    }
                    ((EObject)object).eUnset(sf);
                    return object;
                }
                throw new VMException(frame, String.format("Cannot unset properties for regular objects: %s", object));
            }
        });
        this.createOperation(false, "refInvokeOperation", Types.OCL_ANY_TYPE, Types.OCL_ANY_TYPE, new String[][][]{{{"opname"}, Types.STRING_TYPE}, {{"arguments"}, Types.SEQUENCE_TYPE}}, new NativeCodeBlock(){

            public Object execute(StackFrame frame) {
                Object object = frame.getLocal(0, 0);
                String opname = (String)frame.getLocal(0, 1);
                List args = (List)frame.getLocal(0, 2);
                return EMFTVMUtil.invokeNative(frame, object, opname, args.toArray());
            }
        });
        this.createOperation(false, "resolve", Types.OCL_ANY_TYPE, Types.OCL_ANY_TYPE, new String[0][][], new NativeCodeBlock(){

            public Object execute(StackFrame frame) {
                Object object = frame.getLocal(0, 0);
                SourceElement se = frame.getEnv().getTraces().getDefaultSourceElement(object);
                if (se != null && !se.isMapsToSelf()) {
                    EList seMapsTo = se.getMapsTo();
                    if (!seMapsTo.isEmpty()) {
                        if (!$assertionsDisabled && ((TargetElement)seMapsTo.get(0)).getObject().eResource() == null) {
                            throw new AssertionError();
                        }
                        return ((TargetElement)seMapsTo.get(0)).getObject();
                    }
                    for (TargetElement te : se.getSourceOf().getTargetElements()) {
                        if (!te.getMapsTo().isEmpty()) continue;
                        if (!$assertionsDisabled && te.getObject().eResource() == null) {
                            throw new AssertionError();
                        }
                        return te.getObject();
                    }
                }
                return object;
            }
        });
        this.createOperation(false, "resolve", Types.OCL_ANY_TYPE, Types.OCL_ANY_TYPE, new String[][][]{{{"rule"}, Types.STRING_TYPE}}, new NativeCodeBlock(){

            public Object execute(StackFrame frame) {
                SourceElement se;
                Object object = frame.getLocal(0, 0);
                String rule = (String)frame.getLocal(0, 1);
                TracedRule tr = frame.getEnv().getTraces().getLinksByRule(rule, false);
                if (tr != null && (se = tr.getUniqueSourceElement(object)) != null && !se.isMapsToSelf()) {
                    EList seMapsTo = se.getMapsTo();
                    if (!seMapsTo.isEmpty()) {
                        if (!$assertionsDisabled && ((TargetElement)seMapsTo.get(0)).getObject().eResource() == null) {
                            throw new AssertionError();
                        }
                        return ((TargetElement)seMapsTo.get(0)).getObject();
                    }
                    for (TargetElement te : se.getSourceOf().getTargetElements()) {
                        if (!te.getMapsTo().isEmpty()) continue;
                        if (!$assertionsDisabled && te.getObject().eResource() == null) {
                            throw new AssertionError();
                        }
                        return te.getObject();
                    }
                }
                return object;
            }
        });
        this.createOperation(false, "remap", Types.OCL_ANY_TYPE, Types.OCL_ANY_TYPE, new String[][][]{{{"to"}, Types.OCL_ANY_TYPE}}, new NativeCodeBlock(){

            public Object execute(StackFrame frame) {
                Object source = frame.getLocal(0, 0);
                Object target = frame.getLocal(0, 1);
                if (source instanceof EObject && target instanceof EObject && source != target) {
                    frame.getEnv().queueForRemap((EObject)source, (EObject)target, frame);
                }
                return target;
            }
        });
        this.createOperation(false, "toString", Types.COLLECTION_TYPE, Types.STRING_TYPE, new String[0][][], new NativeCodeBlock(){

            public Object execute(StackFrame frame) {
                LazyCollection coll = (LazyCollection)frame.getLocal(0, 0);
                return coll.asString(frame.getEnv());
            }
        });
        this.createOperation(false, "-", Types.BAG_TYPE, Types.BAG_TYPE, new String[][][]{{{"coll"}, Types.COLLECTION_TYPE}}, new NativeCodeBlock(){

            public Object execute(StackFrame frame) {
                LazyBag self = (LazyBag)frame.getLocal(0, 0);
                LazyCollection coll = (LazyCollection)frame.getLocal(0, 1);
                return self.excludingAll((Collection)coll);
            }
        });
        this.createOperation(false, "-", Types.ORDERED_SET_TYPE, Types.ORDERED_SET_TYPE, new String[][][]{{{"coll"}, Types.COLLECTION_TYPE}}, new NativeCodeBlock(){

            public Object execute(StackFrame frame) {
                LazyOrderedSet self = (LazyOrderedSet)frame.getLocal(0, 0);
                LazyCollection coll = (LazyCollection)frame.getLocal(0, 1);
                return self.excludingAll((Collection)coll);
            }
        });
        this.createOperation(false, "-", Types.SEQUENCE_TYPE, Types.SEQUENCE_TYPE, new String[][][]{{{"coll"}, Types.COLLECTION_TYPE}}, new NativeCodeBlock(){

            public Object execute(StackFrame frame) {
                LazyList self = (LazyList)frame.getLocal(0, 0);
                LazyCollection coll = (LazyCollection)frame.getLocal(0, 1);
                return self.excludingAll((Collection)coll);
            }
        });
        this.createOperation(false, "-", Types.SET_TYPE, Types.SET_TYPE, new String[][][]{{{"coll"}, Types.COLLECTION_TYPE}}, new NativeCodeBlock(){

            public Object execute(StackFrame frame) {
                LazySet self = (LazySet)frame.getLocal(0, 0);
                LazyCollection coll = (LazyCollection)frame.getLocal(0, 1);
                return self.excludingAll((Collection)coll);
            }
        });
        this.createOperation(false, "resolve", Types.JAVA_COLLECTION_TYPE, Types.SEQUENCE_TYPE, new String[0][][], new NativeCodeBlock(){

            public Object execute(StackFrame frame) {
                Collection object = (Collection)frame.getLocal(0, 0);
                return new ResolveList(object, frame);
            }
        });
        this.createOperation(false, "resolve", Types.JAVA_COLLECTION_TYPE, Types.SEQUENCE_TYPE, new String[][][]{{{"rule"}, Types.STRING_TYPE}}, new NativeCodeBlock(){

            public Object execute(StackFrame frame) {
                Collection object = (Collection)frame.getLocal(0, 0);
                String rule = (String)frame.getLocal(0, 1);
                return new UniqueResolveList(object, frame, rule);
            }
        });
        this.createOperation(false, "=~", Types.JAVA_COLLECTION_TYPE, Types.BOOLEAN_TYPE, new String[][][]{{{"o"}, Types.OCL_ANY_TYPE}}, new NativeCodeBlock(){

            public Object execute(StackFrame frame) {
                Collection o = (Collection)frame.getLocal(0, 0);
                Object o2 = frame.getLocal(0, 1);
                if (o2 instanceof Collection) {
                    return o.containsAll((Collection)o2);
                }
                return o.contains(o2);
            }
        });
        this.createOperation(false, "=~|", Types.JAVA_COLLECTION_TYPE, Types.BOOLEAN_TYPE, new String[][][]{{{"o"}, Types.OCL_ANY_TYPE}}, new NativeCodeBlock(){

            public Object execute(StackFrame frame) {
                Collection o = (Collection)frame.getLocal(0, 0);
                Object o2 = frame.getLocal(0, 1);
                if (o2 instanceof Collection) {
                    return o.containsAll((Collection)o2);
                }
                return o.contains(o2);
            }
        });
        this.createOperation(false, "=~|", Types.JAVA_LIST_TYPE, Types.BOOLEAN_TYPE, new String[][][]{{{"o"}, Types.OCL_ANY_TYPE}}, new NativeCodeBlock(){

            public Object execute(StackFrame frame) {
                List o = (List)frame.getLocal(0, 0);
                Object o2 = frame.getLocal(0, 1);
                if (o2 instanceof Collection) {
                    Collection coll2 = (Collection)o2;
                    int sizediff = o.size() - coll2.size();
                    if (sizediff < 0) {
                        return false;
                    }
                    return o.subList(sizediff, o.size()).containsAll(coll2);
                }
                if (o.size() > 0) {
                    Object last = o.get(o.size() - 1);
                    return last == null ? o2 == null : last.equals(o2);
                }
                return false;
            }
        });
        this.createOperation(false, "including", Types.MAP_TYPE, Types.SET_TYPE, new String[][][]{{{"key"}, Types.OCL_ANY_TYPE}, {{"value"}, Types.OCL_ANY_TYPE}}, new NativeCodeBlock(){

            public Object execute(StackFrame frame) {
                HashMap<Object, Object> o = new HashMap<Object, Object>((Map)frame.getLocal(0, 0));
                Object key = frame.getLocal(0, 1);
                Object value = frame.getLocal(0, 2);
                o.put(key, value);
                return o;
            }
        });
        this.createOperation(false, "getKeys", Types.MAP_TYPE, Types.SET_TYPE, new String[0][][], new NativeCodeBlock(){

            public Object execute(StackFrame frame) {
                Map o = (Map)frame.getLocal(0, 0);
                return new LazySetOnSet(o.keySet());
            }
        });
        this.createOperation(false, "getValues", Types.MAP_TYPE, Types.SET_TYPE, new String[0][][], new NativeCodeBlock(){

            public Object execute(StackFrame frame) {
                Map o = (Map)frame.getLocal(0, 0);
                return new LazyBagOnCollection(o.values());
            }
        });
        this.createOperation(false, "union", Types.MAP_TYPE, Types.SET_TYPE, new String[][][]{{{"m"}, Types.MAP_TYPE}}, new NativeCodeBlock(){

            public Object execute(StackFrame frame) {
                HashMap o = new HashMap((Map)frame.getLocal(0, 0));
                Map m = (Map)frame.getLocal(0, 1);
                o.putAll(m);
                return o;
            }
        });
        this.createOperation(true, "resolveTemp", Types.EXEC_ENV_TYPE, Types.OCL_ANY_TYPE, new String[][][]{{{"var"}, Types.OCL_ANY_TYPE}, {{"target_pattern_name"}, Types.STRING_TYPE}}, new NativeCodeBlock(){

            public Object execute(StackFrame frame) {
                Object object = frame.getLocal(0, 0);
                String name = (String)frame.getLocal(0, 1);
                if (object instanceof List) {
                    SourceElementList sel = frame.getEnv().getTraces().getDefaultSourceElements((List)object);
                    if (sel != null) {
                        if (!$assertionsDisabled && sel.getSourceElements().isEmpty()) {
                            throw new AssertionError();
                        }
                        TargetElement te = ((SourceElement)sel.getSourceElements().get(0)).getSourceOf().getTargetElement(name);
                        if (te != null) {
                            return te.getObject();
                        }
                    }
                } else {
                    TargetElement te;
                    SourceElement se = frame.getEnv().getTraces().getDefaultSourceElement(object);
                    if (se != null && (te = se.getSourceOf().getTargetElement(name)) != null) {
                        return te.getObject();
                    }
                }
                throw new VMException(frame, String.format("Cannot resolve default trace target '%s' for %s", name, EMFTVMUtil.toPrettyString(object, frame.getEnv())));
            }
        });
        this.createOperation(true, "resolveTemp", Types.EXEC_ENV_TYPE, Types.OCL_ANY_TYPE, new String[][][]{{{"var"}, Types.OCL_ANY_TYPE}, {{"rule_name"}, Types.STRING_TYPE}, {{"target_pattern_name"}, Types.STRING_TYPE}}, new NativeCodeBlock(){

            public Object execute(StackFrame frame) {
                Object object = frame.getLocal(0, 0);
                String rule = (String)frame.getLocal(0, 1);
                String name = (String)frame.getLocal(0, 2);
                if (object instanceof List) {
                    SourceElementList sel;
                    TracedRule tr = frame.getEnv().getTraces().getLinksByRule(rule, false);
                    if (tr != null && (sel = tr.getUniqueSourceElements((List)object)) != null) {
                        if (!$assertionsDisabled && sel.getSourceElements().isEmpty()) {
                            throw new AssertionError();
                        }
                        TargetElement te = ((SourceElement)sel.getSourceElements().get(0)).getSourceOf().getTargetElement(name);
                        if (te != null) {
                            return te.getObject();
                        }
                    }
                } else {
                    TargetElement te;
                    SourceElement se;
                    TracedRule tr = frame.getEnv().getTraces().getLinksByRule(rule, false);
                    if (tr != null && (se = tr.getUniqueSourceElement(object)) != null && (te = se.getSourceOf().getTargetElement(name)) != null) {
                        return te.getObject();
                    }
                }
                throw new VMException(frame, String.format("Cannot resolve unique trace target '%s::%s' for %s", rule, name, EMFTVMUtil.toPrettyString(object, frame.getEnv())));
            }
        });
        this.createOperation(false, "allInstances", Types.CLASS_TYPE, Types.SEQUENCE_TYPE, new String[0][][], new NativeCodeBlock(){

            public Object execute(StackFrame frame) {
                EClass c = (EClass)frame.getLocal(0, 0);
                return EMFTVMUtil.findAllInstances(c, frame.getEnv());
            }
        });
        this.createOperation(false, "allInstancesFrom", Types.CLASS_TYPE, Types.SEQUENCE_TYPE, new String[][][]{{{"metamodel"}, Types.STRING_TYPE}}, new NativeCodeBlock(){

            public Object execute(StackFrame frame) {
                EClass c = (EClass)frame.getLocal(0, 0);
                String mm = (String)frame.getLocal(0, 1);
                return EMFTVMUtil.findAllInstIn(mm, c, frame.getEnv());
            }
        });
        this.createOperation(false, "conformsTo", Types.CLASS_TYPE, Types.BOOLEAN_TYPE, new String[][][]{{{"type"}, Types.CLASS_TYPE}}, new NativeCodeBlock(){

            public Object execute(StackFrame frame) {
                EClass c = (EClass)frame.getLocal(0, 0);
                EClass c2 = (EClass)frame.getLocal(0, 1);
                return c2.isSuperTypeOf(c);
            }
        });
        this.createOperation(false, "conformsTo", Types.CLASS_TYPE, Types.BOOLEAN_TYPE, new String[][][]{{{"type"}, Types.JAVA_CLASS_TYPE}}, new NativeCodeBlock(){

            public Object execute(StackFrame frame) {
                EClass c = (EClass)frame.getLocal(0, 0);
                Class c2 = (Class)frame.getLocal(0, 1);
                Class ic = c.getInstanceClass();
                if (ic != null) {
                    return c2.isAssignableFrom(ic);
                }
                if (c2 == Object.class) {
                    return true;
                }
                return false;
            }
        });
        this.createOperation(false, "newInstance", Types.CLASS_TYPE, Types.OCL_ANY_TYPE, new String[0][][], new NativeCodeBlock(){

            public Object execute(StackFrame frame) {
                EClass type = (EClass)frame.getLocal(0, 0);
                return type.getEPackage().getEFactoryInstance().create(type);
            }
        });
        this.createOperation(false, "newInstanceIn", Types.CLASS_TYPE, Types.OCL_ANY_TYPE, new String[][][]{{{"modelname"}, Types.STRING_TYPE}}, new NativeCodeBlock(){

            public Object execute(StackFrame frame) {
                EClass type = (EClass)frame.getLocal(0, 0);
                String modelname = (String)frame.getLocal(0, 1);
                ExecEnv env = frame.getEnv();
                Model model = env.getOutputModels().get(modelname);
                if (model == null) {
                    model = env.getInoutModels().get(modelname);
                }
                if (model == null) {
                    throw new IllegalArgumentException(String.format("Inout/output model %s not found", modelname));
                }
                return model.newElement(type);
            }
        });
        this.createOperation(false, "getInstanceById", Types.CLASS_TYPE, Types.OCL_ANY_TYPE, new String[][][]{{{"id"}, Types.STRING_TYPE}}, new NativeCodeBlock(){

            public Object execute(StackFrame frame) {
                EClass type = (EClass)frame.getLocal(0, 0);
                String id = (String)frame.getLocal(0, 1);
                ExecEnv env = frame.getEnv();
                LazyList<Model> models = new LazyListOnCollection<Model>(env.getInputModels().values()).union(new LazyListOnCollection<Model>(env.getInoutModels().values()));
                for (Model model : models) {
                    EObject instance = model.getResource().getEObject(id);
                    if (!type.isInstance((Object)instance)) continue;
                    return instance;
                }
                return null;
            }
        });
        this.createOperation(false, "getInstanceById", Types.CLASS_TYPE, Types.OCL_ANY_TYPE, new String[][][]{{{"modelname"}, Types.STRING_TYPE}, {{"id"}, Types.STRING_TYPE}}, new NativeCodeBlock(){

            public Object execute(StackFrame frame) {
                EClass type = (EClass)frame.getLocal(0, 0);
                String modelname = (String)frame.getLocal(0, 1);
                String id = (String)frame.getLocal(0, 2);
                ExecEnv env = frame.getEnv();
                Model model = env.getInputModels().get(modelname);
                if (model == null) {
                    model = env.getInoutModels().get(modelname);
                }
                if (model == null) {
                    throw new IllegalArgumentException(String.format("Input/inout model %s not found", modelname));
                }
                EObject instance = model.getResource().getEObject(id);
                if (type.isInstance((Object)instance)) {
                    return instance;
                }
                return null;
            }
        });
        this.createOperation(false, "conformsTo", Types.JAVA_CLASS_TYPE, Types.BOOLEAN_TYPE, new String[][][]{{{"type"}, Types.CLASS_TYPE}}, new NativeCodeBlock(){

            public Object execute(StackFrame frame) {
                Class c = (Class)frame.getLocal(0, 0);
                EClass c2 = (EClass)frame.getLocal(0, 1);
                Class ic2 = c2.getInstanceClass();
                if (ic2 != null) {
                    return ic2.isAssignableFrom(c);
                }
                return false;
            }
        });
        this.createOperation(false, "conformsTo", Types.JAVA_CLASS_TYPE, Types.BOOLEAN_TYPE, new String[][][]{{{"type"}, Types.JAVA_CLASS_TYPE}}, new NativeCodeBlock(){

            public Object execute(StackFrame frame) {
                Class c = (Class)frame.getLocal(0, 0);
                Class c2 = (Class)frame.getLocal(0, 1);
                return c2.isAssignableFrom(c);
            }
        });
        this.createOperation(false, "getName", Types.JAVA_CLASS_TYPE, Types.STRING_TYPE, new String[0][][], new NativeCodeBlock(){

            public Object execute(StackFrame frame) {
                Class c = (Class)frame.getLocal(0, 0);
                return NativeTypes.typeName(c);
            }
        });
        this.createOperation(false, "refInvokeStaticOperation", Types.JAVA_CLASS_TYPE, Types.OCL_ANY_TYPE, new String[][][]{{{"opname"}, Types.STRING_TYPE}, {{"arguments"}, Types.SEQUENCE_TYPE}}, new NativeCodeBlock(){

            public Object execute(StackFrame frame) {
                Class c = (Class)frame.getLocal(0, 0);
                String opname = (String)frame.getLocal(0, 1);
                List args = (List)frame.getLocal(0, 2);
                return EMFTVMUtil.invokeNativeStatic(frame, c, opname, args.toArray());
            }
        });
        this.createOperation(false, "refNewInstance", Types.JAVA_CLASS_TYPE, Types.OCL_ANY_TYPE, new String[][][]{{{"arguments"}, Types.SEQUENCE_TYPE}}, new NativeCodeBlock(){

            public Object execute(StackFrame frame) {
                Object[] args;
                Class c = (Class)frame.getLocal(0, 0);
                Constructor<?> constructor = EMFTVMUtil.findConstructor(c, EMFTVMUtil.getArgumentClasses(args = ((List)frame.getLocal(0, 1)).toArray()));
                if (constructor != null) {
                    try {
                        return EMFTVMUtil.emf2vm(frame.getEnv(), null, constructor.newInstance(args));
                    }
                    catch (InvocationTargetException e) {
                        Throwable target = e.getTargetException();
                        if (target instanceof VMException) {
                            throw (VMException)target;
                        }
                        throw new VMException(frame, target);
                    }
                    catch (VMException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throw new VMException(frame, (Throwable)e);
                    }
                }
                throw new UnsupportedOperationException(String.format("%s::<init>(%s)", EMFTVMUtil.getTypeName(frame.getEnv(), c), EMFTVMUtil.getTypeNames(frame.getEnv(), EMFTVMUtil.getArgumentTypes(args))));
            }
        });
        this.createOperation(false, "+", Types.REAL_TYPE, Types.REAL_TYPE, new String[][][]{{{"r"}, Types.REAL_TYPE}}, new NativeCodeBlock(){

            public Object execute(StackFrame frame) {
                return (Double)frame.getLocal(0, 0) + (Double)frame.getLocal(0, 1);
            }
        });
        this.createOperation(false, "+", Types.REAL_TYPE, Types.REAL_TYPE, new String[][][]{{{"i"}, Types.INTEGER_TYPE}}, new NativeCodeBlock(){

            public Object execute(StackFrame frame) {
                return (Double)frame.getLocal(0, 0) + (double)((Integer)frame.getLocal(0, 1)).intValue();
            }
        });
        this.createOperation(false, "-", Types.REAL_TYPE, Types.REAL_TYPE, new String[0][][], new NativeCodeBlock(){

            public Object execute(StackFrame frame) {
                return -((Double)frame.getLocal(0, 0)).doubleValue();
            }
        });
        this.createOperation(false, "-", Types.REAL_TYPE, Types.REAL_TYPE, new String[][][]{{{"r"}, Types.REAL_TYPE}}, new NativeCodeBlock(){

            public Object execute(StackFrame frame) {
                return (Double)frame.getLocal(0, 0) - (Double)frame.getLocal(0, 1);
            }
        });
        this.createOperation(false, "-", Types.REAL_TYPE, Types.REAL_TYPE, new String[][][]{{{"i"}, Types.INTEGER_TYPE}}, new NativeCodeBlock(){

            public Object execute(StackFrame frame) {
                return (Double)frame.getLocal(0, 0) - (double)((Integer)frame.getLocal(0, 1)).intValue();
            }
        });
        this.createOperation(false, "*", Types.REAL_TYPE, Types.REAL_TYPE, new String[][][]{{{"r"}, Types.REAL_TYPE}}, new NativeCodeBlock(){

            public Object execute(StackFrame frame) {
                return (Double)frame.getLocal(0, 0) * (Double)frame.getLocal(0, 1);
            }
        });
        this.createOperation(false, "*", Types.REAL_TYPE, Types.REAL_TYPE, new String[][][]{{{"i"}, Types.INTEGER_TYPE}}, new NativeCodeBlock(){

            public Object execute(StackFrame frame) {
                return (Double)frame.getLocal(0, 0) * (double)((Integer)frame.getLocal(0, 1)).intValue();
            }
        });
        this.createOperation(false, "neg", Types.REAL_TYPE, Types.REAL_TYPE, new String[0][][], new NativeCodeBlock(){

            public Object execute(StackFrame frame) {
                return -((Double)frame.getLocal(0, 0)).doubleValue();
            }
        });
        this.createOperation(false, "/", Types.REAL_TYPE, Types.REAL_TYPE, new String[][][]{{{"r"}, Types.REAL_TYPE}}, new NativeCodeBlock(){

            public Object execute(StackFrame frame) {
                return (Double)frame.getLocal(0, 0) / (Double)frame.getLocal(0, 1);
            }
        });
        this.createOperation(false, "/", Types.REAL_TYPE, Types.REAL_TYPE, new String[][][]{{{"i"}, Types.INTEGER_TYPE}}, new NativeCodeBlock(){

            public Object execute(StackFrame frame) {
                return (Double)frame.getLocal(0, 0) / (double)((Integer)frame.getLocal(0, 1)).intValue();
            }
        });
        this.createOperation(false, "abs", Types.REAL_TYPE, Types.REAL_TYPE, new String[0][][], new NativeCodeBlock(){

            public Object execute(StackFrame frame) {
                return Math.abs((Double)frame.getLocal(0, 0));
            }
        });
        this.createOperation(false, "floor", Types.REAL_TYPE, Types.INTEGER_TYPE, new String[0][][], new NativeCodeBlock(){

            public Object execute(StackFrame frame) {
                return Double.valueOf(Math.floor((Double)frame.getLocal(0, 0))).intValue();
            }
        });
        this.createOperation(false, "round", Types.REAL_TYPE, Types.INTEGER_TYPE, new String[0][][], new NativeCodeBlock(){

            public Object execute(StackFrame frame) {
                return Double.valueOf(Math.round((Double)frame.getLocal(0, 0))).intValue();
            }
        });
        this.createOperation(false, "max", Types.REAL_TYPE, Types.REAL_TYPE, new String[][][]{{{"r"}, Types.REAL_TYPE}}, new NativeCodeBlock(){

            public Object execute(StackFrame frame) {
                return Math.max((Double)frame.getLocal(0, 0), (Double)frame.getLocal(0, 1));
            }
        });
        this.createOperation(false, "max", Types.REAL_TYPE, Types.REAL_TYPE, new String[][][]{{{"i"}, Types.INTEGER_TYPE}}, new NativeCodeBlock(){

            public Object execute(StackFrame frame) {
                return Math.max((Double)frame.getLocal(0, 0), (double)((Integer)frame.getLocal(0, 1)).intValue());
            }
        });
        this.createOperation(false, "min", Types.REAL_TYPE, Types.REAL_TYPE, new String[][][]{{{"r"}, Types.REAL_TYPE}}, new NativeCodeBlock(){

            public Object execute(StackFrame frame) {
                return Math.min((Double)frame.getLocal(0, 0), (Double)frame.getLocal(0, 1));
            }
        });
        this.createOperation(false, "min", Types.REAL_TYPE, Types.REAL_TYPE, new String[][][]{{{"i"}, Types.INTEGER_TYPE}}, new NativeCodeBlock(){

            public Object execute(StackFrame frame) {
                return Math.min((Double)frame.getLocal(0, 0), (double)((Integer)frame.getLocal(0, 1)).intValue());
            }
        });
        this.createOperation(false, "<", Types.REAL_TYPE, Types.BOOLEAN_TYPE, new String[][][]{{{"r"}, Types.REAL_TYPE}}, new NativeCodeBlock(){

            public Object execute(StackFrame frame) {
                if ((Double)frame.getLocal(0, 0) < (Double)frame.getLocal(0, 1)) {
                    return true;
                }
                return false;
            }
        });
        this.createOperation(false, "<", Types.REAL_TYPE, Types.BOOLEAN_TYPE, new String[][][]{{{"i"}, Types.INTEGER_TYPE}}, new NativeCodeBlock(){

            public Object execute(StackFrame frame) {
                if ((Double)frame.getLocal(0, 0) < (double)((Integer)frame.getLocal(0, 1)).intValue()) {
                    return true;
                }
                return false;
            }
        });
        this.createOperation(false, ">", Types.REAL_TYPE, Types.BOOLEAN_TYPE, new String[][][]{{{"r"}, Types.REAL_TYPE}}, new NativeCodeBlock(){

            public Object execute(StackFrame frame) {
                if ((Double)frame.getLocal(0, 0) > (Double)frame.getLocal(0, 1)) {
                    return true;
                }
                return false;
            }
        });
        this.createOperation(false, ">", Types.REAL_TYPE, Types.BOOLEAN_TYPE, new String[][][]{{{"i"}, Types.INTEGER_TYPE}}, new NativeCodeBlock(){

            public Object execute(StackFrame frame) {
                if ((Double)frame.getLocal(0, 0) > (double)((Integer)frame.getLocal(0, 1)).intValue()) {
                    return true;
                }
                return false;
            }
        });
        this.createOperation(false, "<=", Types.REAL_TYPE, Types.BOOLEAN_TYPE, new String[][][]{{{"r"}, Types.REAL_TYPE}}, new NativeCodeBlock(){

            public Object execute(StackFrame frame) {
                if ((Double)frame.getLocal(0, 0) <= (Double)frame.getLocal(0, 1)) {
                    return true;
                }
                return false;
            }
        });
        this.createOperation(false, "<=", Types.REAL_TYPE, Types.BOOLEAN_TYPE, new String[][][]{{{"i"}, Types.INTEGER_TYPE}}, new NativeCodeBlock(){

            public Object execute(StackFrame frame) {
                if ((Double)frame.getLocal(0, 0) <= (double)((Integer)frame.getLocal(0, 1)).intValue()) {
                    return true;
                }
                return false;
            }
        });
        this.createOperation(false, ">=", Types.REAL_TYPE, Types.BOOLEAN_TYPE, new String[][][]{{{"r"}, Types.REAL_TYPE}}, new NativeCodeBlock(){

            public Object execute(StackFrame frame) {
                if ((Double)frame.getLocal(0, 0) >= (Double)frame.getLocal(0, 1)) {
                    return true;
                }
                return false;
            }
        });
        this.createOperation(false, ">=", Types.REAL_TYPE, Types.BOOLEAN_TYPE, new String[][][]{{{"i"}, Types.INTEGER_TYPE}}, new NativeCodeBlock(){

            public Object execute(StackFrame frame) {
                if ((Double)frame.getLocal(0, 0) >= (double)((Integer)frame.getLocal(0, 1)).intValue()) {
                    return true;
                }
                return false;
            }
        });
        this.createOperation(false, "neg", Types.INTEGER_TYPE, Types.INTEGER_TYPE, new String[0][][], new NativeCodeBlock(){

            public Object execute(StackFrame frame) {
                return -((Integer)frame.getLocal(0, 0)).intValue();
            }
        });
        this.createOperation(false, "+", Types.INTEGER_TYPE, Types.REAL_TYPE, new String[][][]{{{"r"}, Types.REAL_TYPE}}, new NativeCodeBlock(){

            public Object execute(StackFrame frame) {
                return (double)((Integer)frame.getLocal(0, 0)).intValue() + (Double)frame.getLocal(0, 1);
            }
        });
        this.createOperation(false, "+", Types.INTEGER_TYPE, Types.INTEGER_TYPE, new String[][][]{{{"i"}, Types.INTEGER_TYPE}}, new NativeCodeBlock(){

            public Object execute(StackFrame frame) {
                return (Integer)frame.getLocal(0, 0) + (Integer)frame.getLocal(0, 1);
            }
        });
        this.createOperation(false, "-", Types.INTEGER_TYPE, Types.INTEGER_TYPE, new String[0][][], new NativeCodeBlock(){

            public Object execute(StackFrame frame) {
                return -((Integer)frame.getLocal(0, 0)).intValue();
            }
        });
        this.createOperation(false, "-", Types.INTEGER_TYPE, Types.REAL_TYPE, new String[][][]{{{"r"}, Types.REAL_TYPE}}, new NativeCodeBlock(){

            public Object execute(StackFrame frame) {
                return (double)((Integer)frame.getLocal(0, 0)).intValue() - (Double)frame.getLocal(0, 1);
            }
        });
        this.createOperation(false, "-", Types.INTEGER_TYPE, Types.INTEGER_TYPE, new String[][][]{{{"i"}, Types.INTEGER_TYPE}}, new NativeCodeBlock(){

            public Object execute(StackFrame frame) {
                return (Integer)frame.getLocal(0, 0) - (Integer)frame.getLocal(0, 1);
            }
        });
        this.createOperation(false, "*", Types.INTEGER_TYPE, Types.REAL_TYPE, new String[][][]{{{"r"}, Types.REAL_TYPE}}, new NativeCodeBlock(){

            public Object execute(StackFrame frame) {
                return (double)((Integer)frame.getLocal(0, 0)).intValue() * (Double)frame.getLocal(0, 1);
            }
        });
        this.createOperation(false, "*", Types.INTEGER_TYPE, Types.INTEGER_TYPE, new String[][][]{{{"i"}, Types.INTEGER_TYPE}}, new NativeCodeBlock(){

            public Object execute(StackFrame frame) {
                return (Integer)frame.getLocal(0, 0) * (Integer)frame.getLocal(0, 1);
            }
        });
        this.createOperation(false, "/", Types.INTEGER_TYPE, Types.REAL_TYPE, new String[][][]{{{"r"}, Types.REAL_TYPE}}, new NativeCodeBlock(){

            public Object execute(StackFrame frame) {
                return (double)((Integer)frame.getLocal(0, 0)).intValue() / (Double)frame.getLocal(0, 1);
            }
        });
        this.createOperation(false, "/", Types.INTEGER_TYPE, Types.REAL_TYPE, new String[][][]{{{"i"}, Types.INTEGER_TYPE}}, new NativeCodeBlock(){

            public Object execute(StackFrame frame) {
                return ((Integer)frame.getLocal(0, 0)).doubleValue() / (double)((Integer)frame.getLocal(0, 1)).intValue();
            }
        });
        this.createOperation(false, "abs", Types.INTEGER_TYPE, Types.INTEGER_TYPE, new String[0][][], new NativeCodeBlock(){

            public Object execute(StackFrame frame) {
                return Math.abs((Integer)frame.getLocal(0, 0));
            }
        });
        this.createOperation(false, "div", Types.INTEGER_TYPE, Types.INTEGER_TYPE, new String[][][]{{{"i"}, Types.INTEGER_TYPE}}, new NativeCodeBlock(){

            public Object execute(StackFrame frame) {
                return (Integer)frame.getLocal(0, 0) / (Integer)frame.getLocal(0, 1);
            }
        });
        this.createOperation(false, "mod", Types.INTEGER_TYPE, Types.INTEGER_TYPE, new String[][][]{{{"i"}, Types.INTEGER_TYPE}}, new NativeCodeBlock(){

            public Object execute(StackFrame frame) {
                return (Integer)frame.getLocal(0, 0) % (Integer)frame.getLocal(0, 1);
            }
        });
        this.createOperation(false, "max", Types.INTEGER_TYPE, Types.REAL_TYPE, new String[][][]{{{"r"}, Types.REAL_TYPE}}, new NativeCodeBlock(){

            public Object execute(StackFrame frame) {
                return Math.max((double)((Integer)frame.getLocal(0, 0)).intValue(), (Double)frame.getLocal(0, 1));
            }
        });
        this.createOperation(false, "max", Types.INTEGER_TYPE, Types.INTEGER_TYPE, new String[][][]{{{"i"}, Types.INTEGER_TYPE}}, new NativeCodeBlock(){

            public Object execute(StackFrame frame) {
                return Math.max((Integer)frame.getLocal(0, 0), (Integer)frame.getLocal(0, 1));
            }
        });
        this.createOperation(false, "min", Types.INTEGER_TYPE, Types.REAL_TYPE, new String[][][]{{{"r"}, Types.REAL_TYPE}}, new NativeCodeBlock(){

            public Object execute(StackFrame frame) {
                return Math.min((double)((Integer)frame.getLocal(0, 0)).intValue(), (Double)frame.getLocal(0, 1));
            }
        });
        this.createOperation(false, "min", Types.INTEGER_TYPE, Types.INTEGER_TYPE, new String[][][]{{{"i"}, Types.INTEGER_TYPE}}, new NativeCodeBlock(){

            public Object execute(StackFrame frame) {
                return Math.min((Integer)frame.getLocal(0, 0), (Integer)frame.getLocal(0, 1));
            }
        });
        this.createOperation(false, "<", Types.INTEGER_TYPE, Types.BOOLEAN_TYPE, new String[][][]{{{"r"}, Types.REAL_TYPE}}, new NativeCodeBlock(){

            public Object execute(StackFrame frame) {
                if ((double)((Integer)frame.getLocal(0, 0)).intValue() < (Double)frame.getLocal(0, 1)) {
                    return true;
                }
                return false;
            }
        });
        this.createOperation(false, "<", Types.INTEGER_TYPE, Types.BOOLEAN_TYPE, new String[][][]{{{"i"}, Types.INTEGER_TYPE}}, new NativeCodeBlock(){

            public Object execute(StackFrame frame) {
                if ((Integer)frame.getLocal(0, 0) < (Integer)frame.getLocal(0, 1)) {
                    return true;
                }
                return false;
            }
        });
        this.createOperation(false, ">", Types.INTEGER_TYPE, Types.BOOLEAN_TYPE, new String[][][]{{{"r"}, Types.REAL_TYPE}}, new NativeCodeBlock(){

            public Object execute(StackFrame frame) {
                if ((double)((Integer)frame.getLocal(0, 0)).intValue() > (Double)frame.getLocal(0, 1)) {
                    return true;
                }
                return false;
            }
        });
        this.createOperation(false, ">", Types.INTEGER_TYPE, Types.BOOLEAN_TYPE, new String[][][]{{{"i"}, Types.INTEGER_TYPE}}, new NativeCodeBlock(){

            public Object execute(StackFrame frame) {
                if ((Integer)frame.getLocal(0, 0) > (Integer)frame.getLocal(0, 1)) {
                    return true;
                }
                return false;
            }
        });
        this.createOperation(false, "<=", Types.INTEGER_TYPE, Types.BOOLEAN_TYPE, new String[][][]{{{"r"}, Types.REAL_TYPE}}, new NativeCodeBlock(){

            public Object execute(StackFrame frame) {
                if ((double)((Integer)frame.getLocal(0, 0)).intValue() <= (Double)frame.getLocal(0, 1)) {
                    return true;
                }
                return false;
            }
        });
        this.createOperation(false, "<=", Types.INTEGER_TYPE, Types.BOOLEAN_TYPE, new String[][][]{{{"i"}, Types.INTEGER_TYPE}}, new NativeCodeBlock(){

            public Object execute(StackFrame frame) {
                if ((Integer)frame.getLocal(0, 0) <= (Integer)frame.getLocal(0, 1)) {
                    return true;
                }
                return false;
            }
        });
        this.createOperation(false, ">=", Types.INTEGER_TYPE, Types.BOOLEAN_TYPE, new String[][][]{{{"r"}, Types.REAL_TYPE}}, new NativeCodeBlock(){

            public Object execute(StackFrame frame) {
                if ((double)((Integer)frame.getLocal(0, 0)).intValue() >= (Double)frame.getLocal(0, 1)) {
                    return true;
                }
                return false;
            }
        });
        this.createOperation(false, ">=", Types.INTEGER_TYPE, Types.BOOLEAN_TYPE, new String[][][]{{{"i"}, Types.INTEGER_TYPE}}, new NativeCodeBlock(){

            public Object execute(StackFrame frame) {
                if ((Integer)frame.getLocal(0, 0) >= (Integer)frame.getLocal(0, 1)) {
                    return true;
                }
                return false;
            }
        });
        this.createOperation(false, "+", Types.STRING_TYPE, Types.STRING_TYPE, new String[][][]{{{"s"}, Types.STRING_TYPE}}, new NativeCodeBlock(){

            public Object execute(StackFrame frame) {
                return String.valueOf((String)frame.getLocal(0, 0)) + (String)frame.getLocal(0, 1);
            }
        });
        this.createOperation(false, "size", Types.STRING_TYPE, Types.INTEGER_TYPE, new String[0][][], new NativeCodeBlock(){

            public Object execute(StackFrame frame) {
                return ((String)frame.getLocal(0, 0)).length();
            }
        });
        this.createOperation(false, "substring", Types.STRING_TYPE, Types.STRING_TYPE, new String[][][]{{{"lower"}, Types.INTEGER_TYPE}}, new NativeCodeBlock(){

            public Object execute(StackFrame frame) {
                try {
                    return ((String)frame.getLocal(0, 0)).substring((Integer)frame.getLocal(0, 1) - 1);
                }
                catch (IndexOutOfBoundsException e) {
                    throw new VMException(frame, (Throwable)e);
                }
            }
        });
        this.createOperation(false, "substring", Types.STRING_TYPE, Types.STRING_TYPE, new String[][][]{{{"lower"}, Types.INTEGER_TYPE}, {{"upper"}, Types.INTEGER_TYPE}}, new NativeCodeBlock(){

            public Object execute(StackFrame frame) {
                try {
                    return ((String)frame.getLocal(0, 0)).substring((Integer)frame.getLocal(0, 1) - 1, (Integer)frame.getLocal(0, 2));
                }
                catch (IndexOutOfBoundsException e) {
                    throw new VMException(frame, (Throwable)e);
                }
            }
        });
        this.createOperation(false, "toInteger", Types.STRING_TYPE, Types.INTEGER_TYPE, new String[0][][], new NativeCodeBlock(){

            public Object execute(StackFrame frame) {
                try {
                    return Integer.parseInt((String)frame.getLocal(0, 0));
                }
                catch (NumberFormatException e) {
                    throw new VMException(frame, (Throwable)e);
                }
            }
        });
        this.createOperation(false, "toReal", Types.STRING_TYPE, Types.REAL_TYPE, new String[0][][], new NativeCodeBlock(){

            public Object execute(StackFrame frame) {
                try {
                    return Double.parseDouble((String)frame.getLocal(0, 0));
                }
                catch (NumberFormatException e) {
                    throw new VMException(frame, (Throwable)e);
                }
            }
        });
        this.createOperation(false, "indexOf", Types.STRING_TYPE, Types.INTEGER_TYPE, new String[][][]{{{"s"}, Types.STRING_TYPE}}, new NativeCodeBlock(){

            public Object execute(StackFrame frame) {
                return ((String)frame.getLocal(0, 0)).indexOf((String)frame.getLocal(0, 1)) + 1;
            }
        });
        this.createOperation(false, "lastIndexOf", Types.STRING_TYPE, Types.INTEGER_TYPE, new String[][][]{{{"s"}, Types.STRING_TYPE}}, new NativeCodeBlock(){

            public Object execute(StackFrame frame) {
                return ((String)frame.getLocal(0, 0)).lastIndexOf((String)frame.getLocal(0, 1)) + 1;
            }
        });
        this.createOperation(false, "at", Types.STRING_TYPE, Types.STRING_TYPE, new String[][][]{{{"i"}, Types.INTEGER_TYPE}}, new NativeCodeBlock(){

            public Object execute(StackFrame frame) {
                try {
                    return String.valueOf(((String)frame.getLocal(0, 0)).charAt((Integer)frame.getLocal(0, 1) - 1));
                }
                catch (IndexOutOfBoundsException e) {
                    throw new VMException(frame, (Throwable)e);
                }
            }
        });
        this.createOperation(false, "characters", Types.STRING_TYPE, Types.SEQUENCE_TYPE, new String[0][][], new NativeCodeBlock(){

            public Object execute(StackFrame frame) {
                LazyList<String> seq = new LazyList<String>();
                char[] cArray = ((String)frame.getLocal(0, 0)).toCharArray();
                int n = cArray.length;
                int n2 = 0;
                while (n2 < n) {
                    char c = cArray[n2];
                    seq = seq.append(String.valueOf(c));
                    ++n2;
                }
                return seq;
            }
        });
        this.createOperation(false, "toBoolean", Types.STRING_TYPE, Types.BOOLEAN_TYPE, new String[0][][], new NativeCodeBlock(){

            public Object execute(StackFrame frame) {
                return Boolean.parseBoolean((String)frame.getLocal(0, 0));
            }
        });
        this.createOperation(false, "toUpper", Types.STRING_TYPE, Types.STRING_TYPE, new String[0][][], new NativeCodeBlock(){

            public Object execute(StackFrame frame) {
                return ((String)frame.getLocal(0, 0)).toUpperCase();
            }
        });
        this.createOperation(false, "toLower", Types.STRING_TYPE, Types.STRING_TYPE, new String[0][][], new NativeCodeBlock(){

            public Object execute(StackFrame frame) {
                return ((String)frame.getLocal(0, 0)).toLowerCase();
            }
        });
        this.createOperation(false, "writeTo", Types.STRING_TYPE, Types.BOOLEAN_TYPE, new String[][][]{{{"path"}, Types.STRING_TYPE}}, new NativeCodeBlock(){

            public Object execute(StackFrame frame) {
                try {
                    return EMFTVMUtil.writeToWithCharset((String)frame.getLocal(0, 0), (String)frame.getLocal(0, 1), null);
                }
                catch (IOException e) {
                    throw new VMException(frame, (Throwable)e);
                }
            }
        });
        this.createOperation(false, "writeToWithCharset", Types.STRING_TYPE, Types.BOOLEAN_TYPE, new String[][][]{{{"path"}, Types.STRING_TYPE}, {{"charset"}, Types.STRING_TYPE}}, new NativeCodeBlock(){

            public Object execute(StackFrame frame) {
                try {
                    return EMFTVMUtil.writeToWithCharset((String)frame.getLocal(0, 0), (String)frame.getLocal(0, 1), (String)frame.getLocal(0, 2));
                }
                catch (IOException e) {
                    throw new VMException(frame, (Throwable)e);
                }
            }
        });
        this.createOperation(false, "toDate", Types.STRING_TYPE, Types.JAVA_DATE_TYPE, new String[][][]{{{"format"}, Types.STRING_TYPE}}, new NativeCodeBlock(){

            public Object execute(StackFrame frame) {
                try {
                    return new SimpleDateFormat((String)frame.getLocal(1)).parse((String)frame.getLocal(0));
                }
                catch (ParseException e) {
                    throw new VMException(frame, (Throwable)e);
                }
            }
        });
        this.createOperation(false, "toDate", Types.STRING_TYPE, Types.JAVA_DATE_TYPE, new String[][][]{{{"format"}, Types.STRING_TYPE}, {{"locale"}, Types.STRING_TYPE}}, new NativeCodeBlock(){

            public Object execute(StackFrame frame) {
                try {
                    return new SimpleDateFormat((String)frame.getLocal(1), EMFTVMUtil.getLocale((String)frame.getLocal(2))).parse((String)frame.getLocal(0));
                }
                catch (ParseException e) {
                    throw new VMException(frame, (Throwable)e);
                }
            }
        });
        this.createOperation(false, "toString", Types.JAVA_DATE_TYPE, Types.STRING_TYPE, new String[][][]{{{"format"}, Types.STRING_TYPE}}, new NativeCodeBlock(){

            public Object execute(StackFrame frame) {
                return new SimpleDateFormat((String)frame.getLocal(1)).format((Date)frame.getLocal(0));
            }
        });
        this.createOperation(false, "toString", Types.JAVA_DATE_TYPE, Types.STRING_TYPE, new String[][][]{{{"format"}, Types.STRING_TYPE}, {{"locale"}, Types.STRING_TYPE}}, new NativeCodeBlock(){

            public Object execute(StackFrame frame) {
                return new SimpleDateFormat((String)frame.getLocal(1), EMFTVMUtil.getLocale((String)frame.getLocal(2))).format((Date)frame.getLocal(0));
            }
        });
        this.createOperation(false, "toTuple", Types.JAVA_DATE_TYPE, Types.TUPLE_TYPE, new String[0][][], new NativeCodeBlock(){

            public Object execute(StackFrame frame) {
                Calendar cal = Calendar.getInstance();
                cal.setTime((Date)frame.getLocal(0));
                return Tuple.fromCalendar(cal);
            }
        });
        this.createOperation(false, "toTuple", Types.JAVA_DATE_TYPE, Types.TUPLE_TYPE, new String[][][]{{{"timezone"}, Types.STRING_TYPE}}, new NativeCodeBlock(){

            public Object execute(StackFrame frame) {
                Calendar cal = Calendar.getInstance(TimeZone.getTimeZone((String)frame.getLocal(1)));
                cal.setTime((Date)frame.getLocal(0));
                return Tuple.fromCalendar(cal);
            }
        });
    }

    private Operation createOperation(boolean isStatic, String name, String[] context, String[] returnType, String[][][] parameters, CodeBlock body) {
        Operation op = EMFTVMUtil.createOperation(isStatic, name, context, returnType, parameters, body);
        this.oclModule.getFeatures().add((Object)op);
        return op;
    }

    public Module getOclModule() {
        return this.oclModule;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ResolveList
    extends LazyList<Object> {
        protected final TraceLinkSet tls;

        public ResolveList(Collection<Object> dataSource, StackFrame frame) {
            super(dataSource);
            this.tls = frame.getEnv().getTraces();
        }

        @Override
        public Iterator<Object> iterator() {
            if (this.dataSource == null) {
                return Collections.unmodifiableCollection(this.cache).iterator();
            }
            return new ResolveIterator();
        }

        @Override
        public int size() {
            if (this.dataSource == null) {
                return this.cache.size();
            }
            return ((Collection)this.dataSource).size();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class ResolveIterator
        extends LazyCollection.CachingIterator {
            public ResolveIterator() {
                super(ResolveList.this, ResolveList.this.dataSource.iterator());
            }

            @Override
            public Object next() {
                Object next = this.inner.next();
                SourceElement se = ResolveList.this.tls.getDefaultSourceElement(next);
                if (se != null && !se.isMapsToSelf()) {
                    EList seMapsTo = se.getMapsTo();
                    if (!seMapsTo.isEmpty()) {
                        assert (((TargetElement)seMapsTo.get(0)).getObject().eResource() != null);
                        next = ((TargetElement)seMapsTo.get(0)).getObject();
                    } else {
                        for (TargetElement te : se.getSourceOf().getTargetElements()) {
                            if (!te.getMapsTo().isEmpty()) continue;
                            assert (te.getObject().eResource() != null);
                            next = te.getObject();
                            break;
                        }
                    }
                }
                this.updateCache(next);
                return next;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class UniqueResolveList
    extends ResolveList {
        protected final TracedRule tr;

        public UniqueResolveList(Collection<Object> dataSource, StackFrame frame, String rule) {
            super(dataSource, frame);
            this.tr = this.tls.getLinksByRule(rule, false);
        }

        @Override
        public Iterator<Object> iterator() {
            if (this.dataSource == null) {
                return Collections.unmodifiableCollection(this.cache).iterator();
            }
            if (this.tr == null) {
                return new LazyCollection.CachingIterator(this, this.dataSource.iterator());
            }
            return new UniqueResolveIterator();
        }

        public class UniqueResolveIterator
        extends ResolveList.ResolveIterator {
            public Object next() {
                Object next = this.inner.next();
                SourceElement se = UniqueResolveList.this.tr.getUniqueSourceElement(next);
                if (se != null && !se.isMapsToSelf()) {
                    EList seMapsTo = se.getMapsTo();
                    if (!seMapsTo.isEmpty()) {
                        assert (((TargetElement)seMapsTo.get(0)).getObject().eResource() != null);
                        next = ((TargetElement)seMapsTo.get(0)).getObject();
                    } else {
                        for (TargetElement te : se.getSourceOf().getTargetElements()) {
                            if (!te.getMapsTo().isEmpty()) continue;
                            assert (te.getObject().eResource() != null);
                            next = te.getObject();
                            break;
                        }
                    }
                }
                this.updateCache(next);
                return next;
            }
        }
    }
}

