/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.common.ui.launch;

import java.util.ArrayList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.m2m.internal.qvt.oml.common.ui.launch.Messages;
import org.eclipse.m2m.internal.qvt.oml.emf.util.ui.provider.EMFLabelProvider;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class ReferenceSelectionDialog
extends Dialog {
    private final Object myRoot;
    private final EClass myClass;
    private final EReference myInitialSelection;
    private final IRefFilter myRefFilter;
    private EReference myReference;
    private TreeViewer myViewer;
    private IContentProvider CONTENT_PROVIDER = new ITreeContentProvider(){

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof EClass) {
                EClass cls = (EClass)parentElement;
                ArrayList<EReference> validRefs = new ArrayList<EReference>();
                for (EReference ref : cls.getEAllContainments()) {
                    if (ReferenceSelectionDialog.this.myRefFilter != null && !ReferenceSelectionDialog.this.myRefFilter.accept(ref)) continue;
                    validRefs.add(ref);
                }
                return validRefs.toArray();
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            if (element instanceof EReference) {
                return ReferenceSelectionDialog.this.myClass;
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement == ReferenceSelectionDialog.this.myRoot) {
                return new Object[]{ReferenceSelectionDialog.this.myClass};
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    };
    private ISelectionChangedListener VIEWER_LISTENER = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            if (!(selection.getFirstElement() instanceof EReference)) {
                ReferenceSelectionDialog.this.myReference = null;
            } else {
                ReferenceSelectionDialog.this.myReference = (EReference)selection.getFirstElement();
            }
            Button button = ReferenceSelectionDialog.this.getButton(0);
            if (button != null && !button.isDisposed()) {
                button.setEnabled(ReferenceSelectionDialog.this.myReference != null);
            }
        }
    };

    public ReferenceSelectionDialog(EClass cls, EReference initialSelection, Shell shell) {
        this(cls, initialSelection, shell, IRefFilter.DEFAULT);
    }

    public ReferenceSelectionDialog(EClass cls, EReference initialSelection, Shell shell, IRefFilter refFilter) {
        super(shell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.myClass = cls;
        this.myInitialSelection = initialSelection;
        this.myRefFilter = refFilter;
        this.myRoot = new Object();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.ReferenceSelectionDialog_Title);
    }

    public EReference getReference() {
        return this.myReference;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.myViewer = new TreeViewer(composite, 2820);
        this.myViewer.setContentProvider(this.CONTENT_PROVIDER);
        this.myViewer.setLabelProvider((IBaseLabelProvider)new EMFLabelProvider());
        this.myViewer.addSelectionChangedListener(this.VIEWER_LISTENER);
        GridData data = new GridData(1808);
        data.heightHint = 250;
        data.widthHint = 350;
        this.myViewer.getControl().setLayoutData((Object)data);
        this.myViewer.setInput(this.myRoot);
        this.myViewer.expandAll();
        if (this.myInitialSelection != null) {
            this.myViewer.setSelection((ISelection)new StructuredSelection((Object)this.myInitialSelection), true);
        }
        return composite;
    }

    public EClass getEClass() {
        return this.myClass;
    }

    public static interface IRefFilter {
        public static final IRefFilter DEFAULT = new IRefFilter(){

            @Override
            public boolean accept(EReference ref) {
                return ref.isChangeable();
            }
        };

        public boolean accept(EReference var1);
    }
}

