/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.ocl.transformations;

import java.util.ArrayList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.m2m.internal.qvt.oml.ast.binding.ASTBindingHelper;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalEnv;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalEnvFactory;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalEvaluationEnv;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalModuleEnv;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalStdLibrary;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.QvtOperationalUtil;
import org.eclipse.m2m.internal.qvt.oml.cst.CSTFactory;
import org.eclipse.m2m.internal.qvt.oml.evaluator.ModuleInstance;
import org.eclipse.m2m.internal.qvt.oml.expressions.Module;
import org.eclipse.m2m.internal.qvt.oml.ocl.transformations.Library;
import org.eclipse.m2m.internal.qvt.oml.ocl.transformations.LibraryCreationException;
import org.eclipse.m2m.internal.qvt.oml.ocl.transformations.LibraryOperation;
import org.eclipse.m2m.internal.qvt.oml.ocl.transformations.QvtLibraryOperation;
import org.eclipse.m2m.internal.qvt.oml.stdlib.CallHandler;
import org.eclipse.m2m.internal.qvt.oml.stdlib.CallHandlerAdapter;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.cst.CSTNode;
import org.eclipse.ocl.expressions.ExpressionsFactory;
import org.eclipse.ocl.expressions.Variable;
import org.eclipse.ocl.util.TypeUtil;
import org.eclipse.ocl.utilities.ASTNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LegacyNativeLibSupport {
    public static final LegacyNativeLibSupport INSTANCE = LegacyNativeLibSupport.createInstance();

    private LegacyNativeLibSupport() {
    }

    public QvtOperationalModuleEnv defineLibrary(Library lib) throws LibraryCreationException {
        org.eclipse.m2m.internal.qvt.oml.expressions.Library libModule = QvtOperationalStdLibrary.createLibrary((String)lib.getId());
        QvtOperationalModuleEnv libEnv = LegacyNativeLibSupport.initLibEnvironment(lib, (Module)libModule);
        libModule.eResource().setURI(URI.createURI((String)("qvto:/blackboxlib/" + lib.getId())));
        for (LibraryOperation libOp : lib.getLibraryOperations()) {
            QvtLibraryOperation qvtLibOp = new QvtLibraryOperation((QvtOperationalEnv)libEnv, libOp);
            EClassifier ctxType = qvtLibOp.getContextType();
            if (ctxType == libEnv.getOCLStandardLibrary().getOclVoid()) {
                ctxType = libModule;
            }
            LegacyNativeLibSupport.defineOperation((QvtOperationalEnv)libEnv, libOp, ctxType, qvtLibOp.getReturnType(), qvtLibOp.getParamTypes());
        }
        ASTBindingHelper.createCST2ASTBinding((CSTNode)CSTFactory.eINSTANCE.createLibraryCS(), (ASTNode)libEnv.getModuleContextType(), (Environment)libEnv);
        return libEnv;
    }

    private static QvtOperationalModuleEnv initLibEnvironment(Library lib, Module libModule) {
        EPackage ePackage;
        String mm;
        int n;
        int n2;
        String[] stringArray;
        QvtOperationalModuleEnv libEnv = QvtOperationalEnvFactory.INSTANCE.createModuleEnvironment(libModule);
        EPackage.Registry libEnvRegistry = libEnv.getEPackageRegistry();
        EPackage oclStdlibPackage = ((EClassifier)libEnv.getOCLStandardLibrary().getOclAny()).getEPackage();
        libEnv.getEPackageRegistry().put((Object)oclStdlibPackage.getNsURI(), (Object)oclStdlibPackage);
        if (lib.getInMetamodels() != null) {
            stringArray = lib.getInMetamodels();
            n2 = stringArray.length;
            n = 0;
            while (n < n2) {
                mm = stringArray[n];
                ePackage = EPackage.Registry.INSTANCE.getEPackage(mm);
                if (ePackage != null) {
                    libEnvRegistry.put((Object)mm, (Object)ePackage);
                }
                ++n;
            }
        }
        if (lib.getOutMetamodels() != null) {
            stringArray = lib.getOutMetamodels();
            n2 = stringArray.length;
            n = 0;
            while (n < n2) {
                mm = stringArray[n];
                ePackage = EPackage.Registry.INSTANCE.getEPackage(mm);
                if (ePackage != null) {
                    libEnvRegistry.put((Object)mm, (Object)ePackage);
                }
                ++n;
            }
        }
        return libEnv;
    }

    private static Object callOperation(QvtOperationalEvaluationEnv evalEnv, LibraryOperation libOp, Object source, Object[] args, Class<?> returnClass) {
        Object result;
        if (source == null || source == CallHandlerAdapter.getInvalidResult((QvtOperationalEvaluationEnv)evalEnv)) {
            return CallHandlerAdapter.getInvalidResult((QvtOperationalEvaluationEnv)evalEnv);
        }
        Object[] callArgs = null;
        if (args != null) {
            int i = 0;
            while (i < args.length) {
                if (evalEnv.isOclInvalid(args[i])) {
                    if (callArgs == null) {
                        callArgs = new Object[args.length];
                        System.arraycopy(args, 0, callArgs, 0, args.length);
                    }
                    callArgs[i] = null;
                }
                ++i;
            }
            Object[] objectArray = callArgs = callArgs == null ? args : callArgs;
        }
        if ((result = libOp.run(source, callArgs, new Object[0], returnClass)) == null) {
            return QvtOperationalUtil.getOclInvalid();
        }
        return result;
    }

    private static EOperation defineOperation(QvtOperationalEnv env, LibraryOperation libOperation, EClassifier contextType, EClassifier returnType, EClassifier ... paramTypes) {
        ArrayList<Variable> stringArgList = new ArrayList<Variable>();
        EClassifier[] eClassifierArray = paramTypes;
        int n = paramTypes.length;
        int n2 = 0;
        while (n2 < n) {
            EClassifier cls = eClassifierArray[n2];
            Variable stringVariable = ExpressionsFactory.eINSTANCE.createVariable();
            stringVariable.setName(cls.getName());
            stringVariable.setType((Object)cls);
            stringArgList.add(stringVariable);
            ++n2;
        }
        String opName = libOperation.getName();
        EOperation operation = (EOperation)TypeUtil.findOperationMatching((Environment)env, (Object)contextType, (String)opName, stringArgList);
        if (operation != null) {
            for (EParameter eParameter : operation.getEParameters()) {
                eParameter.setName(eParameter.getEType().getName());
            }
            Class returnClass = returnType != null ? returnType.getInstanceClass() : null;
            CallHandlerAdapter.attach((EOperation)operation, (CallHandler)new Handler(libOperation, returnClass));
        }
        return operation;
    }

    private static LegacyNativeLibSupport createInstance() {
        LegacyNativeLibSupport lib = new LegacyNativeLibSupport();
        return lib;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Handler
    implements CallHandler {
        private LibraryOperation fOperation;
        private Class<?> fReturnClass;

        private Handler(LibraryOperation operation, Class<?> returnClass) {
            assert (operation != null);
            this.fOperation = operation;
            this.fReturnClass = returnClass;
        }

        public Object invoke(ModuleInstance module, Object source, Object[] args, QvtOperationalEvaluationEnv evalEnv) {
            return LegacyNativeLibSupport.callOperation(evalEnv, this.fOperation, source, args, this.fReturnClass);
        }
    }
}

