/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.rcp.ui.structuremergeviewer.groups;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.rcp.ui.structuremergeviewer.groups.DifferenceGroup;
import org.eclipse.emf.compare.scope.IComparisonScope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface IDifferenceGroupProvider {
    public Iterable<? extends DifferenceGroup> getGroups(Comparison var1);

    public String getLabel();

    public void setLabel(String var1);

    public boolean defaultSelected();

    public void setDefaultSelected(boolean var1);

    public boolean isEnabled(IComparisonScope var1, Comparison var2);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Registry {
        public Collection<IDifferenceGroupProvider> getGroupProviders(IComparisonScope var1, Comparison var2);

        public IDifferenceGroupProvider add(IDifferenceGroupProvider var1);

        public IDifferenceGroupProvider remove(String var1);

        public void clear();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RegistryImpl
    implements Registry {
        private final Map<String, IDifferenceGroupProvider> map = new ConcurrentHashMap<String, IDifferenceGroupProvider>();

        public List<IDifferenceGroupProvider> getGroupProviders(IComparisonScope scope, Comparison comparison) {
            Iterable providers = Iterables.filter(this.map.values(), RegistryImpl.isGroupProviderActivable(scope, comparison));
            ArrayList ret = Lists.newArrayList();
            for (IDifferenceGroupProvider provider : providers) {
                ret.add(provider);
            }
            return ret;
        }

        static final Predicate<IDifferenceGroupProvider> isGroupProviderActivable(final IComparisonScope scope, final Comparison comparison) {
            return new Predicate<IDifferenceGroupProvider>(){

                public boolean apply(IDifferenceGroupProvider d) {
                    return d.isEnabled(scope, comparison);
                }
            };
        }

        @Override
        public IDifferenceGroupProvider add(IDifferenceGroupProvider provider) {
            Preconditions.checkNotNull((Object)provider);
            return this.map.put(provider.getClass().getName(), provider);
        }

        @Override
        public IDifferenceGroupProvider remove(String className) {
            return this.map.remove(className);
        }

        @Override
        public void clear() {
            this.map.clear();
        }
    }
}

