/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.command.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.compare.command.ICompareCommandStack;
import org.eclipse.emf.compare.command.ICompareCopyCommand;

public class DualCompareCommandStack
implements ICompareCommandStack {
    private final BasicCommandStack leftCommandStack;
    private final BasicCommandStack rightCommandStack;
    private final List<BasicCommandStack> commandStackStack;
    private int top;
    private BasicCommandStack mostRecentCommandStack;
    private int saveIndex = -1;

    public DualCompareCommandStack(BasicCommandStack leftCommandStack, BasicCommandStack rightCommandStack) {
        this.leftCommandStack = (BasicCommandStack)Preconditions.checkNotNull((Object)leftCommandStack);
        this.rightCommandStack = (BasicCommandStack)Preconditions.checkNotNull((Object)rightCommandStack);
        this.commandStackStack = Lists.newArrayList();
        this.top = -1;
    }

    public void execute(Command command) {
        if (command instanceof ICompareCopyCommand) {
            ICompareCopyCommand compareCommand = (ICompareCopyCommand)command;
            BasicCommandStack commandStack = compareCommand.isLeftToRight() ? this.rightCommandStack : this.leftCommandStack;
            ListIterator<BasicCommandStack> commandStacks = this.commandStackStack.listIterator(this.top + 1);
            while (commandStacks.hasNext()) {
                commandStacks.next();
                commandStacks.remove();
            }
            this.mostRecentCommandStack = commandStack;
            this.commandStackStack.add(commandStack);
            ++this.top;
            if (this.saveIndex >= this.top) {
                this.saveIndex = -2;
            }
            commandStack.execute((Command)compareCommand);
        }
    }

    public boolean canUndo() {
        return this.top != -1 && this.commandStackStack.get(this.top).canUndo();
    }

    public void undo() {
        if (this.canUndo()) {
            BasicCommandStack commandStack = this.commandStackStack.get(this.top--);
            commandStack.undo();
            this.mostRecentCommandStack = commandStack;
        }
    }

    public boolean canRedo() {
        return this.top < this.commandStackStack.size() - 1;
    }

    public Command getUndoCommand() {
        return this.top == -1 || this.top == this.commandStackStack.size() ? null : this.commandStackStack.get(this.top).getUndoCommand();
    }

    public Command getRedoCommand() {
        return this.top + 1 >= this.commandStackStack.size() ? null : this.commandStackStack.get(this.top + 1).getRedoCommand();
    }

    public Command getMostRecentCommand() {
        if (this.mostRecentCommandStack != null) {
            return this.mostRecentCommandStack.getMostRecentCommand();
        }
        return null;
    }

    public void redo() {
        if (this.canRedo()) {
            BasicCommandStack commandStack = this.commandStackStack.get(++this.top);
            commandStack.redo();
            this.mostRecentCommandStack = commandStack;
        }
    }

    public void flush() {
        ListIterator<BasicCommandStack> commands = this.commandStackStack.listIterator();
        while (commands.hasNext()) {
            commands.next();
            commands.remove();
        }
        this.commandStackStack.clear();
        this.top = -1;
        this.saveIndex = -1;
        this.mostRecentCommandStack = null;
    }

    public void addCommandStackListener(CommandStackListener listener) {
        this.leftCommandStack.addCommandStackListener(listener);
        this.rightCommandStack.addCommandStackListener(listener);
    }

    public void removeCommandStackListener(CommandStackListener listener) {
        this.leftCommandStack.removeCommandStackListener(listener);
        this.rightCommandStack.removeCommandStackListener(listener);
    }

    public boolean isLeftSaveNeeded() {
        return this.leftCommandStack.isSaveNeeded();
    }

    public boolean isRightSaveNeeded() {
        return this.rightCommandStack.isSaveNeeded();
    }

    public void leftSaveIsDone() {
        this.leftCommandStack.saveIsDone();
    }

    public void rightSaveIsDone() {
        this.rightCommandStack.saveIsDone();
    }
}

