/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.provider.spec;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.AttributeChange;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.provider.AttributeChangeItemProvider;
import org.eclipse.emf.compare.provider.IItemDescriptionProvider;
import org.eclipse.emf.compare.provider.IItemStyledLabelProvider;
import org.eclipse.emf.compare.provider.spec.OverlayImageProvider;
import org.eclipse.emf.compare.provider.spec.ReferenceChangeItemProviderSpec;
import org.eclipse.emf.compare.provider.spec.Strings;
import org.eclipse.emf.compare.provider.utils.ComposedStyledString;
import org.eclipse.emf.compare.provider.utils.IStyledString;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.emf.edit.provider.AdapterFactoryItemDelegator;
import org.eclipse.emf.edit.provider.IItemFontProvider;

public class AttributeChangeItemProviderSpec
extends AttributeChangeItemProvider
implements IItemStyledLabelProvider,
IItemDescriptionProvider {
    private static final int ELIDE_LENGTH = 50;
    private final OverlayImageProvider overlayProvider;
    private final AdapterFactoryItemDelegator itemDelegator = new AdapterFactoryItemDelegator(this.getRootAdapterFactory());

    public AttributeChangeItemProviderSpec(AdapterFactory adapterFactory) {
        super(adapterFactory);
        this.overlayProvider = new OverlayImageProvider(this.getResourceLocator());
    }

    public Object getImage(Object object) {
        AttributeChange attributeChange = (AttributeChange)object;
        Object attributeChangeValueImage = this.itemDelegator.getImage(attributeChange.getValue());
        if (attributeChangeValueImage == null) {
            attributeChangeValueImage = super.getImage(object);
        }
        Object diffImage = this.overlayProvider.getComposedImage((Diff)attributeChange, attributeChangeValueImage);
        Object ret = this.overlayImage(object, diffImage);
        return ret;
    }

    public String getText(Object object) {
        return this.getStyledText(object).getString();
    }

    protected String getAttributeText(AttributeChange attChange) {
        return attChange.getAttribute().getName();
    }

    protected String getValueText(AttributeChange attChange) {
        FeatureMap.Entry entry;
        EStructuralFeature entryFeature;
        Object attValue = attChange.getValue();
        String value = FeatureMapUtil.isFeatureMap((EStructuralFeature)attChange.getAttribute()) ? ((entryFeature = (entry = (FeatureMap.Entry)attValue).getEStructuralFeature()) instanceof EAttribute ? EcoreUtil.convertToString((EDataType)((EAttribute)entryFeature).getEAttributeType(), (Object)attValue) : this.itemDelegator.getText(entry.getValue())) : EcoreUtil.convertToString((EDataType)attChange.getAttribute().getEAttributeType(), (Object)attValue);
        value = com.google.common.base.Strings.isNullOrEmpty((String)value) ? (attValue instanceof EObject && ((EObject)attValue).eIsProxy() ? "proxy : " + ((InternalEObject)attValue).eProxyURI().toString() : "<null>") : Strings.elide(value, 50, "...");
        return value;
    }

    public Object getForeground(Object object) {
        AttributeChange attributeChange = (AttributeChange)object;
        switch (attributeChange.getState()) {
            case MERGED: 
            case DISCARDED: {
                return URI.createURI((String)"color://rgb/156/156/156");
            }
        }
        return super.getForeground(object);
    }

    public IStyledString.IComposedStyledString getStyledText(Object object) {
        AttributeChange attChange = (AttributeChange)object;
        String valueText = this.getValueText(attChange);
        String attributeText = this.getAttributeText(attChange);
        ComposedStyledString ret = new ComposedStyledString();
        Object attChangeValue = attChange.getValue();
        if (attChangeValue instanceof EObject && ((EObject)attChangeValue).eIsProxy()) {
            IStyledString.Style italic = IStyledString.Style.builder().setFont(IItemFontProvider.ITALIC_FONT).build();
            ret.append(valueText, italic);
        } else {
            ret.append(valueText);
        }
        ret.append(" [" + attributeText, IStyledString.Style.DECORATIONS_STYLER);
        switch (attChange.getKind()) {
            case ADD: {
                ret.append(" add", IStyledString.Style.DECORATIONS_STYLER);
                break;
            }
            case DELETE: {
                ret.append(" delete", IStyledString.Style.DECORATIONS_STYLER);
                break;
            }
            case CHANGE: {
                ret.append(" " + ReferenceChangeItemProviderSpec.changeText((Diff)attChange, (EStructuralFeature)attChange.getAttribute()), IStyledString.Style.DECORATIONS_STYLER);
                break;
            }
            case MOVE: {
                ret.append(" move", IStyledString.Style.DECORATIONS_STYLER);
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported " + DifferenceKind.class.getSimpleName() + " value: " + attChange.getKind());
            }
        }
        ret.append("]", IStyledString.Style.DECORATIONS_STYLER);
        return ret;
    }

    public String getDescription(Object object) {
        AttributeChange attChange = (AttributeChange)object;
        String valueText = this.getValueText(attChange);
        String attributeText = this.getAttributeText(attChange);
        String remotely = "";
        if (attChange.getSource() == DifferenceSource.RIGHT) {
            remotely = "remotely ";
        }
        String ret = "";
        switch (attChange.getKind()) {
            case ADD: {
                ret = String.valueOf(valueText) + " has been " + remotely + "added to " + attributeText;
                break;
            }
            case DELETE: {
                ret = String.valueOf(valueText) + " has been " + remotely + "deleted from " + attributeText;
                break;
            }
            case CHANGE: {
                String changeText = ReferenceChangeItemProviderSpec.changeText((Diff)attChange, (EStructuralFeature)attChange.getAttribute());
                ret = String.valueOf(attributeText) + " " + valueText + " has been " + remotely + changeText;
                break;
            }
            case MOVE: {
                ret = String.valueOf(valueText) + " has been " + remotely + "moved in '" + attributeText;
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported " + DifferenceKind.class.getSimpleName() + " value: " + attChange.getKind());
            }
        }
        return ret;
    }
}

