/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.domain.impl;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.command.ICompareCommandStack;
import org.eclipse.emf.compare.command.ICompareCopyCommand;
import org.eclipse.emf.compare.command.impl.CompareCommandStack;
import org.eclipse.emf.compare.command.impl.DualCompareCommandStack;
import org.eclipse.emf.compare.command.impl.MergeAllNonConflictingCommand;
import org.eclipse.emf.compare.command.impl.MergeCommand;
import org.eclipse.emf.compare.command.impl.TransactionalDualCompareCommandStack;
import org.eclipse.emf.compare.domain.ICompareEditingDomain;
import org.eclipse.emf.compare.domain.IMergeRunnable;
import org.eclipse.emf.compare.internal.domain.IMergeAllNonConflictingRunnable;
import org.eclipse.emf.compare.merge.BatchMerger;
import org.eclipse.emf.compare.merge.IMerger;
import org.eclipse.emf.compare.provider.EMFCompareEditPlugin;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.change.util.ChangeRecorder;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.impl.AbstractTransactionalCommandStack;
import org.eclipse.emf.transaction.util.TransactionUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EMFCompareEditingDomain
implements ICompareEditingDomain,
IDisposable {
    private final ChangeRecorder fChangeRecorder;
    private final ImmutableCollection<Notifier> fNotifiers;
    private final ICompareCommandStack fCommandStack;

    public EMFCompareEditingDomain(Notifier left, Notifier right, Notifier ancestor, ICompareCommandStack commandStack) {
        this.fNotifiers = ancestor == null ? ImmutableList.of((Object)left, (Object)right) : ImmutableList.of((Object)left, (Object)right, (Object)ancestor);
        this.fCommandStack = commandStack;
        this.fChangeRecorder = new ChangeRecorder();
        this.fChangeRecorder.setResolveProxies(false);
    }

    private static ResourceSet getResourceSet(Notifier notifier) {
        Resource eResource;
        ResourceSet resourceSet = null;
        if (notifier instanceof ResourceSet) {
            resourceSet = (ResourceSet)notifier;
        } else if (notifier instanceof Resource) {
            resourceSet = ((Resource)notifier).getResourceSet();
        } else if (notifier instanceof EObject && (eResource = ((EObject)notifier).eResource()) != null) {
            resourceSet = eResource.getResourceSet();
        }
        return resourceSet;
    }

    public static ICompareEditingDomain create(Notifier left, Notifier right, Notifier ancestor) {
        EditingDomain leftED = EMFCompareEditingDomain.getEditingDomain(left);
        EditingDomain rightED = EMFCompareEditingDomain.getEditingDomain(right);
        if (leftED != null && rightED != null) {
            ICompareCommandStack commandStack;
            CommandStack leftCommandStack = leftED.getCommandStack();
            CommandStack rightCommandStack = rightED.getCommandStack();
            if (leftCommandStack instanceof AbstractTransactionalCommandStack && rightCommandStack instanceof AbstractTransactionalCommandStack) {
                commandStack = new TransactionalDualCompareCommandStack((AbstractTransactionalCommandStack)leftCommandStack, (AbstractTransactionalCommandStack)rightCommandStack);
            } else if (leftCommandStack instanceof BasicCommandStack && rightCommandStack instanceof BasicCommandStack) {
                commandStack = new DualCompareCommandStack((BasicCommandStack)leftCommandStack, (BasicCommandStack)rightCommandStack);
            } else {
                EMFCompareEditPlugin.getPlugin().getLog().log((IStatus)new Status(2, "org.eclipse.emf.compare.edit", "Command stacks of the editing domain of " + left + " and " + right + " are not instances of BasicCommandStack, nor AbstractTransactionalCommandStack, therefore, they will not be used as backing command stacks for the current merge session."));
                commandStack = new CompareCommandStack((CommandStack)new BasicCommandStack());
            }
            return new EMFCompareEditingDomain(left, right, ancestor, commandStack);
        }
        return EMFCompareEditingDomain.create(left, right, ancestor, (CommandStack)new BasicCommandStack());
    }

    private static EditingDomain getEditingDomain(Notifier notifier) {
        ResourceSet resourceSet;
        TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((Object)notifier);
        if (editingDomain == null && (editingDomain = AdapterFactoryEditingDomain.getEditingDomainFor((Object)notifier)) == null && (resourceSet = EMFCompareEditingDomain.getResourceSet(notifier)) != null) {
            editingDomain = TransactionalEditingDomain.Factory.INSTANCE.createEditingDomain(resourceSet);
        }
        return editingDomain;
    }

    public static ICompareEditingDomain create(Notifier left, Notifier right, Notifier ancestor, CommandStack commandStack) {
        return EMFCompareEditingDomain.create(left, right, ancestor, commandStack, null);
    }

    public static ICompareEditingDomain create(Notifier left, Notifier right, Notifier ancestor, CommandStack leftCommandStack, CommandStack rightCommandStack) {
        ICompareCommandStack commandStack = leftCommandStack == null && rightCommandStack != null ? (rightCommandStack instanceof ICompareCommandStack ? (ICompareCommandStack)rightCommandStack : new CompareCommandStack(rightCommandStack)) : (leftCommandStack != null && rightCommandStack == null ? (leftCommandStack instanceof ICompareCommandStack ? (ICompareCommandStack)leftCommandStack : new CompareCommandStack(leftCommandStack)) : (leftCommandStack instanceof BasicCommandStack && rightCommandStack instanceof BasicCommandStack ? new DualCompareCommandStack((BasicCommandStack)leftCommandStack, (BasicCommandStack)rightCommandStack) : new CompareCommandStack((CommandStack)new BasicCommandStack())));
        return new EMFCompareEditingDomain(left, right, ancestor, commandStack);
    }

    public void dispose() {
        this.fChangeRecorder.dispose();
        if (this.fCommandStack instanceof IDisposable) {
            ((IDisposable)this.fCommandStack).dispose();
        }
    }

    @Override
    public ICompareCommandStack getCommandStack() {
        return this.fCommandStack;
    }

    @Override
    public Command createCopyCommand(List<? extends Diff> differences, boolean leftToRight, IMerger.Registry mergerRegistry) {
        ImmutableSet.Builder notifiersBuilder = ImmutableSet.builder();
        for (Diff diff : differences) {
            notifiersBuilder.add((Object)diff.getMatch().getComparison());
        }
        ImmutableSet immutableSet = notifiersBuilder.addAll(this.fNotifiers).build();
        IMergeRunnable runnable = new IMergeRunnable(){

            @Override
            public void merge(List<? extends Diff> diffs, boolean lTR, IMerger.Registry registry) {
                BatchMerger merger = new BatchMerger(registry);
                if (lTR) {
                    merger.copyAllLeftToRight(diffs, (Monitor)new BasicMonitor());
                } else {
                    merger.copyAllRightToLeft(diffs, (Monitor)new BasicMonitor());
                }
            }
        };
        return new MergeCommand(this.fChangeRecorder, (Collection<Notifier>)immutableSet, differences, leftToRight, mergerRegistry, runnable);
    }

    @Override
    public ICompareCopyCommand createCopyCommand(List<? extends Diff> differences, boolean leftToRight, IMerger.Registry mergerRegistry, IMergeRunnable runnable) {
        ImmutableSet.Builder notifiersBuilder = ImmutableSet.builder();
        for (Diff diff : differences) {
            notifiersBuilder.add((Object)diff.getMatch().getComparison());
        }
        ImmutableSet immutableSet = notifiersBuilder.addAll(this.fNotifiers).build();
        return new MergeCommand(this.fChangeRecorder, (Collection<Notifier>)immutableSet, differences, leftToRight, mergerRegistry, runnable);
    }

    public ICompareCopyCommand createCopyAllNonConflictingCommand(Comparison comparison, boolean leftToRight, IMerger.Registry mergerRegistry, IMergeAllNonConflictingRunnable runnable) {
        ImmutableSet notifiers = ImmutableSet.of((Object)comparison);
        return new MergeAllNonConflictingCommand(this.fChangeRecorder, (Collection<Notifier>)notifiers, comparison, leftToRight, mergerRegistry, runnable);
    }

    @Override
    public ChangeRecorder getChangeRecorder() {
        return this.fChangeRecorder;
    }
}

