/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.internal.utils;

import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.compare.ide.EMFCompareIDEPlugin;
import org.eclipse.emf.compare.ide.hook.IResourceSetHook;
import org.eclipse.emf.compare.ide.internal.EMFCompareIDEMessages;
import org.eclipse.emf.compare.ide.internal.hook.ResourceSetHookRegistry;
import org.eclipse.emf.compare.ide.internal.utils.DisposableResourceSet;
import org.eclipse.emf.compare.ide.utils.ResourceUtil;
import org.eclipse.emf.compare.ide.utils.StorageTraversal;
import org.eclipse.emf.compare.rcp.EMFCompareRCPPlugin;
import org.eclipse.emf.compare.rcp.policy.ILoadOnDemandPolicy;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.InternalEList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Beta
public final class NotLoadingResourceSet
extends ResourceSetImpl
implements DisposableResourceSet {
    private static final Function<IStorage, URI> TO_URI = new Function<IStorage, URI>(){

        public URI apply(IStorage input) {
            return ResourceUtil.createURIFor(input);
        }
    };
    private final StorageTraversal storageTranversal;
    private final ResourceSetHookRegistry hookRegistry;
    private boolean isDisposed;

    private NotLoadingResourceSet(StorageTraversal storageTranversal, ResourceSetHookRegistry hookRegistry) {
        this.storageTranversal = storageTranversal;
        this.hookRegistry = hookRegistry;
    }

    public static NotLoadingResourceSet create(StorageTraversal traversals, IProgressMonitor monitor, ResourceSetHookRegistry resourceSetHookRegistry) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        progress.subTask(EMFCompareIDEMessages.getString("NotLoadingResourceSet.monitor.resolve"));
        NotLoadingResourceSet resourceSet = new NotLoadingResourceSet(traversals, resourceSetHookRegistry);
        Set<? extends IStorage> storages = traversals.getStorages();
        resourceSet.setURIResourceMap(new HashMap(storages.size() << 1));
        SubMonitor subMonitor = progress.newChild(60).setWorkRemaining(traversals.getStorages().size());
        resourceSet.load((IProgressMonitor)subMonitor);
        subMonitor = progress.newChild(40).setWorkRemaining(resourceSet.getResources().size());
        ArrayList resourcesCopy = Lists.newArrayList(resourceSet.getResources());
        for (Resource res : resourcesCopy) {
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            resourceSet.resolve(res);
            subMonitor.worked(1);
        }
        return resourceSet;
    }

    private Collection<IResourceSetHook> getMatchingHooks(final Collection<URI> urisToLoad) {
        Collection<IResourceSetHook> hooks = this.hookRegistry == null ? Collections.emptyList() : Collections2.filter(this.hookRegistry.getResourceSetHooks(), (Predicate)new Predicate<IResourceSetHook>(){

            public boolean apply(IResourceSetHook input) {
                return input.isHookFor(urisToLoad);
            }
        });
        return hooks;
    }

    protected void demandLoadHelper(Resource resource) {
        if (this.storageTranversal != null) {
            IStorage storage = this.getMatchingStorage(resource);
            if (storage != null) {
                try {
                    this.loadFromStorage(resource, storage);
                }
                catch (IOException e) {
                    this.logLoadingFromStorageFailed(resource, storage, e);
                }
            } else {
                super.demandLoadHelper(resource);
            }
        } else {
            super.demandLoadHelper(resource);
        }
    }

    private void logLoadingFromStorageFailed(Resource resource, IStorage storage, Exception e) {
        Status errorStatus = new Status(4, "org.eclipse.emf.compare.ide", EMFCompareIDEMessages.getString("StorageResourceWrapper.failToLoad", resource.getURI().toString(), storage.getName()), (Throwable)e);
        EMFCompareIDEPlugin.getDefault().getLog().log((IStatus)errorStatus);
    }

    private IStorage getMatchingStorage(Resource resource) {
        URIConverter theURIConverter = this.getURIConverter();
        URI resourceNormalizedUri = theURIConverter.normalize(resource.getURI());
        for (IStorage iStorage : this.storageTranversal.getStorages()) {
            URI storageNormalizedURI = this.getURIConverter().normalize(ResourceUtil.createURIFor(iStorage));
            if (!storageNormalizedURI.equals(resourceNormalizedUri)) continue;
            return iStorage;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void loadFromStorage(Resource resource, IStorage storage) throws IOException {
        InputStream stream = null;
        try {
            try {
                stream = storage.getContents();
                resource.load(stream, this.getLoadOptions());
                return;
            }
            catch (CoreException e) {
                this.logLoadingFromStorageFailed(resource, storage, (Exception)((Object)e));
                if (stream == null) return;
                stream.close();
                return;
            }
            catch (WrappedException e) {
                this.logLoadingFromStorageFailed(resource, storage, (Exception)((Object)e));
                if (stream == null) return;
                stream.close();
                return;
            }
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
    }

    private Resource loadResource(URI uri) {
        return super.getResource(uri, true);
    }

    protected void handleDemandLoadException(Resource resource, IOException exception) {
        try {
            super.handleDemandLoadException(resource, exception);
        }
        catch (RuntimeException runtimeException) {}
    }

    public Resource getResource(URI uri, boolean loadOnDemand) {
        this.checkNotDisposed();
        ILoadOnDemandPolicy.Registry registry = EMFCompareRCPPlugin.getDefault().getLoadOnDemandPolicyRegistry();
        if (registry.hasAnyAuthorizingPolicy(uri)) {
            return super.getResource(uri, true);
        }
        return super.getResource(uri, false);
    }

    private void resolve(Resource resource) {
        List roots = ((InternalEList)resource.getContents()).basicList();
        for (EObject eObject : roots) {
            this.resolveCrossReferences(eObject);
            this.resolveChildren(eObject);
        }
        resource.getContents().addAll((Collection)roots);
    }

    private void resolveChildren(EObject eObject) {
        EList list = eObject.eContents();
        ListIterator childContent = ((InternalEList)list).basicListIterator();
        while (childContent.hasNext()) {
            EObject child = (EObject)childContent.next();
            if (child.eIsProxy()) {
                URI proxyURI = ((InternalEObject)child).eProxyURI();
                Resource targetRes = this.getResource(proxyURI.trimFragment(), false);
                if (targetRes != null) {
                    list.get(childContent.previousIndex());
                }
                this.resolveCrossReferences(child);
                continue;
            }
            this.resolveCrossReferences(child);
            this.resolveChildren(child);
        }
    }

    private void resolveCrossReferences(EObject eObject) {
        EList list = eObject.eCrossReferences();
        ListIterator objectChildren = ((InternalEList)list).basicListIterator();
        while (objectChildren.hasNext()) {
            URI proxyURI;
            Resource targetRes;
            EObject eObj = (EObject)objectChildren.next();
            if (!eObj.eIsProxy() || (targetRes = this.getResource((proxyURI = ((InternalEObject)eObj).eProxyURI()).trimFragment(), false)) == null) continue;
            list.get(objectChildren.previousIndex());
        }
    }

    private void load(IProgressMonitor monitor) {
        this.checkNotDisposed();
        ImmutableList urisToLoad = ImmutableList.copyOf((Iterable)Iterables.transform(this.storageTranversal.getStorages(), TO_URI));
        Collection<IResourceSetHook> hooks = this.getMatchingHooks((Collection<URI>)urisToLoad);
        for (IResourceSetHook hook : hooks) {
            hook.preLoadingHook(this, (Collection<? extends URI>)urisToLoad);
        }
        for (URI uri : urisToLoad) {
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            this.loadResource(uri);
            monitor.worked(1);
        }
        for (IResourceSetHook hook : hooks) {
            hook.postLoadingHook(this, (Collection<? extends URI>)urisToLoad);
        }
    }

    @Override
    public void dispose() {
        ImmutableList currentResources = ImmutableList.copyOf(this.getResources());
        ArrayList resourceSetUris = Lists.newArrayList((Iterable)Iterables.transform((Iterable)currentResources, (Function)new Function<Resource, URI>(){

            public URI apply(Resource input) {
                return input.getURI();
            }
        }));
        for (IResourceSetHook hook : this.getMatchingHooks(resourceSetUris)) {
            hook.onDispose((Iterable<Resource>)currentResources);
        }
        this.getResources().clear();
        this.isDisposed = true;
    }

    public Resource createResource(URI uri, String contentType) {
        this.checkNotDisposed();
        return super.createResource(uri, contentType);
    }

    public EObject getEObject(URI uri, boolean loadOnDemand) {
        this.checkNotDisposed();
        return super.getEObject(uri, loadOnDemand);
    }

    public TreeIterator<Notifier> getAllContents() {
        this.checkNotDisposed();
        return super.getAllContents();
    }

    public EList<Resource> getResources() {
        this.checkNotDisposed();
        return super.getResources();
    }

    private void checkNotDisposed() {
        if (this.isDisposed) {
            throw new IllegalStateException("The resource set is disposed");
        }
    }
}

