/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.uml2.internal.merge;

import com.google.common.base.Optional;
import java.util.List;
import org.eclipse.emf.compare.AttributeChange;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.DifferenceState;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.internal.utils.DiffUtil;
import org.eclipse.emf.compare.merge.AttributeChangeMerger;
import org.eclipse.emf.compare.uml2.internal.OpaqueElementBodyChange;
import org.eclipse.emf.compare.uml2.internal.postprocessor.util.UMLCompareUtil;
import org.eclipse.emf.ecore.EObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpaqueElementBodyChangeMerger
extends AttributeChangeMerger {
    public boolean isMergerFor(Diff target) {
        return this.isOrRefinesOpaqueElementBodyChange(target);
    }

    private boolean isOrRefinesOpaqueElementBodyChange(Diff target) {
        return this.getOpaqueElementBodyChange(target).isPresent();
    }

    private Optional<OpaqueElementBodyChange> getOpaqueElementBodyChange(Diff diff) {
        Object bodyChange = diff instanceof OpaqueElementBodyChange ? Optional.of((Object)((OpaqueElementBodyChange)diff)) : (!diff.getRefines().isEmpty() ? this.getRefinedOpaqueElementBodyChange(diff) : Optional.absent());
        return bodyChange;
    }

    private Optional<OpaqueElementBodyChange> getRefinedOpaqueElementBodyChange(Diff diff) {
        for (Diff refinedDiff : diff.getRefines()) {
            if (!(refinedDiff instanceof OpaqueElementBodyChange)) continue;
            return Optional.of((Object)((OpaqueElementBodyChange)refinedDiff));
        }
        return Optional.absent();
    }

    protected void accept(Diff diff, boolean rightToLeft) {
        Optional<OpaqueElementBodyChange> possibleBodyChange = this.getOpaqueElementBodyChange(diff);
        if (possibleBodyChange.isPresent()) {
            OpaqueElementBodyChange bodyChange = (OpaqueElementBodyChange)this.getOpaqueElementBodyChange(diff).get();
            switch (bodyChange.getKind()) {
                case ADD: {
                    this.delegateAccept(diff, rightToLeft);
                    break;
                }
                case DELETE: {
                    this.delegateAccept(diff, rightToLeft);
                    break;
                }
                case CHANGE: {
                    this.changeElement(bodyChange, rightToLeft);
                    break;
                }
                case MOVE: {
                    this.moveElement(bodyChange, rightToLeft);
                    break;
                }
            }
        }
    }

    protected void reject(Diff diff, boolean rightToLeft) {
        Optional<OpaqueElementBodyChange> possibleBodyChange = this.getOpaqueElementBodyChange(diff);
        if (possibleBodyChange.isPresent()) {
            OpaqueElementBodyChange bodyChange = (OpaqueElementBodyChange)possibleBodyChange.get();
            switch (bodyChange.getKind()) {
                case ADD: {
                    this.delegateReject(diff, rightToLeft);
                    break;
                }
                case DELETE: {
                    this.delegateReject(diff, rightToLeft);
                    break;
                }
                case CHANGE: {
                    this.changeElement(bodyChange, rightToLeft);
                    break;
                }
                case MOVE: {
                    this.moveElement(bodyChange, rightToLeft);
                    break;
                }
            }
        }
    }

    private void delegateAccept(Diff diff, boolean rightToLeft) {
        if (diff instanceof OpaqueElementBodyChange) {
            OpaqueElementBodyChange bodyChange = (OpaqueElementBodyChange)diff;
            this.acceptRefiningDiffs(bodyChange, rightToLeft);
        } else {
            super.accept(diff, rightToLeft);
        }
    }

    private void acceptRefiningDiffs(OpaqueElementBodyChange bodyChange, boolean rightToLeft) {
        bodyChange.setState(DifferenceState.MERGED);
        for (Diff refiningDiff : bodyChange.getRefinedBy()) {
            super.accept(refiningDiff, rightToLeft);
        }
    }

    private void delegateReject(Diff diff, boolean rightToLeft) {
        if (diff instanceof OpaqueElementBodyChange) {
            OpaqueElementBodyChange bodyChange = (OpaqueElementBodyChange)diff;
            this.rejectRefiningDiffs(bodyChange, rightToLeft);
        } else {
            super.reject(diff, rightToLeft);
        }
    }

    private void rejectRefiningDiffs(OpaqueElementBodyChange bodyChange, boolean rightToLeft) {
        bodyChange.setState(DifferenceState.MERGED);
        for (Diff refiningDiff : bodyChange.getRefinedBy()) {
            super.reject(refiningDiff, rightToLeft);
        }
    }

    private void changeElement(OpaqueElementBodyChange bodyChange, boolean rightToLeft) {
        String newBody;
        Match match = bodyChange.getMatch();
        Comparison comparison = match.getComparison();
        String language = bodyChange.getLanguage();
        EObject leftContainer = match.getLeft();
        EObject rightContainer = match.getRight();
        String leftBody = UMLCompareUtil.getOpaqueElementBody(leftContainer, language);
        String rightBody = UMLCompareUtil.getOpaqueElementBody(rightContainer, language);
        if (comparison.isThreeWay()) {
            EObject originContainer = match.getOrigin();
            String originBody = UMLCompareUtil.getOpaqueElementBody(originContainer, language);
            newBody = this.isAcceptingChange(bodyChange, rightToLeft) ? this.performThreeWayTextMerge(leftBody, rightBody, originBody) : originBody;
        } else {
            newBody = rightToLeft ? rightBody : leftBody;
        }
        if (rightToLeft) {
            this.setBody(leftContainer, newBody, language);
        } else {
            this.setBody(rightContainer, newBody, language);
        }
        this.setRefiningDiffsMerged(bodyChange);
    }

    private boolean isAcceptingChange(Diff diff, boolean rightToLeft) {
        return diff.getSource() == DifferenceSource.LEFT && !rightToLeft || diff.getSource() == DifferenceSource.RIGHT && rightToLeft;
    }

    private void setBody(EObject container, String newBody, String language) {
        List<String> languages = UMLCompareUtil.getOpaqueElementLanguages(container);
        List<String> bodies = UMLCompareUtil.getOpaqueElementBodies(container);
        int index = languages.indexOf(language);
        bodies.set(index, newBody);
    }

    private void moveElement(OpaqueElementBodyChange bodyChange, boolean rightToLeft) {
        Match match = bodyChange.getMatch();
        Comparison comparison = match.getComparison();
        String language = bodyChange.getLanguage();
        Diff languageAttributeMove = (Diff)this.getLanguageAttributeMove(bodyChange).get();
        EObject container = this.getTargetContainer(match, rightToLeft);
        int sourceIndex = this.getLanguageIndex(container, language);
        int targetIndex = DiffUtil.findInsertionIndex((Comparison)comparison, (Diff)languageAttributeMove, (boolean)rightToLeft);
        this.doMove(container, sourceIndex, targetIndex);
        this.setRefiningDiffsMerged(bodyChange);
    }

    private Optional<Diff> getLanguageAttributeMove(OpaqueElementBodyChange bodyChange) {
        for (Diff diff : bodyChange.getRefinedBy()) {
            if (!(diff instanceof AttributeChange) || !DifferenceKind.MOVE.equals((Object)diff.getKind())) continue;
            return Optional.of((Object)diff);
        }
        return Optional.absent();
    }

    private EObject getTargetContainer(Match match, boolean rightToLeft) {
        if (rightToLeft) {
            return match.getLeft();
        }
        return match.getRight();
    }

    private int getLanguageIndex(EObject container, String language) {
        return UMLCompareUtil.getOpaqueElementLanguages(container).indexOf(language);
    }

    private void doMove(EObject container, int sourceIndex, int targetIndex) {
        List<String> languages = UMLCompareUtil.getOpaqueElementLanguages(container);
        List<String> bodies = UMLCompareUtil.getOpaqueElementBodies(container);
        String bodyValueToMove = bodies.get(sourceIndex);
        String languageValueToMove = languages.get(sourceIndex);
        int insertionIndex = targetIndex;
        if (sourceIndex < targetIndex) {
            --insertionIndex;
        }
        this.move(languages, languageValueToMove, insertionIndex);
        this.move(bodies, bodyValueToMove, insertionIndex);
    }

    private void move(List<String> list, String value, int targetIndex) {
        list.remove(value);
        if (targetIndex < 0 || targetIndex > list.size()) {
            list.add(value);
        } else {
            list.add(targetIndex, value);
        }
    }

    private void setRefiningDiffsMerged(OpaqueElementBodyChange bodyChange) {
        for (Diff refiningDiff : bodyChange.getRefinedBy()) {
            refiningDiff.setState(DifferenceState.MERGED);
        }
    }
}

