/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.internal.conflict;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.compare.ConflictKind;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.FeatureMapChange;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.internal.conflict.AbstractConflictSearch;
import org.eclipse.emf.compare.internal.conflict.ComparisonIndex;
import org.eclipse.emf.compare.utils.EMFComparePredicates;
import org.eclipse.emf.compare.utils.MatchUtil;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.FeatureMap;

public class FeatureMapChangeConflictSearch {

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Add
    extends AbstractConflictSearch<FeatureMapChange> {
        public Add(FeatureMapChange diff, ComparisonIndex index, Monitor monitor) {
            super(diff, index, monitor);
        }

        @Override
        public void detectConflicts() {
            EAttribute feature = ((FeatureMapChange)this.diff).getAttribute();
            if (feature.isUnique()) {
                Object value = ((FeatureMapChange)this.diff).getValue();
                EList<Diff> diffsInSameMatch = ((FeatureMapChange)this.diff).getMatch().getDifferences();
                for (Diff candidate : Iterables.filter(diffsInSameMatch, (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.possiblyConflictingWith(this.diff), Predicates.instanceOf(FeatureMapChange.class), EMFComparePredicates.onFeature((EStructuralFeature)feature), EMFComparePredicates.ofKind(DifferenceKind.ADD)}))) {
                    Object candidateValue = ((FeatureMapChange)candidate).getValue();
                    if (!this.comparison.getEqualityHelper().matchingValues(value, candidateValue)) continue;
                    if (MatchUtil.matchingIndices(((FeatureMapChange)this.diff).getMatch(), (EStructuralFeature)feature, value, candidateValue)) {
                        this.conflict(candidate, ConflictKind.PSEUDO);
                        continue;
                    }
                    this.conflict(candidate, ConflictKind.REAL);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Change
    extends AbstractConflictSearch<FeatureMapChange> {
        public Change(FeatureMapChange diff, ComparisonIndex index, Monitor monitor) {
            super(diff, index, monitor);
        }

        @Override
        public void detectConflicts() {
            Object value = ((FeatureMapChange)this.diff).getValue();
            EAttribute feature = ((FeatureMapChange)this.diff).getAttribute();
            EList<Diff> diffsInSameMatch = ((FeatureMapChange)this.diff).getMatch().getDifferences();
            for (Diff candidate : Iterables.filter(diffsInSameMatch, (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.possiblyConflictingWith(this.diff), Predicates.instanceOf(FeatureMapChange.class), EMFComparePredicates.onFeature((EStructuralFeature)feature), EMFComparePredicates.ofKind(DifferenceKind.CHANGE)}))) {
                Object candidateValue = ((FeatureMapChange)candidate).getValue();
                if (this.comparison.getEqualityHelper().matchingValues(value, candidateValue)) {
                    this.conflict(candidate, ConflictKind.PSEUDO);
                    continue;
                }
                if (this.isFeatureMapChangeOrMergeableStringAttributeChange(this.diff, candidate)) continue;
                this.conflict(candidate, ConflictKind.REAL);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Delete
    extends AbstractConflictSearch<FeatureMapChange> {
        public Delete(FeatureMapChange diff, ComparisonIndex index, Monitor monitor) {
            super(diff, index, monitor);
        }

        @Override
        public void detectConflicts() {
            Object value = ((FeatureMapChange)this.diff).getValue();
            EAttribute feature = ((FeatureMapChange)this.diff).getAttribute();
            EList<Diff> diffsInSameMatch = ((FeatureMapChange)this.diff).getMatch().getDifferences();
            for (Diff candidate : Iterables.filter(diffsInSameMatch, (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.possiblyConflictingWith(this.diff), Predicates.instanceOf(FeatureMapChange.class), EMFComparePredicates.onFeature((EStructuralFeature)feature), EMFComparePredicates.ofKind(DifferenceKind.MOVE, DifferenceKind.DELETE)}))) {
                Object candidateValue = ((FeatureMapChange)candidate).getValue();
                if (!this.comparison.getEqualityHelper().matchingValues(value, candidateValue)) continue;
                if (candidate.getKind() == DifferenceKind.MOVE) {
                    this.conflict(candidate, ConflictKind.REAL);
                    continue;
                }
                if (((FeatureMapChange)this.diff).getMatch() != candidate.getMatch()) continue;
                this.conflict(candidate, ConflictKind.PSEUDO);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Move
    extends AbstractConflictSearch<FeatureMapChange> {
        public Move(FeatureMapChange diff, ComparisonIndex index, Monitor monitor) {
            super(diff, index, monitor);
        }

        @Override
        public void detectConflicts() {
            Match diffMatch = ((FeatureMapChange)this.diff).getMatch();
            FeatureMap.Entry entry = (FeatureMap.Entry)((FeatureMapChange)this.diff).getValue();
            Object value = entry.getValue();
            EAttribute feature = ((FeatureMapChange)this.diff).getAttribute();
            EList<Diff> diffsInSameMatch = diffMatch.getDifferences();
            for (Diff candidate : Iterables.filter(diffsInSameMatch, (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.possiblyConflictingWith(this.diff), Predicates.instanceOf(FeatureMapChange.class), EMFComparePredicates.valueMatches(this.comparison.getEqualityHelper(), value), EMFComparePredicates.onFeature((EStructuralFeature)feature), EMFComparePredicates.ofKind(DifferenceKind.MOVE)}))) {
                Object candidateValue = ((FeatureMapChange)candidate).getValue();
                if (MatchUtil.matchingIndices(((FeatureMapChange)this.diff).getMatch(), (EStructuralFeature)feature, value, candidateValue)) {
                    this.conflict(candidate, ConflictKind.PSEUDO);
                    continue;
                }
                this.conflict(candidate, ConflictKind.REAL);
            }
        }
    }
}

