/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.uml2.papyrus.internal.hook.migration;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.eclipse.emf.compare.uml2.papyrus.internal.UMLPapyrusCompareMessages;
import org.eclipse.emf.compare.uml2.papyrus.internal.hook.migration.ProfileMigrationDiagnostic;
import org.eclipse.emf.compare.uml2.papyrus.internal.hook.migration.ProfileNamespaceURIPatternAPI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.UMLPlugin;
import org.eclipse.uml2.uml.util.UMLUtil;

public class MissingProfileSupplier
implements Function<EPackage, Profile> {
    protected static final double DISTANCE_THRESHOLD = 0.25;
    protected final Element root;
    private final Map<EPackage, Optional<Profile>> packageToProfileCache = Maps.newHashMap();

    public MissingProfileSupplier(Element root) {
        this.root = root;
    }

    protected Optional<Profile> findClosestProfile(EPackage missingPackage) {
        Map<String, Double> closestPackageUris = this.getClosestPackageURIs(missingPackage);
        Optional<Profile> foundProfile = Optional.absent();
        for (Map.Entry<String, Double> closestUri : closestPackageUris.entrySet()) {
            String packageURI;
            if (!(closestUri.getValue() <= 0.25) || !(foundProfile = this.getProfileFromRegistry(packageURI = closestUri.getKey())).isPresent()) continue;
            return foundProfile;
        }
        return foundProfile;
    }

    protected Map<String, Double> getClosestPackageURIs(EPackage missingPackage) {
        Map profileLocationMap = UMLPlugin.getEPackageNsURIToProfileLocationMap();
        HashMap closestPackageUris = Maps.newHashMap();
        double minDistance = Double.MAX_VALUE;
        for (String packageUri : profileLocationMap.keySet()) {
            double distance = this.getDistance(packageUri, missingPackage.getNsURI());
            if (distance == minDistance) {
                closestPackageUris.put(packageUri, new Double(distance));
                continue;
            }
            if (!(distance < minDistance)) continue;
            minDistance = distance;
            closestPackageUris.clear();
            closestPackageUris.put(packageUri, new Double(distance));
        }
        return closestPackageUris;
    }

    protected double getDistance(String left, String right) {
        double avgLength = (double)Math.min(left.length(), right.length()) + (double)Math.abs(left.length() - right.length()) / 2.0;
        return (double)StringUtils.getLevenshteinDistance((String)left, (String)right) / avgLength;
    }

    protected Optional<Profile> findMatchingProfile(EPackage missingPackage) {
        String missingPackageURI = missingPackage.getNsURI();
        Map profileLocationMap = UMLPlugin.getEPackageNsURIToProfileLocationMap();
        Optional<Profile> foundProfile = Optional.absent();
        for (String packageURI : profileLocationMap.keySet()) {
            if (!ProfileNamespaceURIPatternAPI.isEqualVersionlessNamespaceURI(missingPackageURI, packageURI) || !(foundProfile = this.getProfileFromRegistry(packageURI)).isPresent()) continue;
            return foundProfile;
        }
        return foundProfile;
    }

    protected Optional<Profile> getProfileFromRegistry(String packageURI) {
        Optional foundProfile = Optional.absent();
        EPackage registeredPackage = EPackage.Registry.INSTANCE.getEPackage(packageURI);
        if (registeredPackage != null && (foundProfile = this.packageToProfileCache.get(registeredPackage)) == null) {
            Profile profile = UMLUtil.getProfile((EPackage)registeredPackage, (EObject)this.root);
            foundProfile = Optional.fromNullable((Object)profile);
            this.packageToProfileCache.put(registeredPackage, (Optional<Profile>)foundProfile);
        }
        return foundProfile;
    }

    protected Resource.Diagnostic createResourceDiagnostic(String message) {
        return new ProfileMigrationDiagnostic(message);
    }

    protected void addResourceWarning(String message) {
        this.root.eResource().getWarnings().add((Object)this.createResourceDiagnostic(message));
    }

    protected void addResourceError(String message) {
        this.root.eResource().getErrors().add((Object)this.createResourceDiagnostic(message));
    }

    protected String getSuccessMessage(String missingPackage, String profile) {
        return UMLPapyrusCompareMessages.getString("profile.migration.success", missingPackage, profile);
    }

    protected String getFailMessage(String missingPackage) {
        return UMLPapyrusCompareMessages.getString("profile.migration.fail", missingPackage);
    }

    protected Optional<Profile> findProfile(EPackage missingPackage) {
        if (ProfileNamespaceURIPatternAPI.isAvailable()) {
            return this.findMatchingProfile(missingPackage);
        }
        return this.findClosestProfile(missingPackage);
    }

    public Profile apply(EPackage missingPackage) {
        Optional<Profile> foundProfile = this.findProfile(missingPackage);
        if (foundProfile.isPresent()) {
            Profile profile = (Profile)foundProfile.get();
            String message = this.getSuccessMessage(missingPackage.getNsURI(), profile.getURI());
            this.addResourceWarning(message);
            return profile;
        }
        String message = this.getFailMessage(missingPackage.getNsURI());
        this.addResourceError(message);
        return null;
    }
}

