/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.diagram.papyrus.internal;

import java.util.Iterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.MatchResource;
import org.eclipse.emf.compare.postprocessor.IPostProcessor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;

public class IgnoreDiFilePostProcessor
implements IPostProcessor {
    private static final String SASH_WINDOWS_MNGR = "SashWindowsMngr";
    private static final String DI = "di";

    public void postMatch(Comparison comparison, Monitor monitor) {
        if (monitor == null || !monitor.isCanceled()) {
            this.filterSashModelMngrMatches(comparison);
            this.filterDiFileMatchResources(comparison);
        }
    }

    private void filterDiFileMatchResources(Comparison comparison) {
        EList matchedResources = comparison.getMatchedResources();
        Iterator iterator = matchedResources.iterator();
        while (iterator.hasNext()) {
            if (!this.isDiFile((MatchResource)iterator.next())) continue;
            iterator.remove();
        }
    }

    private void filterSashModelMngrMatches(Comparison comparison) {
        EList matches = comparison.getMatches();
        Iterator iterator = matches.iterator();
        while (iterator.hasNext()) {
            EObject eObject = this.getMatchedEObject((Match)iterator.next());
            if (!this.isDiResource(eObject.eResource()) || !SASH_WINDOWS_MNGR.equals(eObject.eClass().getName())) continue;
            iterator.remove();
        }
    }

    private boolean isDiResource(Resource resource) {
        return resource == null || DI.equals(resource.getURI().fileExtension());
    }

    private EObject getMatchedEObject(Match match) {
        EObject eObject = match.getLeft() != null ? match.getLeft() : (match.getRight() != null ? match.getRight() : match.getOrigin());
        return eObject;
    }

    private boolean isDiFile(MatchResource matchResource) {
        Resource resource = matchResource.getLeft() != null ? matchResource.getLeft() : (matchResource.getRight() != null ? matchResource.getRight() : matchResource.getOrigin());
        return this.isDiResource(resource);
    }

    public void postDiff(Comparison comparison, Monitor monitor) {
    }

    public void postRequirements(Comparison comparison, Monitor monitor) {
    }

    public void postEquivalences(Comparison comparison, Monitor monitor) {
    }

    public void postConflicts(Comparison comparison, Monitor monitor) {
    }

    public void postComparison(Comparison comparison, Monitor monitor) {
    }
}

