/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.diagram.ide.ui.papyrus.contentmergeviewer.facet;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.diagram.ide.ui.papyrus.contentmergeviewer.facet.FacetUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.papyrus.uml.tools.providers.SemanticUMLContentProvider;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.resource.UMLResource;

public class PapyrusFacetContentProviderWrapper
extends ItemProviderAdapter
implements ITreeItemContentProvider {
    private SemanticUMLContentProvider facetContentProvider;
    private ResourceSet resourceSet;

    public PapyrusFacetContentProviderWrapper(AdapterFactory adapterFactory, ResourceSet resourceSet) {
        super(adapterFactory);
        this.facetContentProvider = new SemanticUMLContentProvider(resourceSet);
        this.resourceSet = resourceSet;
    }

    public Collection<?> getElements(Object object) {
        EObject rootElement = this.getRootElement();
        LinkedList<EObject> rootElements = new LinkedList<EObject>();
        for (Resource resource : this.resourceSet.getResources()) {
            if (!MySemanticUMLContentProvider.isUMLModel(resource, rootElement)) continue;
            for (EObject rootEObject : resource.getContents()) {
                if (!Element.class.isInstance(rootEObject)) continue;
                rootElements.add(rootEObject);
            }
        }
        return rootElements;
    }

    private EObject getRootElement() {
        EObject rootElement = null;
        EObject rootProfile = null;
        for (Resource resource : this.resourceSet.getResources()) {
            if (!MySemanticUMLContentProvider.isUMLResource(resource) || resource.getContents().isEmpty()) continue;
            EObject resourceElement = (EObject)resource.getContents().get(0);
            if (Profile.class.isInstance(resourceElement)) {
                if (rootProfile != null) continue;
                rootProfile = resourceElement;
                continue;
            }
            if (!Element.class.isInstance(resourceElement) || rootElement != null) continue;
            rootElement = resourceElement;
        }
        if (rootElement != null) {
            return rootElement;
        }
        return rootProfile;
    }

    public Collection<?> getChildren(Object object) {
        return this.removeDuplicates(this.unwrapFacet(this.facetContentProvider.getChildren(object)));
    }

    public boolean hasChildren(Object object) {
        return this.facetContentProvider.hasChildren(object);
    }

    public Object getParent(Object object) {
        return FacetUtil.UN_WRAP.apply(this.facetContentProvider.getParent(object));
    }

    private List<Object> removeDuplicates(Iterable<Object> objects) {
        return ImmutableSet.copyOf(objects).asList();
    }

    private List<Object> unwrapFacet(Object[] elements) {
        return Lists.newArrayList((Iterable)Iterables.transform(Arrays.asList(elements), FacetUtil.UN_WRAP));
    }

    public void dispose() {
        this.facetContentProvider.dispose();
        super.dispose();
    }

    private static class MySemanticUMLContentProvider
    extends SemanticUMLContentProvider {
        private MySemanticUMLContentProvider() {
        }

        public static boolean isUMLModel(Resource resource, EObject rootElement) {
            if (!MySemanticUMLContentProvider.isUMLResource(resource)) {
                return false;
            }
            URI[] uRIArray = excludedModels;
            int n = excludedModels.length;
            int n2 = 0;
            while (n2 < n) {
                URI uri = uRIArray[n2];
                if (uri.equals(resource.getURI())) {
                    return false;
                }
                ++n2;
            }
            for (EObject rootObject : resource.getContents()) {
                if (rootObject.eIsProxy() || rootObject.eContainer() == null && (!(rootObject instanceof Profile) || rootElement instanceof Profile)) continue;
                return false;
            }
            return true;
        }

        public static boolean isUMLResource(Resource resource) {
            if (resource == null) {
                return false;
            }
            if (resource instanceof UMLResource) {
                return true;
            }
            URI uri = resource.getURI();
            return uri != null && uri.fileExtension().startsWith("uml");
        }
    }
}

