/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.logical;

import com.google.common.base.Preconditions;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.RemoteResourceMappingContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.compare.ide.ui.internal.logical.RemoteMappingStorageProvider;
import org.eclipse.emf.compare.ide.ui.internal.logical.RenameDetector;
import org.eclipse.emf.compare.ide.ui.logical.IStorageProvider;
import org.eclipse.emf.compare.ide.ui.logical.IStorageProviderAccessor;
import org.eclipse.team.core.subscribers.Subscriber;
import org.eclipse.team.core.subscribers.SubscriberResourceMappingContext;

public class RemoteMappingContextStorageAccessor
implements IStorageProviderAccessor {
    private final RemoteResourceMappingContext context;
    private final RenameDetector renameDetector;

    public RemoteMappingContextStorageAccessor(RemoteResourceMappingContext context) {
        this.context = (RemoteResourceMappingContext)Preconditions.checkNotNull((Object)context);
        this.renameDetector = new RenameDetector(this.obtainSubscriber(context), this);
        if (context instanceof SubscriberResourceMappingContext) {
            ((SubscriberResourceMappingContext)context).setAutoRefresh(false);
        }
    }

    private Subscriber obtainSubscriber(final RemoteResourceMappingContext remoteResourceMappingContext) {
        Object subscriber = AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                try {
                    Field field = SubscriberResourceMappingContext.class.getDeclaredField("subscriber");
                    field.setAccessible(true);
                    Object subscriberValue = field.get(remoteResourceMappingContext);
                    return subscriberValue;
                }
                catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException exception) {
                    return null;
                }
            }
        });
        if (subscriber instanceof Subscriber) {
            return (Subscriber)subscriber;
        }
        return null;
    }

    @Override
    public IStorageProvider getStorageProvider(IResource resource, IStorageProviderAccessor.DiffSide side) throws CoreException {
        resource.getProjectRelativePath();
        if (resource instanceof IFile) {
            return new RemoteMappingStorageProvider(this.context, side, (IFile)resource);
        }
        return null;
    }

    @Override
    public boolean isInSync(IResource resource) throws CoreException {
        NullProgressMonitor monitor = new NullProgressMonitor();
        return this.context.hasLocalChange(resource, (IProgressMonitor)monitor) || this.context.hasRemoteChange(resource, (IProgressMonitor)monitor);
    }

    @Override
    public IFile getFileBeforeRename(IFile sourceOrRemoteFile, IStorageProviderAccessor.DiffSide side) {
        return (IFile)this.renameDetector.getFileBeforeRename(sourceOrRemoteFile, side).orNull();
    }

    @Override
    public IFile getFileAfterRename(IFile originFile, IStorageProviderAccessor.DiffSide side) {
        return (IFile)this.renameDetector.getFileAfterRename(originFile, side).orNull();
    }
}

