/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.tests.structuremergeviewer.actions;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.DifferenceState;
import org.eclipse.emf.compare.EMFCompare;
import org.eclipse.emf.compare.domain.impl.EMFCompareEditingDomain;
import org.eclipse.emf.compare.ide.ui.tests.structuremergeviewer.actions.AbstractTestUITreeNodeItemProviderAdapter;
import org.eclipse.emf.compare.ide.ui.tests.structuremergeviewer.actions.MockMergeAction;
import org.eclipse.emf.compare.internal.merge.MergeMode;
import org.eclipse.emf.compare.internal.merge.MergeOperation;
import org.eclipse.emf.compare.merge.IMerger;
import org.eclipse.emf.compare.rcp.EMFCompareRCPPlugin;
import org.eclipse.emf.compare.rcp.internal.extension.impl.EMFCompareBuilderConfigurator;
import org.eclipse.emf.compare.rcp.ui.internal.configuration.IEMFCompareConfiguration;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.groups.impl.DefaultGroupProvider;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.groups.provider.TreeNodeItemProviderSpec;
import org.eclipse.emf.compare.scope.DefaultComparisonScope;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.emf.compare.tests.merge.data.IndividualDiffInputData;
import org.eclipse.emf.compare.utils.EMFComparePredicates;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.tree.TreeFactory;
import org.eclipse.emf.edit.tree.TreeNode;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PseudoConflictsMergeActionTest
extends AbstractTestUITreeNodeItemProviderAdapter {
    private static TreeNodeItemProviderSpec itemProvider;
    private IMerger.Registry mergerRegistry;
    private TreeNode leftAdd;
    private TreeNode rightAdd;
    private TreeNode leftDelete;
    private TreeNode rightDelete;
    private TreeNode leftChange;
    private TreeNode rightChange;

    @Before
    public void before() throws IOException {
        super.before();
        itemProvider = (TreeNodeItemProviderSpec)this.treeItemProviderAdapterFactory.createTreeNodeAdapter();
        this.mergerRegistry = EMFCompareRCPPlugin.getDefault().getMergerRegistry();
        IndividualDiffInputData scopeProvider = new IndividualDiffInputData();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)scopeProvider.getLeftPseudoConflictFullScope(), (Notifier)scopeProvider.getRightPseudoConflictFullScope(), (Notifier)scopeProvider.getOriginPseudoConflictFullScope());
        EMFCompare.Builder comparisonBuilder = EMFCompare.builder();
        EMFCompareBuilderConfigurator.createDefault().configure(comparisonBuilder);
        Comparison comparison = comparisonBuilder.build().compare((IComparisonScope)scope);
        this.editingDomain = EMFCompareEditingDomain.create((Notifier)scopeProvider.getLeftPseudoConflictFullScope(), (Notifier)scopeProvider.getRightPseudoConflictFullScope(), (Notifier)scopeProvider.getOriginPseudoConflictFullScope());
        TreeNode nodeRootMatch = PseudoConflictsMergeActionTest.getNodeRootMatch(comparison);
        EList differences = comparison.getDifferences();
        Diff leftAddDiff = (Diff)Iterators.find((Iterator)differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.ADD)));
        this.leftAdd = PseudoConflictsMergeActionTest.getTreeNode((TreeNode)((TreeNode)nodeRootMatch.getChildren().get(0)), (EObject)leftAddDiff);
        Diff rightAddDiff = (Diff)Iterators.find((Iterator)differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), (Predicate)EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.ADD)));
        this.rightAdd = PseudoConflictsMergeActionTest.getTreeNode((TreeNode)((TreeNode)nodeRootMatch.getChildren().get(0)), (EObject)rightAddDiff);
        Diff leftDeleteDiff = (Diff)Iterators.find((Iterator)differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.DELETE)));
        this.leftDelete = PseudoConflictsMergeActionTest.getTreeNode((TreeNode)((TreeNode)nodeRootMatch.getChildren().get(2)), (EObject)leftDeleteDiff);
        Diff rightDeleteDiff = (Diff)Iterators.find((Iterator)differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), (Predicate)EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.DELETE)));
        this.rightDelete = PseudoConflictsMergeActionTest.getTreeNode((TreeNode)((TreeNode)nodeRootMatch.getChildren().get(2)), (EObject)rightDeleteDiff);
        TreeNode nodeD = (TreeNode)((TreeNode)nodeRootMatch.getChildren().get(1)).getChildren().get(0);
        Diff leftChangeDiff = (Diff)Iterators.find((Iterator)differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), (Predicate)EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.CHANGE)));
        this.leftChange = PseudoConflictsMergeActionTest.getTreeNode((TreeNode)nodeD, (EObject)leftChangeDiff);
        Diff rightChangeDiff = (Diff)Iterators.find((Iterator)differences.iterator(), (Predicate)Predicates.and((Predicate)EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), (Predicate)EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.CHANGE)));
        this.rightChange = PseudoConflictsMergeActionTest.getTreeNode((TreeNode)nodeD, (EObject)rightChangeDiff);
    }

    @Test
    public void testAcceptLocalLeftEditable() throws Exception {
        MergeMode accept = MergeMode.ACCEPT;
        boolean leftEditable = true;
        boolean rightEditable = false;
        TreeNode localAdd = this.leftAdd;
        TreeNode remoteAdd = this.rightAdd;
        TreeNode localDelete = this.leftDelete;
        TreeNode remoteDelete = this.rightDelete;
        TreeNode localChange = this.leftChange;
        TreeNode remoteChange = this.rightChange;
        IEMFCompareConfiguration emfCC = this.createConfiguration(true, false);
        MockMergeAction action = new MockMergeAction(emfCC, this.mergerRegistry, accept, null);
        Diff localAddDiff = (Diff)localAdd.getData();
        Diff remoteAddDiff = (Diff)remoteAdd.getData();
        Assert.assertTrue((boolean)accept.isLeftToRight(localAddDiff, true, false));
        Assert.assertEquals((Object)MergeOperation.MARK_AS_MERGE, (Object)accept.getMergeAction(localAddDiff, true, false));
        action.updateSelection((IStructuredSelection)new StructuredSelection((Object)localAdd));
        action.run();
        Assert.assertEquals((Object)DifferenceState.MERGED, (Object)localAddDiff.getState());
        Assert.assertEquals((Object)DifferenceState.MERGED, (Object)remoteAddDiff.getState());
        Diff localDeleteDiff = (Diff)localDelete.getData();
        Diff remoteDeleteDiff = (Diff)remoteDelete.getData();
        Assert.assertTrue((boolean)accept.isLeftToRight(localDeleteDiff, true, false));
        Assert.assertEquals((Object)MergeOperation.MARK_AS_MERGE, (Object)accept.getMergeAction(localDeleteDiff, true, false));
        action.updateSelection((IStructuredSelection)new StructuredSelection((Object)localDelete));
        action.run();
        Assert.assertEquals((Object)DifferenceState.MERGED, (Object)localDeleteDiff.getState());
        Assert.assertEquals((Object)DifferenceState.MERGED, (Object)remoteDeleteDiff.getState());
        Diff localChangeDiff = (Diff)localChange.getData();
        Diff remoteChangeDiff = (Diff)remoteChange.getData();
        Assert.assertTrue((boolean)accept.isLeftToRight(localChangeDiff, true, false));
        Assert.assertEquals((Object)MergeOperation.MARK_AS_MERGE, (Object)accept.getMergeAction(localChangeDiff, true, false));
        action.updateSelection((IStructuredSelection)new StructuredSelection((Object)localChange));
        action.run();
        Assert.assertEquals((Object)DifferenceState.MERGED, (Object)localChangeDiff.getState());
        Assert.assertEquals((Object)DifferenceState.MERGED, (Object)remoteChangeDiff.getState());
    }

    @Test
    public void testRejectLocalLeftEditable() throws Exception {
        MergeMode reject = MergeMode.REJECT;
        boolean leftEditable = true;
        boolean rightEditable = false;
        TreeNode localAdd = this.leftAdd;
        TreeNode remoteAdd = this.rightAdd;
        TreeNode localDelete = this.leftDelete;
        TreeNode remoteDelete = this.rightDelete;
        TreeNode localChange = this.leftChange;
        TreeNode remoteChange = this.rightChange;
        IEMFCompareConfiguration emfCC = this.createConfiguration(true, false);
        MockMergeAction action = new MockMergeAction(emfCC, this.mergerRegistry, reject, null);
        Diff localAddDiff = (Diff)localAdd.getData();
        Diff remoteAddDiff = (Diff)remoteAdd.getData();
        Assert.assertFalse((boolean)reject.isLeftToRight(localAddDiff, true, false));
        Assert.assertEquals((Object)MergeOperation.MERGE, (Object)reject.getMergeAction(localAddDiff, true, false));
        action.updateSelection((IStructuredSelection)new StructuredSelection((Object)localAdd));
        action.run();
        Assert.assertEquals((Object)DifferenceState.MERGED, (Object)localAddDiff.getState());
        Assert.assertEquals((Object)DifferenceState.MERGED, (Object)remoteAddDiff.getState());
        Diff localDeleteDiff = (Diff)localDelete.getData();
        Diff remoteDeleteDiff = (Diff)remoteDelete.getData();
        Assert.assertFalse((boolean)reject.isLeftToRight(localDeleteDiff, true, false));
        Assert.assertEquals((Object)MergeOperation.MERGE, (Object)reject.getMergeAction(localDeleteDiff, true, false));
        action.updateSelection((IStructuredSelection)new StructuredSelection((Object)localDelete));
        action.run();
        Assert.assertEquals((Object)DifferenceState.MERGED, (Object)localDeleteDiff.getState());
        Assert.assertEquals((Object)DifferenceState.MERGED, (Object)remoteDeleteDiff.getState());
        Diff localChangeDiff = (Diff)localChange.getData();
        Diff remoteChangeDiff = (Diff)remoteChange.getData();
        Assert.assertFalse((boolean)reject.isLeftToRight(localChangeDiff, true, false));
        Assert.assertEquals((Object)MergeOperation.MERGE, (Object)reject.getMergeAction(localChangeDiff, true, false));
        action.updateSelection((IStructuredSelection)new StructuredSelection((Object)localChange));
        action.run();
        Assert.assertEquals((Object)DifferenceState.MERGED, (Object)localChangeDiff.getState());
        Assert.assertEquals((Object)DifferenceState.MERGED, (Object)remoteChangeDiff.getState());
    }

    @Test
    public void testAcceptRemoteLeftEditable() throws Exception {
        MergeMode accept = MergeMode.ACCEPT;
        boolean leftEditable = true;
        boolean rightEditable = false;
        TreeNode localAdd = this.leftAdd;
        TreeNode remoteAdd = this.rightAdd;
        TreeNode localDelete = this.leftDelete;
        TreeNode remoteDelete = this.rightDelete;
        TreeNode localChange = this.leftChange;
        TreeNode remoteChange = this.rightChange;
        IEMFCompareConfiguration emfCC = this.createConfiguration(true, false);
        MockMergeAction action = new MockMergeAction(emfCC, this.mergerRegistry, accept, null);
        Diff localAddDiff = (Diff)localAdd.getData();
        Diff remoteAddDiff = (Diff)remoteAdd.getData();
        Assert.assertFalse((boolean)accept.isLeftToRight(remoteAddDiff, true, false));
        Assert.assertEquals((Object)MergeOperation.MERGE, (Object)accept.getMergeAction(remoteAddDiff, true, false));
        action.updateSelection((IStructuredSelection)new StructuredSelection((Object)remoteAdd));
        action.run();
        Assert.assertEquals((Object)DifferenceState.MERGED, (Object)localAddDiff.getState());
        Assert.assertEquals((Object)DifferenceState.MERGED, (Object)remoteAddDiff.getState());
        Diff localDeleteDiff = (Diff)localDelete.getData();
        Diff remoteDeleteDiff = (Diff)remoteDelete.getData();
        Assert.assertFalse((boolean)accept.isLeftToRight(remoteDeleteDiff, true, false));
        Assert.assertEquals((Object)MergeOperation.MERGE, (Object)accept.getMergeAction(remoteDeleteDiff, true, false));
        action.updateSelection((IStructuredSelection)new StructuredSelection((Object)remoteDelete));
        action.run();
        Assert.assertEquals((Object)DifferenceState.MERGED, (Object)localDeleteDiff.getState());
        Assert.assertEquals((Object)DifferenceState.MERGED, (Object)remoteDeleteDiff.getState());
        Diff localChangeDiff = (Diff)localChange.getData();
        Diff remoteChangeDiff = (Diff)remoteChange.getData();
        Assert.assertFalse((boolean)accept.isLeftToRight(remoteChangeDiff, true, false));
        Assert.assertEquals((Object)MergeOperation.MERGE, (Object)accept.getMergeAction(remoteChangeDiff, true, false));
        action.updateSelection((IStructuredSelection)new StructuredSelection((Object)remoteChange));
        action.run();
        Assert.assertEquals((Object)DifferenceState.MERGED, (Object)localChangeDiff.getState());
        Assert.assertEquals((Object)DifferenceState.MERGED, (Object)remoteChangeDiff.getState());
    }

    @Test
    public void testRejectRemoteLeftEditable() throws Exception {
        MergeMode reject = MergeMode.REJECT;
        boolean leftEditable = true;
        boolean rightEditable = false;
        TreeNode localAdd = this.leftAdd;
        TreeNode remoteAdd = this.rightAdd;
        TreeNode localDelete = this.leftDelete;
        TreeNode remoteDelete = this.rightDelete;
        TreeNode localChange = this.leftChange;
        TreeNode remoteChange = this.rightChange;
        IEMFCompareConfiguration emfCC = this.createConfiguration(true, false);
        MockMergeAction action = new MockMergeAction(emfCC, this.mergerRegistry, reject, null);
        Diff localAddDiff = (Diff)localAdd.getData();
        Diff remoteAddDiff = (Diff)remoteAdd.getData();
        Assert.assertTrue((boolean)reject.isLeftToRight(remoteAddDiff, true, false));
        Assert.assertEquals((Object)MergeOperation.MARK_AS_MERGE, (Object)reject.getMergeAction(remoteAddDiff, true, false));
        action.updateSelection((IStructuredSelection)new StructuredSelection((Object)remoteAdd));
        action.run();
        Assert.assertEquals((Object)DifferenceState.DISCARDED, (Object)localAddDiff.getState());
        Assert.assertEquals((Object)DifferenceState.DISCARDED, (Object)remoteAddDiff.getState());
        Diff localDeleteDiff = (Diff)localDelete.getData();
        Diff remoteDeleteDiff = (Diff)remoteDelete.getData();
        Assert.assertTrue((boolean)reject.isLeftToRight(remoteDeleteDiff, true, false));
        Assert.assertEquals((Object)MergeOperation.MARK_AS_MERGE, (Object)reject.getMergeAction(remoteDeleteDiff, true, false));
        action.updateSelection((IStructuredSelection)new StructuredSelection((Object)remoteDelete));
        action.run();
        Assert.assertEquals((Object)DifferenceState.DISCARDED, (Object)localDeleteDiff.getState());
        Assert.assertEquals((Object)DifferenceState.DISCARDED, (Object)remoteDeleteDiff.getState());
        Diff localChangeDiff = (Diff)localChange.getData();
        Diff remoteChangeDiff = (Diff)remoteChange.getData();
        Assert.assertTrue((boolean)reject.isLeftToRight(remoteChangeDiff, true, false));
        Assert.assertEquals((Object)MergeOperation.MARK_AS_MERGE, (Object)reject.getMergeAction(remoteChangeDiff, true, false));
        action.updateSelection((IStructuredSelection)new StructuredSelection((Object)remoteChange));
        action.run();
        Assert.assertEquals((Object)DifferenceState.DISCARDED, (Object)localChangeDiff.getState());
        Assert.assertEquals((Object)DifferenceState.DISCARDED, (Object)remoteChangeDiff.getState());
    }

    @Test
    public void testAcceptLocalRightEditable() throws Exception {
        MergeMode accept = MergeMode.ACCEPT;
        boolean leftEditable = false;
        boolean rightEditable = true;
        TreeNode localAdd = this.rightAdd;
        TreeNode remoteAdd = this.leftAdd;
        TreeNode localDelete = this.rightDelete;
        TreeNode remoteDelete = this.leftDelete;
        TreeNode localChange = this.rightChange;
        TreeNode remoteChange = this.leftChange;
        IEMFCompareConfiguration emfCC = this.createConfiguration(false, true);
        MockMergeAction action = new MockMergeAction(emfCC, this.mergerRegistry, accept, null);
        Diff localAddDiff = (Diff)localAdd.getData();
        Diff remoteAddDiff = (Diff)remoteAdd.getData();
        Assert.assertFalse((boolean)accept.isLeftToRight(localAddDiff, false, true));
        Assert.assertEquals((Object)MergeOperation.MARK_AS_MERGE, (Object)accept.getMergeAction(localAddDiff, false, true));
        action.updateSelection((IStructuredSelection)new StructuredSelection((Object)localAdd));
        action.run();
        Assert.assertEquals((Object)DifferenceState.MERGED, (Object)localAddDiff.getState());
        Assert.assertEquals((Object)DifferenceState.MERGED, (Object)remoteAddDiff.getState());
        Diff localDeleteDiff = (Diff)localDelete.getData();
        Diff remoteDeleteDiff = (Diff)remoteDelete.getData();
        Assert.assertFalse((boolean)accept.isLeftToRight(localDeleteDiff, false, true));
        Assert.assertEquals((Object)MergeOperation.MARK_AS_MERGE, (Object)accept.getMergeAction(localDeleteDiff, false, true));
        action.updateSelection((IStructuredSelection)new StructuredSelection((Object)localDelete));
        action.run();
        Assert.assertEquals((Object)DifferenceState.MERGED, (Object)localDeleteDiff.getState());
        Assert.assertEquals((Object)DifferenceState.MERGED, (Object)remoteDeleteDiff.getState());
        Diff localChangeDiff = (Diff)localChange.getData();
        Diff remoteChangeDiff = (Diff)remoteChange.getData();
        Assert.assertFalse((boolean)accept.isLeftToRight(localChangeDiff, false, true));
        Assert.assertEquals((Object)MergeOperation.MARK_AS_MERGE, (Object)accept.getMergeAction(localChangeDiff, false, true));
        action.updateSelection((IStructuredSelection)new StructuredSelection((Object)localChange));
        action.run();
        Assert.assertEquals((Object)DifferenceState.MERGED, (Object)localChangeDiff.getState());
        Assert.assertEquals((Object)DifferenceState.MERGED, (Object)remoteChangeDiff.getState());
    }

    @Test
    public void testRejectLocalRightEditable() throws Exception {
        MergeMode reject = MergeMode.REJECT;
        boolean leftEditable = false;
        boolean rightEditable = true;
        TreeNode localAdd = this.rightAdd;
        TreeNode remoteAdd = this.leftAdd;
        TreeNode localDelete = this.rightDelete;
        TreeNode remoteDelete = this.leftDelete;
        TreeNode localChange = this.rightChange;
        TreeNode remoteChange = this.leftChange;
        IEMFCompareConfiguration emfCC = this.createConfiguration(false, true);
        MockMergeAction action = new MockMergeAction(emfCC, this.mergerRegistry, reject, null);
        Diff localAddDiff = (Diff)localAdd.getData();
        Diff remoteAddDiff = (Diff)remoteAdd.getData();
        Assert.assertTrue((boolean)reject.isLeftToRight(localAddDiff, false, true));
        Assert.assertEquals((Object)MergeOperation.MERGE, (Object)reject.getMergeAction(localAddDiff, false, true));
        action.updateSelection((IStructuredSelection)new StructuredSelection((Object)localAdd));
        action.run();
        Assert.assertEquals((Object)DifferenceState.MERGED, (Object)localAddDiff.getState());
        Assert.assertEquals((Object)DifferenceState.MERGED, (Object)remoteAddDiff.getState());
        Diff localDeleteDiff = (Diff)localDelete.getData();
        Diff remoteDeleteDiff = (Diff)remoteDelete.getData();
        Assert.assertTrue((boolean)reject.isLeftToRight(localDeleteDiff, false, true));
        Assert.assertEquals((Object)MergeOperation.MERGE, (Object)reject.getMergeAction(localDeleteDiff, false, true));
        action.updateSelection((IStructuredSelection)new StructuredSelection((Object)localDelete));
        action.run();
        Assert.assertEquals((Object)DifferenceState.MERGED, (Object)localDeleteDiff.getState());
        Assert.assertEquals((Object)DifferenceState.MERGED, (Object)remoteDeleteDiff.getState());
        Diff localChangeDiff = (Diff)localChange.getData();
        Diff remoteChangeDiff = (Diff)remoteChange.getData();
        Assert.assertTrue((boolean)reject.isLeftToRight(localChangeDiff, false, true));
        Assert.assertEquals((Object)MergeOperation.MERGE, (Object)reject.getMergeAction(localChangeDiff, false, true));
        action.updateSelection((IStructuredSelection)new StructuredSelection((Object)localChange));
        action.run();
        Assert.assertEquals((Object)DifferenceState.MERGED, (Object)localChangeDiff.getState());
        Assert.assertEquals((Object)DifferenceState.MERGED, (Object)remoteChangeDiff.getState());
    }

    @Test
    public void testAcceptRemoteRightEditable() throws Exception {
        MergeMode accept = MergeMode.ACCEPT;
        boolean leftEditable = false;
        boolean rightEditable = true;
        TreeNode localAdd = this.rightAdd;
        TreeNode remoteAdd = this.leftAdd;
        TreeNode localDelete = this.rightDelete;
        TreeNode remoteDelete = this.leftDelete;
        TreeNode localChange = this.rightChange;
        TreeNode remoteChange = this.leftChange;
        IEMFCompareConfiguration emfCC = this.createConfiguration(false, true);
        MockMergeAction action = new MockMergeAction(emfCC, this.mergerRegistry, accept, null);
        Diff localAddDiff = (Diff)localAdd.getData();
        Diff remoteAddDiff = (Diff)remoteAdd.getData();
        Assert.assertTrue((boolean)accept.isLeftToRight(remoteAddDiff, false, true));
        Assert.assertEquals((Object)MergeOperation.MERGE, (Object)accept.getMergeAction(remoteAddDiff, false, true));
        action.updateSelection((IStructuredSelection)new StructuredSelection((Object)remoteAdd));
        action.run();
        Assert.assertEquals((Object)DifferenceState.MERGED, (Object)localAddDiff.getState());
        Assert.assertEquals((Object)DifferenceState.MERGED, (Object)remoteAddDiff.getState());
        Diff localDeleteDiff = (Diff)localDelete.getData();
        Diff remoteDeleteDiff = (Diff)remoteDelete.getData();
        Assert.assertTrue((boolean)accept.isLeftToRight(remoteDeleteDiff, false, true));
        Assert.assertEquals((Object)MergeOperation.MERGE, (Object)accept.getMergeAction(remoteDeleteDiff, false, true));
        action.updateSelection((IStructuredSelection)new StructuredSelection((Object)remoteDelete));
        action.run();
        Assert.assertEquals((Object)DifferenceState.MERGED, (Object)localDeleteDiff.getState());
        Assert.assertEquals((Object)DifferenceState.MERGED, (Object)remoteDeleteDiff.getState());
        Diff localChangeDiff = (Diff)localChange.getData();
        Diff remoteChangeDiff = (Diff)remoteChange.getData();
        Assert.assertTrue((boolean)accept.isLeftToRight(remoteChangeDiff, false, true));
        Assert.assertEquals((Object)MergeOperation.MERGE, (Object)accept.getMergeAction(remoteChangeDiff, false, true));
        action.updateSelection((IStructuredSelection)new StructuredSelection((Object)remoteChange));
        action.run();
        Assert.assertEquals((Object)DifferenceState.MERGED, (Object)localChangeDiff.getState());
        Assert.assertEquals((Object)DifferenceState.MERGED, (Object)remoteChangeDiff.getState());
    }

    @Test
    public void testRejectRemoteRightEditable() throws Exception {
        MergeMode reject = MergeMode.REJECT;
        boolean leftEditable = false;
        boolean rightEditable = true;
        TreeNode localAdd = this.rightAdd;
        TreeNode remoteAdd = this.leftAdd;
        TreeNode localDelete = this.rightDelete;
        TreeNode remoteDelete = this.leftDelete;
        TreeNode localChange = this.rightChange;
        TreeNode remoteChange = this.leftChange;
        IEMFCompareConfiguration emfCC = this.createConfiguration(false, true);
        MockMergeAction action = new MockMergeAction(emfCC, this.mergerRegistry, reject, null);
        Diff localAddDiff = (Diff)localAdd.getData();
        Diff remoteAddDiff = (Diff)remoteAdd.getData();
        Assert.assertFalse((boolean)reject.isLeftToRight(remoteAddDiff, false, true));
        Assert.assertEquals((Object)MergeOperation.MARK_AS_MERGE, (Object)reject.getMergeAction(remoteAddDiff, false, true));
        action.updateSelection((IStructuredSelection)new StructuredSelection((Object)remoteAdd));
        action.run();
        Assert.assertEquals((Object)DifferenceState.DISCARDED, (Object)localAddDiff.getState());
        Assert.assertEquals((Object)DifferenceState.DISCARDED, (Object)remoteAddDiff.getState());
        Diff localDeleteDiff = (Diff)localDelete.getData();
        Diff remoteDeleteDiff = (Diff)remoteDelete.getData();
        Assert.assertFalse((boolean)reject.isLeftToRight(remoteDeleteDiff, false, true));
        Assert.assertEquals((Object)MergeOperation.MARK_AS_MERGE, (Object)reject.getMergeAction(remoteDeleteDiff, false, true));
        action.updateSelection((IStructuredSelection)new StructuredSelection((Object)remoteDelete));
        action.run();
        Assert.assertEquals((Object)DifferenceState.DISCARDED, (Object)localDeleteDiff.getState());
        Assert.assertEquals((Object)DifferenceState.DISCARDED, (Object)remoteDeleteDiff.getState());
        Diff localChangeDiff = (Diff)localChange.getData();
        Diff remoteChangeDiff = (Diff)remoteChange.getData();
        Assert.assertFalse((boolean)reject.isLeftToRight(remoteChangeDiff, false, true));
        Assert.assertEquals((Object)MergeOperation.MARK_AS_MERGE, (Object)reject.getMergeAction(remoteChangeDiff, false, true));
        action.updateSelection((IStructuredSelection)new StructuredSelection((Object)remoteChange));
        action.run();
        Assert.assertEquals((Object)DifferenceState.DISCARDED, (Object)localChangeDiff.getState());
        Assert.assertEquals((Object)DifferenceState.DISCARDED, (Object)remoteChangeDiff.getState());
    }

    private static TreeNode getNodeRootMatch(Comparison comparison) throws IOException {
        TreeNode treeNode = TreeFactory.eINSTANCE.createTreeNode();
        treeNode.setData((EObject)comparison);
        treeNode.eAdapters().add((Object)new DefaultGroupProvider());
        Collection children = itemProvider.getChildren((Object)treeNode);
        Iterable matches = Iterables.filter((Iterable)children, (Predicate)matchTreeNode);
        return (TreeNode)matches.iterator().next();
    }
}

