/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.tests.structuremergeviewer;

import com.google.common.base.Strings;
import org.eclipse.emf.compare.ide.ui.tests.structuremergeviewer.TestContext;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class NavigatableTest {
    private Shell shell;
    protected TestContext testContext;
    private Display display;

    @Before
    public void before() {
        this.display = Display.getCurrent() != null ? Display.getCurrent() : Display.getDefault();
        this.shell = new Shell(this.display);
        this.testContext = new TestContext(this.shell);
    }

    @After
    public void after() {
        this.testContext.dispose();
        this.shell.dispose();
    }

    @Test
    public void emptyTree() {
        TestContext.TestNavigatable navigatable = this.testContext.buildTree(0, 0);
        this.assertAllNextItems(navigatable, this.testContext);
        this.assertAllPreviousItems(navigatable, this.testContext);
    }

    @Test
    public void littleTree() throws Exception {
        TestContext.TestNavigatable navigatable = this.testContext.buildTree(2, 2);
        this.assertAllNextItems(navigatable, this.testContext);
        this.assertAllPreviousItems(navigatable, this.testContext);
    }

    @Test
    public void deepTree() throws Exception {
        TestContext.TestNavigatable navigatable = this.testContext.buildTree(10, 1);
        this.assertAllNextItems(navigatable, this.testContext);
        this.assertAllPreviousItems(navigatable, this.testContext);
    }

    @Test
    public void wideTree() throws Exception {
        TestContext.TestNavigatable navigatable = this.testContext.buildTree(1, 10);
        this.assertAllNextItems(navigatable, this.testContext);
        this.assertAllPreviousItems(navigatable, this.testContext);
    }

    @Test
    public void bigTree() throws Exception {
        TestContext.TestNavigatable navigatable = this.testContext.buildTree(5, 5);
        this.assertNextIterationStartingOn(navigatable, this.testContext, 0, 3593, 3843, 3874, 3850, 3904);
        this.assertPreviousIterationStartingOn(navigatable, this.testContext, 0, 3593, 3843, 3874, 3850, 3904);
    }

    @Test
    public void testSelectNextChange() {
        TestContext.TestNavigatable navigatable = this.testContext.buildTree(1, 2, false);
        navigatable.selectChange(1);
        this.assertSelectedItemIndex(1);
    }

    @Test
    public void testSelectPreviousChange() {
        TestContext.TestNavigatable navigatable = this.testContext.buildTree(1, 3, false);
        navigatable.selectChange(1);
        navigatable.selectChange(1);
        navigatable.selectChange(2);
        this.assertSelectedItemIndex(1);
    }

    private void assertSelectedItemIndex(int index) {
        Object data = this.testContext.getElement(index);
        Assert.assertNotNull((Object)data);
        Object[] currentSelection = this.testContext.getCurrentSelection();
        Assert.assertEquals((long)1L, (long)currentSelection.length);
        Assert.assertTrue((data == currentSelection[0] ? 1 : 0) != 0);
    }

    private void assertAllNextItems(TestContext.TestNavigatable navigatable, TestContext context) {
        int startingElement = 0;
        while (startingElement <= context.getNumberOfNodes()) {
            this.assertNextIterations(navigatable, context, startingElement);
            ++startingElement;
        }
    }

    private void assertNextIterationStartingOn(TestContext.TestNavigatable navigatable, TestContext context, int ... startingElements) {
        int[] nArray = startingElements;
        int n = startingElements.length;
        int n2 = 0;
        while (n2 < n) {
            int startingElement = nArray[n2];
            this.assertNextIterations(navigatable, context, startingElement);
            ++n2;
        }
    }

    private void assertNextIterations(TestContext.TestNavigatable navigatable, TestContext context, int startingElement) {
        Object previousSelection = context.getElement(startingElement);
        int expectedElement = startingElement + 1;
        while (expectedElement <= context.getNumberOfNodes()) {
            Object nextItem = navigatable.getNextItem(previousSelection);
            StringBuilder messageBuilder = new StringBuilder();
            messageBuilder.append("Error with configuration: Starting iteration point=").append(startingElement).append(", previous item=").append(previousSelection.toString());
            Assert.assertNotNull((String)messageBuilder.toString(), (Object)nextItem);
            Assert.assertEquals((String)messageBuilder.toString(), (long)expectedElement, (long)Integer.valueOf(nextItem.toString()).intValue());
            previousSelection = nextItem;
            ++expectedElement;
        }
        Assert.assertNull((Object)navigatable.getNextItem(previousSelection));
    }

    private void assertAllPreviousItems(TestContext.TestNavigatable navigatable, TestContext context) {
        int startingElement = 0;
        while (startingElement <= context.getNumberOfNodes()) {
            this.assertPreviousIterations(navigatable, context, startingElement);
            ++startingElement;
        }
    }

    private void assertPreviousIterationStartingOn(TestContext.TestNavigatable navigatable, TestContext context, int ... startingElements) {
        int[] nArray = startingElements;
        int n = startingElements.length;
        int n2 = 0;
        while (n2 < n) {
            int startingElement = nArray[n2];
            this.assertPreviousIterations(navigatable, context, startingElement);
            ++n2;
        }
    }

    private void assertPreviousIterations(TestContext.TestNavigatable navigatable, TestContext context, int startingElement) {
        Object previousSelection = context.getElement(startingElement);
        int expectedElement = startingElement - 1;
        while (expectedElement >= 0) {
            Object previousItem = navigatable.getPreviousItem(previousSelection);
            StringBuilder messageBuilder = new StringBuilder();
            messageBuilder.append("Error with configuration: Starting iteration point=").append(startingElement).append(", previsous item=").append(previousSelection.toString());
            Assert.assertNotNull((String)messageBuilder.toString(), (Object)previousItem);
            Assert.assertEquals((String)messageBuilder.toString(), (long)expectedElement, (long)Integer.valueOf(previousItem.toString()).intValue());
            previousSelection = previousItem;
            --expectedElement;
        }
        this.assertRoot(context, navigatable.getPreviousItem(previousSelection));
    }

    protected void assertRoot(TestContext context, Object object) {
        Assert.assertEquals((Object)context.getRoot(), (Object)object);
    }

    protected static String getTreeString(Tree aTree) {
        TreeItem[] children = aTree.getItems();
        StringBuilder treeString = new StringBuilder();
        TreeItem[] treeItemArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            NavigatableTest.appendChildrenInARow(item, treeString, 1);
            ++n2;
        }
        return treeString.toString();
    }

    private static void appendChildrenInARow(TreeItem item, StringBuilder builder, int tab) {
        builder.append(item.getText());
        TreeItem[] treeItemArray = item.getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem child = treeItemArray[n2];
            builder.append("\n").append(Strings.repeat((String)"\t", (int)tab)).append("\\__");
            NavigatableTest.appendChildrenInARow(child, builder, tab + 1);
            builder.append("\n");
            ++n2;
        }
    }
}

