/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.mapping.strategy.impl;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEClass;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEPackage;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedModel;
import org.eclipse.emf.teneo.extension.ExtensionManager;
import org.eclipse.emf.teneo.mapping.strategy.EntityNameStrategy;

public class QualifyingEntityNameStrategy
implements EntityNameStrategy {
    private static Log log = LogFactory.getLog(QualifyingEntityNameStrategy.class);
    private PAnnotatedModel paModel;
    public static final QualifyingEntityNameStrategy INSTANCE = new QualifyingEntityNameStrategy();
    private ExtensionManager extensionManager;

    public String toEntityName(EClass eClass) {
        if (eClass == null) {
            throw new IllegalArgumentException("EClass cannot be null.");
        }
        if (eClass == EOBJECT_ECLASS) {
            return EOBJECT_ECLASS_NAME;
        }
        String nsPrefix = eClass.getEPackage().getNsPrefix();
        if (nsPrefix == null) {
            nsPrefix = eClass.getEPackage().getName();
        }
        return String.valueOf(nsPrefix) + "." + eClass.getName();
    }

    public EClass toEClass(String eClassStr) {
        if (eClassStr == null) {
            throw new IllegalArgumentException("eClassStr may not be null");
        }
        if (eClassStr.compareTo(EOBJECT_ECLASS_NAME) == 0) {
            return EcorePackage.eINSTANCE.getEObject();
        }
        int index = eClassStr.lastIndexOf(".");
        if (index == -1) {
            throw new IllegalArgumentException("Illegal eClassStr for this resolver (no dot separating the epackage nsprefix and name): " + eClassStr);
        }
        String nsPrefix = eClassStr.substring(0, index);
        String eClassName = eClassStr.substring(index + 1);
        EClass eClass = null;
        for (PAnnotatedEPackage aPackage : this.getPaModel().getPaEPackages()) {
            EPackage ePackage = aPackage.getModelEPackage();
            if (ePackage.getNsPrefix().compareTo(nsPrefix) != 0 && ePackage.getName().compareTo(nsPrefix) != 0) continue;
            for (PAnnotatedEClass aClass : aPackage.getPaEClasses()) {
                EClass checkEClass = aClass.getModelEClass();
                if (checkEClass.getName().compareTo(eClassName) != 0) continue;
                if (eClass != null) {
                    throw new IllegalArgumentException("There is more than one EClass with the same identifying String (" + eClassStr + " in EPackage " + eClass.getEPackage().getName() + " and " + ePackage.getName() + ". A different EClassResolver should be used.");
                }
                eClass = checkEClass;
            }
        }
        if (eClass == null) {
            log.debug((Object)("Failed to retreive EClass for name: " + eClassName + ". This is no problem if this is a featuremap."));
            return null;
        }
        return eClass;
    }

    public PAnnotatedModel getPaModel() {
        return this.paModel;
    }

    public void setPaModel(PAnnotatedModel paModel) {
        this.paModel = paModel;
    }

    public void setExtensionManager(ExtensionManager extensionManager) {
        this.extensionManager = extensionManager;
    }

    public ExtensionManager getExtensionManager() {
        return this.extensionManager;
    }
}

