/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.annotations.pannotation;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum OptimizerType implements Enumerator
{
    NONE(1, "NONE", "NONE"),
    HILO(2, "HILO", "HILO"),
    POOLED(3, "POOLED", "POOLED"),
    POOLED_LO(4, "POOLED_LO", "POOLED-LO"),
    DEFAULT(0, "DEFAULT", "DEFAULT");

    public static final int NONE_VALUE = 1;
    public static final int HILO_VALUE = 2;
    public static final int POOLED_VALUE = 3;
    public static final int POOLED_LO_VALUE = 4;
    public static final int DEFAULT_VALUE = 0;
    private static final OptimizerType[] VALUES_ARRAY;
    public static final List<OptimizerType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new OptimizerType[]{NONE, HILO, POOLED, POOLED_LO, DEFAULT};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static OptimizerType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            OptimizerType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static OptimizerType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            OptimizerType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static OptimizerType get(int value) {
        switch (value) {
            case 1: {
                return NONE;
            }
            case 2: {
                return HILO;
            }
            case 3: {
                return POOLED;
            }
            case 4: {
                return POOLED_LO;
            }
            case 0: {
                return DEFAULT;
            }
        }
        return null;
    }

    private OptimizerType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

