/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.hibernate.mapper;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEAttribute;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEClass;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEStructuralFeature;
import org.eclipse.emf.teneo.annotations.pannotation.Id;
import org.eclipse.emf.teneo.annotations.pannotation.Transient;
import org.eclipse.emf.teneo.hibernate.hbmodel.HbAnnotatedEAttribute;
import org.eclipse.emf.teneo.hibernate.mapper.AbstractMapper;
import org.eclipse.emf.teneo.hibernate.mapper.FeatureMapper;
import org.eclipse.emf.teneo.hibernate.mapper.MappingContext;
import org.eclipse.emf.teneo.mapping.strategy.EntityNameStrategy;
import org.eclipse.emf.teneo.simpledom.Element;
import org.eclipse.emf.teneo.util.StoreUtil;

public class FeatureMapMapping
extends AbstractMapper {
    private static final Log log = LogFactory.getLog(FeatureMapMapping.class);
    private final PAnnotatedEAttribute paAttribute;
    private final MappingContext hbmContext;
    private Element compositeElement;

    public FeatureMapMapping(MappingContext hbmContext, PAnnotatedEAttribute paAttribute) {
        super.setHbmContext(hbmContext);
        log.debug((Object)("Created featuremap mapping instance for " + paAttribute));
        this.hbmContext = hbmContext;
        this.paAttribute = paAttribute;
        EAttribute eattr = paAttribute.getModelEAttribute();
        assert (FeatureMapUtil.isFeatureMap((EStructuralFeature)eattr));
    }

    public String getEntityName() {
        return StoreUtil.getEntityName((EntityNameStrategy)this.hbmContext.getEntityNameStrategy(), (EStructuralFeature)this.paAttribute.getModelEAttribute());
    }

    public void process() {
        Element mainElement;
        String entityName = StoreUtil.getEntityName((EntityNameStrategy)this.hbmContext.getEntityNameStrategy(), (EStructuralFeature)this.paAttribute.getModelEAttribute());
        log.debug((Object)("Processing feature map feature: " + entityName));
        if (this.getHbmContext().getPersistenceOptions().isMapFeatureMapAsComponent()) {
            mainElement = this.getCompositeElement();
            mainElement.addElement("meta").addAttribute("attribute", "featureMap").addAttribute("inherit", "false").addText(this.hbmContext.getEntityNameStrategy().toEntityName(this.paAttribute.getModelEAttribute().getEContainingClass()));
        } else {
            mainElement = this.hbmContext.getCurrent().addElement("class").addAttribute("entity-name", entityName).addAttribute("lazy", "false").addAttribute("table", this.hbmContext.trunc(null, entityName.toUpperCase(), false));
            mainElement.addElement("meta").addAttribute("attribute", "featureMap").addAttribute("inherit", "false").addText(this.hbmContext.getEntityNameStrategy().toEntityName(this.paAttribute.getModelEAttribute().getEContainingClass()));
            mainElement.addElement("id").addAttribute("column", "id").addAttribute("type", "long").addElement("generator").addAttribute("class", "native");
            if (this.hbmContext.alwaysVersion()) {
                Element versionElement = mainElement.addElement("version").addAttribute("name", this.hbmContext.getVersionColumnName()).addAttribute("access", "org.eclipse.emf.teneo.hibernate.mapping.property.VersionPropertyHandler");
                Element meta = new Element("meta");
                meta.addAttribute("attribute", "syntheticVersion").addText("true");
                meta.addAttribute("inherit", "false");
                versionElement.add(0, meta);
            }
        }
        FeatureMapper fp = this.hbmContext.getFeatureMapper();
        this.hbmContext.setCurrent(mainElement);
        this.hbmContext.setCurrentElementFeatureMap(true);
        if (this.getHbmContext().getPersistenceOptions().isMapFeatureMapAsComponent()) {
            mainElement.addElement("tuplizer").addAttribute("entity-mode", "pojo").addAttribute("class", this.getHbmContext().getComponentFeatureMapTuplizer());
            mainElement.addElement("tuplizer").addAttribute("entity-mode", "dynamic-map").addAttribute("class", this.getHbmContext().getComponentFeatureMapTuplizer());
        }
        mainElement.addElement("property").addAttribute("name", "fme_feature").addAttribute("type", "java.lang.String");
        PAnnotatedEClass paClass = this.paAttribute.getPaEClass();
        boolean isWildCard = StoreUtil.isWildCard((EStructuralFeature)this.paAttribute.getModelEAttribute());
        boolean isMixed = StoreUtil.isMixed((EStructuralFeature)this.paAttribute.getModelEAttribute());
        if (isWildCard) {
            this.addWildCardFeatureMapping(mainElement, (PAnnotatedEStructuralFeature)this.paAttribute);
        } else {
            this.hbmContext.setNamePrefix(String.valueOf(this.paAttribute.getModelEAttribute().getName()) + "_");
            for (PAnnotatedEStructuralFeature paFeature : paClass.getPaEStructuralFeatures()) {
                EStructuralFeature eFeature = paFeature.getModelEStructuralFeature();
                EStructuralFeature modelGroupFeature = ExtendedMetaData.INSTANCE.getGroup(eFeature);
                boolean isEFeatureMixed = StoreUtil.isMixed((EStructuralFeature)eFeature);
                if ((!isMixed || isEFeatureMixed) && (modelGroupFeature == null || modelGroupFeature != this.paAttribute.getModelEStructuralFeature())) continue;
                log.debug((Object)("Feature " + StoreUtil.toString((EStructuralFeature)eFeature) + " belongs to this featuremap"));
                Id id = null;
                if (paFeature instanceof PAnnotatedEAttribute && ((PAnnotatedEAttribute)paFeature).getId() != null) {
                    id = ((PAnnotatedEAttribute)paFeature).getId();
                    ((PAnnotatedEAttribute)paFeature).setId(null);
                }
                Transient tt = paFeature.getTransient();
                paFeature.setTransient(null);
                try {
                    fp.process(paFeature);
                }
                finally {
                    paFeature.setTransient(tt);
                    if (id != null) {
                        ((PAnnotatedEAttribute)paFeature).setId(id);
                    }
                }
            }
            this.hbmContext.setNamePrefix("");
        }
        if (StoreUtil.isMixed((EStructuralFeature)this.paAttribute.getModelEAttribute())) {
            mainElement.addElement("property").addAttribute("name", "fme_mixed_text").addAttribute("type", "java.lang.String");
            mainElement.addElement("property").addAttribute("name", "fme_mixed_cdata").addAttribute("type", "java.lang.String");
            mainElement.addElement("property").addAttribute("name", "fme_mixed_comment").addAttribute("type", "java.lang.String");
        }
        this.hbmContext.setCurrent(mainElement.getParent());
        this.hbmContext.setCurrentElementFeatureMap(false);
        log.debug((Object)"Finished processing featuremap");
    }

    private void addWildCardFeatureMapping(Element mainElement, PAnnotatedEStructuralFeature paFeature) {
        mainElement.addElement("property").addAttribute("name", String.valueOf(paFeature.getModelEStructuralFeature().getName()) + "_" + "fme_any_data").addAttribute("type", "java.lang.String");
        HbAnnotatedEAttribute hbAttribute = (HbAnnotatedEAttribute)this.paAttribute;
        String assocName = this.getHbmContext().getPropertyName(paFeature.getModelEStructuralFeature());
        mainElement.addElement(this.createAny(String.valueOf(assocName) + "_" + "fme_any_reference", paFeature, hbAttribute.getAny(), hbAttribute.getAnyMetaDef(), false));
    }

    public EAttribute getEAttribute() {
        return this.paAttribute.getModelEAttribute();
    }

    public Element getCompositeElement() {
        return this.compositeElement;
    }

    public void setCompositeElement(Element compositeElement) {
        this.compositeElement = compositeElement;
    }
}

