/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.hibernate.auditing;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.emf.teneo.extension.ExtensionPoint;
import org.eclipse.emf.teneo.hibernate.HbUtil;
import org.eclipse.emf.teneo.hibernate.auditing.AuditDataStore;
import org.eclipse.emf.teneo.hibernate.auditing.AuditReference;
import org.eclipse.emf.teneo.hibernate.auditing.model.teneoauditing.TeneoAuditEntry;
import org.eclipse.emf.teneo.util.AssertUtil;
import org.eclipse.emf.teneo.util.StoreUtil;
import org.hibernate.Session;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.query.Query;

public class AuditVersionProvider
implements ExtensionPoint {
    private static final String URI_STR = "http://www.eclipse.org/teneo/auditing";
    private Session session;
    private AuditResource auditResource;
    private ResourceSet resourceSet;
    private AuditDataStore dataStore;
    private Map<String, EObject> auditEntryCache = new HashMap<String, EObject>();

    public static int getContainingFeatureId(EObject eObject, EObject container, EStructuralFeature eContainingFeature) {
        EReference eContainingReference;
        EReference eOpposite;
        if (eContainingFeature instanceof EReference && (eOpposite = (eContainingReference = (EReference)eContainingFeature).getEOpposite()) != null) {
            return eObject.eClass().getFeatureID((EStructuralFeature)eOpposite);
        }
        return -1 - container.eClass().getFeatureID(eContainingFeature);
    }

    public AuditVersionProvider() {
        this.auditResource = new AuditResource(URI.createURI((String)URI_STR));
        this.resourceSet = new ResourceSetImpl(){

            public void eNotify(Notification notification) {
            }

            public boolean eDeliver() {
                return false;
            }

            public Resource getResource(URI uri, boolean loadOnDemand) {
                return AuditVersionProvider.this.auditResource;
            }

            public EObject getEObject(URI uri, boolean loadOnDemand) {
                return AuditVersionProvider.this.auditResource.getEObject(uri.fragment());
            }

            public Resource createResource(URI uri, String contentType) {
                return AuditVersionProvider.this.auditResource;
            }

            public Resource createResource(URI uri) {
                return AuditVersionProvider.this.auditResource;
            }
        };
        this.resourceSet.getResources().add((Object)this.auditResource);
    }

    protected void checkState() {
        AssertUtil.assertTrue((String)"data store must be set", (this.dataStore != null ? 1 : 0) != 0);
    }

    public String getIdString(EObject entity) {
        EClass eClass = entity.eClass();
        String entityName = ((SharedSessionContractImplementor)this.getSession()).bestGuessEntityName((Object)entity);
        Serializable id = ((SharedSessionContractImplementor)this.getSession()).getEntityPersister(entityName, (Object)entity).getIdentifier((Object)entity, (SharedSessionContractImplementor)this.getSession());
        return this.getIdString(eClass, id);
    }

    public String getIdString(EClass eClass, Serializable id) {
        return this.dataStore.getAuditHandler().idToString(eClass, id);
    }

    public List<TeneoAuditEntry> getAllAuditEntries(EObject entity) {
        EClass eClass = entity.eClass();
        String entityName = ((SharedSessionContractImplementor)this.getSession()).bestGuessEntityName((Object)entity);
        Serializable id = ((SharedSessionContractImplementor)this.getSession()).getEntityPersister(entityName, (Object)entity).getIdentifier((Object)entity, (SharedSessionContractImplementor)this.getSession());
        return this.getAllAuditEntries(eClass, id);
    }

    public List<TeneoAuditEntry> getAllAuditEntries(EClass eClass, long timeStamp) {
        this.checkState();
        EClass auditingEClass = this.dataStore.getAuditHandler().getAuditingModelElement(eClass);
        String entityName = (String)auditingEClass.getEAnnotation("teneo.jpa").getDetails().get((Object)"teneo.entity.name");
        Query qry = this.getSession().createQuery("select e from " + entityName + " e where e.teneo_start<=:start and (e.teneo_end=" + -1L + " or e.teneo_end>=:end)");
        qry.setParameter("start", (Object)timeStamp);
        qry.setParameter("end", (Object)timeStamp);
        ArrayList<TeneoAuditEntry> result = new ArrayList<TeneoAuditEntry>();
        for (Object o : qry.list()) {
            result.add((TeneoAuditEntry)o);
        }
        return result;
    }

    public List<TeneoAuditEntry> getSpecificAuditEntries(EClass eClass, long commitTimeStamp) {
        this.checkState();
        EClass auditingEClass = this.dataStore.getAuditHandler().getAuditingModelElement(eClass);
        String entityName = (String)auditingEClass.getEAnnotation("teneo.jpa").getDetails().get((Object)"teneo.entity.name");
        Query qry = this.getSession().createQuery("select e from " + entityName + " e where e.teneo_start=:start");
        qry.setParameter("start", (Object)commitTimeStamp);
        ArrayList<TeneoAuditEntry> result = new ArrayList<TeneoAuditEntry>();
        for (Object o : qry.list()) {
            result.add((TeneoAuditEntry)o);
        }
        return result;
    }

    public List<TeneoAuditEntry> getAllAuditEntries(EClass eClass, Object id) {
        this.checkState();
        EClass auditingEClass = this.dataStore.getAuditHandler().getAuditingModelElement(eClass);
        String entityName = (String)auditingEClass.getEAnnotation("teneo.jpa").getDetails().get((Object)"teneo.entity.name");
        Query qry = this.getSession().createQuery("select e from " + entityName + " e where teneo_object_id=:objectId order by e.teneo_start");
        String idAsString = this.dataStore.getAuditHandler().idToString(eClass, id);
        qry.setParameter("objectId", (Object)idAsString);
        ArrayList<TeneoAuditEntry> result = new ArrayList<TeneoAuditEntry>();
        for (Object o : qry.list()) {
            result.add((TeneoAuditEntry)o);
        }
        return result;
    }

    public TeneoAuditEntry getLatestAuditEntry(EClass eClass, Object id) {
        this.checkState();
        EClass auditingEClass = this.dataStore.getAuditHandler().getAuditingModelElement(eClass);
        String entityName = (String)auditingEClass.getEAnnotation("teneo.jpa").getDetails().get((Object)"teneo.entity.name");
        Query qry = this.getSession().createQuery("select e from " + entityName + " e where teneo_object_id=:objectId and teneo_end=" + -1L);
        String idAsString = this.dataStore.getAuditHandler().idToString(eClass, id);
        qry.setParameter("objectId", (Object)idAsString);
        qry.setMaxResults(1);
        return (TeneoAuditEntry)qry.uniqueResult();
    }

    public TeneoAuditEntry getAuditEntryForVersion(EClass eClass, Object id, long version) {
        this.checkState();
        EClass auditingEClass = this.dataStore.getAuditHandler().getAuditingModelElement(eClass);
        String entityName = (String)auditingEClass.getEAnnotation("teneo.jpa").getDetails().get((Object)"teneo.entity.name");
        Query qry = this.getSession().createQuery("select e from " + entityName + " e where teneo_object_id=:objectId and teneo_object_version=:version");
        String idAsString = this.dataStore.getAuditHandler().idToString(eClass, id);
        qry.setParameter("objectId", (Object)idAsString);
        qry.setParameter("version", (Object)version);
        qry.setMaxResults(1);
        return (TeneoAuditEntry)qry.uniqueResult();
    }

    public <T extends EObject> T resolve(T proxy) {
        return (T)EcoreUtil.resolve(proxy, (Resource)this.auditResource);
    }

    public EObject getRevision(TeneoAuditEntry auditEntry) {
        EClass eClass = this.dataStore.getAuditHandler().getModelElement(auditEntry.eClass());
        long timeStamp = auditEntry.getTeneo_start();
        AuditReference auditReference = this.dataStore.getAuditHandler().fromString(String.valueOf(timeStamp) + ";" + auditEntry.getTeneo_object_id());
        return this.getRevision(eClass, auditReference.getId(), timeStamp);
    }

    public TeneoAuditEntry getPreviousEntry(TeneoAuditEntry entry) {
        if (entry.getTeneo_previous_start() < 0L) {
            return null;
        }
        Query qry = this.getSession().createQuery("select e from " + HbUtil.getEntityName(entry.eClass()) + " e where teneo_object_id=:objectId and teneo_start=:start");
        qry.setParameter("objectId", (Object)entry.getTeneo_object_id());
        qry.setParameter("start", (Object)entry.getTeneo_previous_start());
        qry.setMaxResults(1);
        return (TeneoAuditEntry)qry.uniqueResult();
    }

    public TeneoAuditEntry getNextEntry(TeneoAuditEntry entry) {
        if (entry.getTeneo_end() < 0L) {
            return null;
        }
        Query qry = this.getSession().createQuery("select e from " + HbUtil.getEntityName(entry.eClass()) + " e where teneo_object_id=:objectId and teneo_previous_start=:start");
        qry.setParameter("objectId", (Object)entry.getTeneo_object_id());
        qry.setParameter("start", (Object)entry.getTeneo_start());
        qry.setMaxResults(1);
        return (TeneoAuditEntry)qry.uniqueResult();
    }

    public TeneoAuditEntry getAuditEntry(EClass eClass, Object id, long timeStamp) {
        this.checkState();
        String idAsString = this.dataStore.getAuditHandler().idToString(eClass, id);
        EClass auditingEClass = this.dataStore.getAuditHandler().getAuditingModelElement(eClass);
        String entityName = (String)auditingEClass.getEAnnotation("teneo.jpa").getDetails().get((Object)"teneo.entity.name");
        Query qry = this.getSession().createQuery("select e from " + entityName + " e where teneo_object_id=:objectId and teneo_start<=:start and (teneo_end=" + -1L + " or teneo_end>=:end)");
        qry.setParameter("objectId", (Object)idAsString);
        qry.setParameter("start", (Object)timeStamp);
        qry.setParameter("end", (Object)timeStamp);
        TeneoAuditEntry auditEntry = (TeneoAuditEntry)qry.uniqueResult();
        return auditEntry;
    }

    public EObject getRevision(EClass eClass, Object id, long timeStamp) {
        InternalEObject container;
        this.checkState();
        String idAsString = this.dataStore.getAuditHandler().idToString(eClass, id);
        String fullId = String.valueOf(timeStamp) + ";" + idAsString;
        if (this.auditResource.getEObjectFromCache(fullId) != null) {
            return this.auditResource.getEObjectFromCache(fullId);
        }
        EClass auditingEClass = this.dataStore.getAuditHandler().getAuditingModelElement(eClass);
        TeneoAuditEntry auditEntry = this.getAuditEntry(eClass, id, timeStamp);
        if (auditEntry == null) {
            return null;
        }
        EObject target = this.auditEntryCache.get(String.valueOf(idAsString) + "_" + auditEntry.getTeneo_audit_id());
        if (target != null) {
            return target;
        }
        target = eClass.getEPackage().getEFactoryInstance().create(eClass);
        for (EStructuralFeature targetEFeature : target.eClass().getEAllStructuralFeatures()) {
            EStructuralFeature sourceEFeature = auditingEClass.getEStructuralFeature(targetEFeature.getName());
            if (sourceEFeature == null || !sourceEFeature.isMany() && !auditEntry.eIsSet(sourceEFeature)) continue;
            if (sourceEFeature instanceof EAttribute && targetEFeature instanceof EReference) {
                if (sourceEFeature.isMany()) {
                    for (Object value : (Collection)auditEntry.eGet(sourceEFeature)) {
                        ((Collection)target.eGet(targetEFeature)).add(this.createProxyEObject((String)value, timeStamp));
                    }
                    continue;
                }
                target.eSet(targetEFeature, (Object)this.createProxyEObject((String)auditEntry.eGet(sourceEFeature), timeStamp));
                continue;
            }
            if (StoreUtil.isMap((EStructuralFeature)targetEFeature)) {
                for (Object value : (Collection)auditEntry.eGet(sourceEFeature)) {
                    ((Collection)target.eGet(targetEFeature)).add(this.createEMapEntry((EReference)targetEFeature, (EObject)value, timeStamp));
                }
                continue;
            }
            if (FeatureMapUtil.isFeatureMap((EStructuralFeature)targetEFeature)) {
                for (Object value : (Collection)auditEntry.eGet(sourceEFeature)) {
                    FeatureMap.Entry sourceEntry = (FeatureMap.Entry)value;
                    EStructuralFeature targetEntryFeature = this.dataStore.getAuditHandler().getModelElement(sourceEntry.getEStructuralFeature());
                    FeatureMap.Entry targetEntry = this.createFeatureMapEntry(targetEntryFeature, sourceEntry, timeStamp);
                    ((Collection)target.eGet(targetEFeature)).add(targetEntry);
                }
                continue;
            }
            if (targetEFeature.isMany()) {
                Collection collection = (Collection)auditEntry.eGet(sourceEFeature);
                if (collection.size() <= 0) continue;
                for (Object value : collection) {
                    ((Collection)target.eGet(targetEFeature)).add(this.dataStore.getAuditHandler().convertValue(targetEFeature, value));
                }
                continue;
            }
            target.eSet(targetEFeature, this.dataStore.getAuditHandler().convertValue(targetEFeature, auditEntry.eGet(sourceEFeature)));
        }
        if ((auditEntry.getTeneo_container_feature_name() != null || auditEntry.getTeneo_container_id() != null) && (container = (InternalEObject)this.createProxyEObject(auditEntry.getTeneo_container_id(), timeStamp)) != null) {
            if (auditEntry.getTeneo_container_feature_name() != null) {
                EStructuralFeature eContainingFeature = container.eClass().getEStructuralFeature(auditEntry.getTeneo_container_feature_name());
                int containerFeatureId = AuditVersionProvider.getContainingFeatureId(target, (EObject)container, eContainingFeature);
                ((InternalEObject)target).eBasicSetContainer(container, containerFeatureId, null);
            } else {
                ((InternalEObject)target).eBasicSetContainer(container, auditEntry.getTeneo_container_feature_id(), null);
            }
        }
        if (target.eResource() == null) {
            ((InternalEObject)target).eSetResource((Resource.Internal)this.auditResource, null);
        }
        this.auditResource.putEObjectInCache(fullId, target);
        this.auditEntryCache.put(String.valueOf(idAsString) + "_" + auditEntry.getTeneo_audit_id(), target);
        return target;
    }

    private Object createEMapEntry(EReference targetEFeature, EObject sourceEntry, long timeStamp) {
        EObject targetEntry = EcoreUtil.create((EClass)targetEFeature.getEReferenceType());
        Object value = sourceEntry.eGet(sourceEntry.eClass().getEStructuralFeature("value"));
        Object key = sourceEntry.eGet(sourceEntry.eClass().getEStructuralFeature("key"));
        EStructuralFeature keyEFeature = targetEntry.eClass().getEStructuralFeature("key");
        EStructuralFeature valueEFeature = targetEntry.eClass().getEStructuralFeature("value");
        Object newKey = keyEFeature instanceof EAttribute ? this.dataStore.getAuditHandler().convertValue(keyEFeature, key) : (key instanceof EObject ? key : this.createProxyEObject((String)key, timeStamp));
        targetEntry.eSet(keyEFeature, newKey);
        Object newValue = valueEFeature instanceof EAttribute ? this.dataStore.getAuditHandler().convertValue(valueEFeature, value) : (value instanceof EObject ? value : this.createProxyEObject((String)value, timeStamp));
        targetEntry.eSet(valueEFeature, newValue);
        return targetEntry;
    }

    private FeatureMap.Entry createFeatureMapEntry(EStructuralFeature eFeature, FeatureMap.Entry sourceEntry, long timeStamp) {
        Object value = sourceEntry.getValue();
        if (eFeature instanceof EReference) {
            value = this.createProxyEObject((String)value, timeStamp);
        }
        return FeatureMapUtil.createEntry((EStructuralFeature)eFeature, (Object)value);
    }

    protected EObject createProxyEObject(String value, long timeStamp) {
        if (value == null) {
            return null;
        }
        String idStr = String.valueOf(timeStamp) + ";" + value;
        EObject eObject = this.auditResource.getEObjectFromCache(idStr);
        if (eObject != null) {
            return eObject;
        }
        AuditReference reference = this.dataStore.getAuditHandler().fromString(idStr);
        EClass refEClass = this.dataStore.toEClass(reference.getEntityName());
        eObject = refEClass.getEPackage().getEFactoryInstance().create(refEClass);
        ((InternalEObject)eObject).eSetProxyURI(URI.createURI((String)("http://www.eclipse.org/teneo/auditing#" + idStr)));
        ((InternalEObject)eObject).eSetResource((Resource.Internal)this.auditResource, null);
        return eObject;
    }

    protected Session getSession() {
        if (this.session == null) {
            this.session = ((SessionFactoryImplementor)this.dataStore.getSessionFactory()).openTemporarySession();
        }
        return this.session;
    }

    public AuditDataStore getDataStore() {
        return this.dataStore;
    }

    public void setDataStore(AuditDataStore dataStore) {
        this.dataStore = dataStore;
    }

    public void setSession(Session session) {
        this.session = session;
    }

    public void close() {
        if (this.session != null) {
            this.session.close();
        }
    }

    private class AuditResource
    extends ResourceImpl {
        private Map<String, EObject> idToEObjectMap;

        public AuditResource(URI uri) {
            super(uri);
            this.idToEObjectMap = new HashMap<String, EObject>();
        }

        public EObject getEObjectFromCache(String idStr) {
            return this.idToEObjectMap.get(idStr);
        }

        public void putEObjectInCache(String idStr, EObject eObject) {
            this.idToEObjectMap.put(idStr, eObject);
        }

        public EObject getEObject(String uriFragment) {
            if (this.idToEObjectMap.containsKey(uriFragment)) {
                return this.idToEObjectMap.get(uriFragment);
            }
            AuditReference reference = AuditVersionProvider.this.dataStore.getAuditHandler().fromString(uriFragment);
            EClass eClass = AuditVersionProvider.this.dataStore.toEClass(reference.getEntityName());
            EObject version = AuditVersionProvider.this.getRevision(eClass, reference.getId(), reference.getTimeStamp());
            if (version == null) {
                version = (EObject)AuditVersionProvider.this.getSession().get(reference.getEntityName(), reference.getId());
            }
            if (version.eResource() == null) {
                ((InternalEObject)version).eSetResource((Resource.Internal)this, null);
            }
            if (version != null) {
                this.idToEObjectMap.put(uriFragment, version);
            }
            return version;
        }
    }
}

