/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.hibernate.mapping.elist;

import java.lang.reflect.Field;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.common.util.BasicEMap;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.teneo.extension.ExtensionPoint;
import org.eclipse.emf.teneo.hibernate.SessionWrapper;
import org.eclipse.emf.teneo.hibernate.mapping.elist.HibernatePersistableEList;
import org.eclipse.emf.teneo.hibernate.resource.HbResource;
import org.eclipse.emf.teneo.mapping.elist.PersistableDelegateList;
import org.eclipse.emf.teneo.mapping.elist.PersistableEList;
import org.eclipse.emf.teneo.mapping.elist.PersistableEMap;
import org.eclipse.emf.teneo.resource.StoreResource;
import org.hibernate.Session;
import org.hibernate.collection.AbstractPersistentCollection;
import org.hibernate.collection.PersistentCollection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernatePersistableEMap<K, V>
extends PersistableEMap<K, V>
implements ExtensionPoint {
    private static final long serialVersionUID = -4553160393592497834L;
    private static Log log = LogFactory.getLog(HibernatePersistableEMap.class);

    public HibernatePersistableEMap(InternalEObject owner, EReference eref, List<BasicEMap.Entry<K, V>> list) {
        super(eref.getEReferenceType(), owner, (EStructuralFeature)eref, list);
    }

    protected void doLoad() {
        SessionWrapper sessionWrapper = null;
        boolean controlsTransaction = false;
        boolean err = true;
        Resource res = null;
        List delegate = ((HibernatePersistableEList)this.delegateEList).getDelegate();
        try {
            res = this.getEObject().eResource();
            if (res != null && res instanceof HbResource) {
                sessionWrapper = ((HbResource)res).getSessionWrapper();
                if (res.isLoaded()) {
                    boolean isDelegateLoaded;
                    boolean bl = isDelegateLoaded = delegate instanceof AbstractPersistentCollection && ((AbstractPersistentCollection)delegate).wasInitialized();
                    if (!isDelegateLoaded && !sessionWrapper.isTransactionActive()) {
                        log.debug((Object)("Reconnecting session to read a lazy collection, elist: " + this.logString));
                        controlsTransaction = true;
                        sessionWrapper.beginTransaction();
                        sessionWrapper.setFlushModeManual();
                    } else {
                        log.debug((Object)"Delegate loaded or resource session is still active, using it");
                    }
                } else {
                    log.debug((Object)("EMap uses session from resource, " + this.logString));
                }
            } else {
                log.debug((Object)"EMap is not loaded in session context");
            }
            if (controlsTransaction) {
                assert (res instanceof HbResource);
                ((StoreResource)res).setIsLoading(true);
            }
            try {
                Object[] objs = delegate.toArray();
                if (res != null && res instanceof StoreResource) {
                    Object[] objectArray = objs;
                    int n = objs.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object element = objectArray[n2];
                        if (element instanceof EObject) {
                            ((StoreResource)res).addToContentOrAttach((InternalEObject)element, (EReference)this.getEStructuralFeature());
                        }
                        ++n2;
                    }
                }
                log.debug((Object)("Loaded " + objs.length + " from backend store for " + this.logString));
            }
            finally {
                if (controlsTransaction) {
                    ((StoreResource)res).setIsLoading(false);
                }
            }
            err = false;
        }
        finally {
            if (controlsTransaction) {
                if (err) {
                    sessionWrapper.rollbackTransaction();
                    sessionWrapper.restorePreviousFlushMode();
                } else {
                    sessionWrapper.commitTransaction();
                    sessionWrapper.restorePreviousFlushMode();
                }
                ((HbResource)res).returnSessionWrapper(sessionWrapper);
            }
        }
        log.debug((Object)("Finished loading elist " + this.logString));
    }

    public int size() {
        if (this.size != 0) {
            return this.size;
        }
        if (this.delegateEList instanceof PersistableEList && ((PersistableEList)this.delegateEList).getDelegate() instanceof AbstractPersistentCollection) {
            try {
                Field field = AbstractPersistentCollection.class.getDeclaredField("session");
                field.setAccessible(true);
                Session s = (Session)field.get(((PersistableEList)this.delegateEList).getDelegate());
                s.flush();
                this.size = ((Long)s.createFilter((Object)((PersistableEList)this.delegateEList).getDelegate(), "select count(*)").list().get(0)).intValue();
                return this.size;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return super.size();
    }

    protected EList<BasicEMap.Entry<K, V>> createDelegateEList(InternalEObject owner, EStructuralFeature feature, List<BasicEMap.Entry<K, V>> delegateORMList) {
        return new HibernatePersistableEList<BasicEMap.Entry<K, V>>(owner, feature, delegateORMList){
            private static final long serialVersionUID = 1L;

            protected void didAdd(int index, BasicEMap.Entry<K, V> newObject) {
                HibernatePersistableEMap.this.doPut(newObject);
            }

            protected void didSet(int index, BasicEMap.Entry<K, V> newObject, BasicEMap.Entry<K, V> oldObject) {
                this.didRemove(index, oldObject);
                this.didAdd(index, newObject);
            }

            protected void didRemove(int index, BasicEMap.Entry<K, V> oldObject) {
                HibernatePersistableEMap.this.doRemove(oldObject);
            }

            protected void didClear(int size, Object[] oldObjects) {
                this.doClear();
            }

            protected void didMove(int index, BasicEMap.Entry<K, V> movedObject, int oldIndex) {
                HibernatePersistableEMap.this.doMove(movedObject);
            }
        };
    }

    public boolean isInitialized() {
        return ((PersistentCollection)this.getDelegate()).wasInitialized();
    }

    public Object getDelegate() {
        return ((PersistableDelegateList)this.delegateEList).getDelegate();
    }
}

