/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.db;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.model.CDOFeature;
import org.eclipse.emf.cdo.server.db.IAttributeMapping;
import org.eclipse.emf.cdo.server.internal.db.ClassMapping;
import org.eclipse.emf.cdo.server.internal.db.FeatureMapping;
import org.eclipse.emf.cdo.spi.common.InternalCDORevision;
import org.eclipse.net4j.db.DBException;
import org.eclipse.net4j.db.IDBAdapter;
import org.eclipse.net4j.db.ddl.IDBField;

public abstract class AttributeMapping
extends FeatureMapping
implements IAttributeMapping {
    private IDBField field;

    public AttributeMapping(ClassMapping classMapping, CDOFeature feature) {
        super(classMapping, feature);
        this.field = classMapping.addField(feature, classMapping.getTable());
    }

    public IDBField getField() {
        return this.field;
    }

    public void appendValue(StringBuilder builder, InternalCDORevision revision) {
        IDBAdapter dbAdapter = this.getDBAdapter();
        Object value = this.getRevisionValue(revision);
        dbAdapter.appendValue(builder, this.field, value);
    }

    protected Object getRevisionValue(InternalCDORevision revision) {
        CDOFeature feature = this.getFeature();
        return revision.getValue(feature);
    }

    public void extractValue(ResultSet resultSet, int column, InternalCDORevision revision) {
        try {
            Object value = this.getResultSetValue(resultSet, column);
            if (resultSet.wasNull()) {
                value = null;
            }
            revision.setValue(this.getFeature(), value);
        }
        catch (SQLException ex) {
            throw new DBException((Throwable)ex);
        }
    }

    protected abstract Object getResultSetValue(ResultSet var1, int var2) throws SQLException;

    public static class AMBoolean
    extends AttributeMapping {
        public AMBoolean(ClassMapping classMapping, CDOFeature feature) {
            super(classMapping, feature);
        }

        protected Object getResultSetValue(ResultSet resultSet, int column) throws SQLException {
            return resultSet.getBoolean(column);
        }
    }

    public static class AMByte
    extends AttributeMapping {
        public AMByte(ClassMapping classMapping, CDOFeature feature) {
            super(classMapping, feature);
        }

        protected Object getResultSetValue(ResultSet resultSet, int column) throws SQLException {
            return resultSet.getByte(column);
        }
    }

    public static class AMCharacter
    extends AttributeMapping {
        public AMCharacter(ClassMapping classMapping, CDOFeature feature) {
            super(classMapping, feature);
        }

        protected Object getResultSetValue(ResultSet resultSet, int column) throws SQLException {
            String str = resultSet.getString(column);
            if (resultSet.wasNull()) {
                return null;
            }
            return Character.valueOf(str.charAt(0));
        }
    }

    public static class AMDate
    extends AttributeMapping {
        public AMDate(ClassMapping classMapping, CDOFeature feature) {
            super(classMapping, feature);
        }

        protected Object getResultSetValue(ResultSet resultSet, int column) throws SQLException {
            return resultSet.getDate(column);
        }
    }

    public static class AMDouble
    extends AttributeMapping {
        public AMDouble(ClassMapping classMapping, CDOFeature feature) {
            super(classMapping, feature);
        }

        protected Object getResultSetValue(ResultSet resultSet, int column) throws SQLException {
            return resultSet.getDouble(column);
        }
    }

    public static class AMFloat
    extends AttributeMapping {
        public AMFloat(ClassMapping classMapping, CDOFeature feature) {
            super(classMapping, feature);
        }

        protected Object getResultSetValue(ResultSet resultSet, int column) throws SQLException {
            return Float.valueOf(resultSet.getFloat(column));
        }
    }

    public static class AMInteger
    extends AttributeMapping {
        public AMInteger(ClassMapping classMapping, CDOFeature feature) {
            super(classMapping, feature);
        }

        protected Object getResultSetValue(ResultSet resultSet, int column) throws SQLException {
            return resultSet.getInt(column);
        }
    }

    public static class AMLong
    extends AttributeMapping {
        public AMLong(ClassMapping classMapping, CDOFeature feature) {
            super(classMapping, feature);
        }

        protected Object getResultSetValue(ResultSet resultSet, int column) throws SQLException {
            return resultSet.getLong(column);
        }
    }

    public static class AMObject
    extends AttributeMapping {
        public AMObject(ClassMapping classMapping, CDOFeature feature) {
            super(classMapping, feature);
        }

        protected Object getResultSetValue(ResultSet resultSet, int column) throws SQLException {
            long id = resultSet.getLong(column);
            if (resultSet.wasNull()) {
                return null;
            }
            return CDOIDUtil.createLong((long)id);
        }
    }

    public static class AMShort
    extends AttributeMapping {
        public AMShort(ClassMapping classMapping, CDOFeature feature) {
            super(classMapping, feature);
        }

        protected Object getResultSetValue(ResultSet resultSet, int column) throws SQLException {
            return resultSet.getShort(column);
        }
    }

    public static class AMString
    extends AttributeMapping {
        public AMString(ClassMapping classMapping, CDOFeature feature) {
            super(classMapping, feature);
        }

        protected Object getResultSetValue(ResultSet resultSet, int column) throws SQLException {
            return resultSet.getString(column);
        }
    }
}

