/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.server.protocol;

import java.io.IOException;
import org.eclipse.emf.cdo.common.model.CDOModelUtil;
import org.eclipse.emf.cdo.common.model.CDOPackage;
import org.eclipse.emf.cdo.internal.server.bundle.OM;
import org.eclipse.emf.cdo.internal.server.protocol.CDOReadIndication;
import org.eclipse.net4j.util.ImplementationError;
import org.eclipse.net4j.util.io.ExtendedDataInputStream;
import org.eclipse.net4j.util.io.ExtendedDataOutput;
import org.eclipse.net4j.util.io.ExtendedDataOutputStream;
import org.eclipse.net4j.util.om.trace.ContextTracer;

public class LoadPackageIndication
extends CDOReadIndication {
    private static final ContextTracer PROTOCOL = new ContextTracer(OM.DEBUG_PROTOCOL, LoadPackageIndication.class);
    private CDOPackage cdoPackage;

    protected short getSignalID() {
        return 6;
    }

    protected void indicating(ExtendedDataInputStream in) throws IOException {
        String packageURI = in.readString();
        if (PROTOCOL.isEnabled()) {
            PROTOCOL.format("Read packageURI: {0}", new Object[]{packageURI});
        }
        this.cdoPackage = this.getPackageManager().lookupPackage(packageURI);
        if (this.cdoPackage == null) {
            throw new ImplementationError("CDO package not found: " + packageURI);
        }
    }

    protected void responding(ExtendedDataOutputStream out) throws IOException {
        if (PROTOCOL.isEnabled()) {
            PROTOCOL.format("Writing package: {0}", new Object[]{this.cdoPackage});
        }
        CDOModelUtil.writePackage((ExtendedDataOutput)out, (CDOPackage)this.cdoPackage);
    }
}

