/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.ui;

import java.util.Set;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.internal.cdo.util.FSMUtil;
import org.eclipse.emf.spi.cdo.InternalCDOObject;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.TreeItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ItemsProcessor {
    private CDOView view;

    public ItemsProcessor(CDOView view) {
        this.view = view;
    }

    public CDOView getView() {
        return this.view;
    }

    public void processCDOObjects(TreeViewer viewer) {
        this.processCDOObjects(viewer, null);
    }

    public void processCDOObjects(final TreeViewer viewer, final Set<? extends CDOObject> ids) {
        try {
            viewer.getControl().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    try {
                        ItemsProcessor.this.processObject(viewer, ids, viewer.getInput());
                        ItemsProcessor.this.processItems(viewer, ids, viewer.getTree().getItems());
                    }
                    catch (Exception exception) {}
                }
            });
        }
        catch (Exception exception) {}
    }

    protected InternalCDOObject getCDOObject(Object object) {
        if (object instanceof InternalCDOObject) {
            return (InternalCDOObject)object;
        }
        if (object != null && this.view != null) {
            return FSMUtil.adapt((Object)object, (CDOView)this.view);
        }
        return null;
    }

    protected abstract void processCDOObject(TreeViewer var1, InternalCDOObject var2);

    private void processItems(TreeViewer viewer, Set<? extends CDOObject> ids, TreeItem[] items) {
        TreeItem[] treeItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            Object object = item.getData();
            this.processObject(viewer, ids, object);
            if (item.getItemCount() != 0) {
                this.processItems(viewer, ids, item.getItems());
            }
            ++n2;
        }
    }

    private void processObject(TreeViewer viewer, Set<? extends CDOObject> ids, Object object) {
        InternalCDOObject cdoObject = this.getCDOObject(object);
        if (ids.contains(cdoObject)) {
            this.processCDOObject(viewer, cdoObject);
        }
    }
}

