/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo;

import java.util.List;
import org.eclipse.emf.cdo.CDOView;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.CDOAware;
import org.eclipse.emf.ecore.impl.CDOCallback;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.internal.cdo.CDOLegacyImpl;
import org.eclipse.emf.internal.cdo.CDOStateMachine;
import org.eclipse.emf.internal.cdo.InternalCDOObject;
import org.eclipse.emf.internal.cdo.bundle.OM;
import org.eclipse.emf.internal.cdo.util.FSMUtil;

public class CDOCallbackImpl
extends CDOLegacyImpl
implements CDOCallback {
    public CDOCallbackImpl(InternalEObject instance) {
        this.instance = instance;
    }

    public void beforeRead(EObjectImpl instance) {
        CDOStateMachine.INSTANCE.read(this);
    }

    public void beforeWrite(EObjectImpl instance) {
        CDOStateMachine.INSTANCE.write(this);
    }

    public boolean isAdapterForType(Object type) {
        return type == CDOCallbackImpl.class;
    }

    public void notifyChanged(Notification msg) {
        try {
            EReference reference;
            Object feature;
            if (msg.getNotifier() == this.instance && (feature = msg.getFeature()) instanceof EReference && (reference = (EReference)feature).isContainment() && !reference.isTransient()) {
                switch (msg.getEventType()) {
                    case 3: {
                        this.notifyAdd(msg.getNewValue());
                        break;
                    }
                    case 5: {
                        this.notifyAddMany(msg);
                        break;
                    }
                    case 4: {
                        this.notifyRemove(msg.getOldValue());
                        break;
                    }
                    case 6: {
                        this.notifyRemoveMany(msg);
                    }
                    default: {
                        break;
                    }
                }
            }
        }
        catch (RuntimeException ex) {
            OM.LOG.error((Throwable)ex);
        }
    }

    protected void adjustEProxy() {
    }

    private void notifyAddMany(Notification msg) {
        List newValues = (List)msg.getNewValue();
        List oldValues = (List)msg.getOldValue();
        for (Object newValue : newValues) {
            if (oldValues.contains(newValue)) continue;
            this.notifyAdd(newValue);
        }
    }

    private void notifyAdd(Object instance) {
        if (instance instanceof InternalEObject && ((InternalEObject)instance).eDeliver()) {
            InternalCDOObject object = FSMUtil.adapt(instance, this.view);
            CDOStateMachine.INSTANCE.attach(object, this.cdoResource(), this.view);
        }
    }

    private void notifyRemoveMany(Notification msg) {
        List newValues = (List)msg.getNewValue();
        List oldValues = (List)msg.getOldValue();
        for (Object oldValue : oldValues) {
            if (newValues.contains(oldValue)) continue;
            this.notifyRemove(oldValue);
        }
    }

    private void notifyRemove(Object instance) {
        if (instance instanceof InternalEObject && ((InternalEObject)instance).eDeliver()) {
            InternalCDOObject object = FSMUtil.adapt(instance, this.view);
            CDOStateMachine.INSTANCE.detach(object);
        }
    }

    public static InternalCDOObject adapt(Object object, CDOView view) throws Throwable {
        if (object instanceof CDOAware) {
            CDOAware aware = (CDOAware)object;
            CDOCallbackImpl callback = (CDOCallbackImpl)aware.getCDOCallback();
            if (callback == null) {
                InternalEObject instance = (InternalEObject)aware;
                if (instance.eIsProxy()) {
                    instance = (InternalEObject)EcoreUtil.resolve((EObject)instance, (ResourceSet)view.getResourceSet());
                }
                callback = new CDOCallbackImpl(instance);
                aware.setCDOCallback((CDOCallback)callback);
                instance.eAdapters().add((Object)callback);
            }
            return callback;
        }
        return null;
    }
}

