/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.validation.examples.ocl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.model.ConstraintSeverity;
import org.eclipse.emf.validation.model.EvaluationMode;
import org.eclipse.emf.validation.service.AbstractConstraintDescriptor;
import org.eclipse.ocl.ecore.Constraint;

class OCLConstraintDescriptor
extends AbstractConstraintDescriptor {
    private final Constraint constraint;
    private final String id;
    private final String name;
    private final String namespace;
    private final int code;

    public OCLConstraintDescriptor(String namespace, Constraint constraint, int code) {
        this.constraint = constraint;
        String name = constraint.getName();
        if (name == null) {
            name = Long.toHexString(System.identityHashCode(constraint));
        }
        this.id = String.valueOf(namespace) + '.' + name;
        this.name = name;
        this.namespace = namespace;
        this.code = code;
    }

    final Constraint getConstraint() {
        return this.constraint;
    }

    public String getBody() {
        return this.constraint.getSpecification().getBodyExpression().toString();
    }

    public String getDescription() {
        return this.getBody();
    }

    public EvaluationMode<?> getEvaluationMode() {
        return EvaluationMode.BATCH;
    }

    public String getId() {
        return this.id;
    }

    public String getMessagePattern() {
        return String.format("Constraint %s violated on {0}", this.getName());
    }

    public String getName() {
        return this.name;
    }

    public String getPluginId() {
        return this.namespace;
    }

    public ConstraintSeverity getSeverity() {
        return ConstraintSeverity.WARNING;
    }

    public int getStatusCode() {
        return this.code;
    }

    public boolean targetsEvent(Notification notification) {
        return false;
    }

    public boolean targetsTypeOf(EObject eObject) {
        return ((EClassifier)this.constraint.getSpecification().getContextVariable().getType()).isInstance((Object)eObject);
    }
}

