/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.eef.runtime.ui.widgets.masterdetails.tree;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.eef.runtime.EEFRuntimePlugin;
import org.eclipse.emf.eef.runtime.impl.utils.EEFCommandParameter;
import org.eclipse.emf.eef.runtime.ui.layout.EEFFormLayoutFactory;
import org.eclipse.emf.eef.runtime.ui.notify.DropDownSelectionListener;
import org.eclipse.emf.eef.runtime.ui.widgets.masterdetails.AbstractEEFMasterDetailsBlock;
import org.eclipse.emf.eef.runtime.ui.widgets.masterdetails.AbstractEEFMasterPart;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.forms.widgets.FormToolkit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EEFTreeMasterPart
extends AbstractEEFMasterPart {
    private List<EEFCommandParameter> commandParameters;
    private EObject modelRoot;
    private EditingDomain editingDomain;
    private Composite modelToolBar;
    private boolean showModelToolBar = true;

    public EEFTreeMasterPart(FormToolkit toolkit, Composite container, AbstractEEFMasterDetailsBlock block) {
        super(toolkit, container, block);
    }

    protected TreeViewer createSectionClientContents(Composite sectionContainer, FormToolkit toolkit) {
        Tree tree = toolkit.createTree(sectionContainer, 2050);
        TreeViewer result = new TreeViewer(tree);
        result.setContentProvider((IContentProvider)new AdapterFactoryContentProvider(this.getAdapterFactory()));
        result.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider(this.getAdapterFactory()));
        GridData gd = new GridData(1808);
        tree.setLayoutData((Object)gd);
        return result;
    }

    public List<EEFCommandParameter> getCommandParameter() {
        if (this.commandParameters == null) {
            this.createCommandParameters();
        }
        return this.commandParameters;
    }

    private void createCommandParameters() {
        if (this.modelRoot == null) {
            this.commandParameters = new ArrayList<EEFCommandParameter>();
        } else {
            ViewerFilter[] filters = this.getModelViewer().getFilters();
            this.commandParameters = new ArrayList<EEFCommandParameter>();
            for (EReference reference : this.modelRoot.eClass().getEAllReferences()) {
                if (!reference.isContainment()) continue;
                if (filters.length > 0) {
                    ViewerFilter[] viewerFilterArray = filters;
                    int n = filters.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ViewerFilter filter = viewerFilterArray[n2];
                        if (filter.select((Viewer)this.modelViewer, (Object)this.modelRoot, (Object)EcoreUtil.create((EClass)reference.getEReferenceType()))) {
                            this.commandParameters.add(new EEFCommandParameter(reference, reference.getEReferenceType()));
                        }
                        ++n2;
                    }
                    continue;
                }
                this.commandParameters.add(new EEFCommandParameter(reference, reference.getEReferenceType()));
            }
        }
    }

    @Override
    protected void createSectionClient(Composite sectionContainer, FormToolkit toolkit) {
        sectionContainer.setLayout((Layout)new GridLayout());
        this.createModelRoot();
        if (this.modelRoot != null) {
            this.createToolBar(sectionContainer, toolkit);
        }
        this.createModelViewer(sectionContainer, toolkit);
    }

    private void createModelRoot() {
        Resource resource;
        AdapterFactoryEditingDomain afed;
        EList resources;
        this.editingDomain = this.getBlock().getEditingDomain();
        if (this.editingDomain instanceof AdapterFactoryEditingDomain && (resources = (afed = (AdapterFactoryEditingDomain)this.editingDomain).getResourceSet().getResources()) != null && resources.size() != 0 && (resource = (Resource)resources.get(0)).getContents() != null && resource.getContents().size() > 0) {
            this.modelRoot = (EObject)resource.getContents().get(0);
        }
    }

    private void createToolBar(Composite sectionContainer, FormToolkit toolkit) {
        if (this.modelRoot != null) {
            this.modelToolBar = new Composite(sectionContainer, 0);
            GridLayout layout = new GridLayout();
            layout.numColumns = 2;
            layout.makeColumnsEqualWidth = true;
            this.modelToolBar.setLayout((Layout)layout);
            if (this.modelRoot.eClass().getEAllReferences().size() == 0) {
                this.modelToolBar.setVisible(false);
            }
            this.createAddButton(toolkit, this.modelToolBar);
            this.createDeleteButton(toolkit, this.modelToolBar);
        }
    }

    private void createModelViewer(Composite sectionContainer, FormToolkit toolkit) {
        Composite modelViewerComposite = new Composite(sectionContainer, 0);
        modelViewerComposite.setLayout((Layout)EEFFormLayoutFactory.createMasterGridLayout(false, 1));
        modelViewerComposite.setLayoutData((Object)new GridData(1808));
        super.createSectionClient(modelViewerComposite, toolkit);
    }

    private void createDeleteButton(FormToolkit toolkit, Composite modelToolBar) {
        Button delete = toolkit.createButton(modelToolBar, "", 8);
        delete.setImage(EEFRuntimePlugin.getImage((String)"icons/16x16/Delete_16x16.gif"));
        delete.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)EEFTreeMasterPart.this.getModelViewer().getSelection();
                for (Object object : selection.toList()) {
                    if (EEFTreeMasterPart.this.editingDomain == null) continue;
                    Command command = RemoveCommand.create((EditingDomain)EEFTreeMasterPart.this.editingDomain, object);
                    EEFTreeMasterPart.this.editingDomain.getCommandStack().execute(command);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void createAddButton(FormToolkit toolkit, Composite modelToolBar) {
        Button add = toolkit.createButton(modelToolBar, "", 8);
        add.setImage(EEFRuntimePlugin.getImage((String)"icons/16x16/Add_16x16.gif"));
        DropDownSelectionListener listenerAdd = new DropDownSelectionListener(add){
            boolean init;
            {
                this.init = false;
            }

            public void widgetSelected(SelectionEvent e) {
                if (!this.init) {
                    for (EEFCommandParameter commandParameter : EEFTreeMasterPart.this.getCommandParameter()) {
                        this.add(commandParameter);
                    }
                    if (this.menu.getItemCount() == 0) {
                        ((Button)e.getSource()).setEnabled(false);
                    }
                    this.init = true;
                }
                super.widgetSelected(e);
            }

            public void add(final EEFCommandParameter commandParameter) {
                IItemLabelProvider adapte = (IItemLabelProvider)EEFTreeMasterPart.this.getAdapterFactory().adapt((Notifier)EcoreUtil.create((EClass)commandParameter.geteClass()), IItemLabelProvider.class);
                URL image = (URL)adapte.getImage((Object)EcoreUtil.create((EClass)commandParameter.geteClass()));
                MenuItem menuItem = new MenuItem(this.menu, 0);
                menuItem.setText(adapte.getText((Object)EcoreUtil.create((EClass)commandParameter.geteClass())));
                menuItem.setImage(ImageDescriptor.createFromURL((URL)image).createImage((Device)menuItem.getDisplay()));
                menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        EList list = (EList)EEFTreeMasterPart.this.modelRoot.eGet((EStructuralFeature)commandParameter.getReference());
                        EObject value = EcoreUtil.create((EClass)commandParameter.geteClass());
                        if (EEFTreeMasterPart.this.editingDomain != null) {
                            Command command = AddCommand.create((EditingDomain)EEFTreeMasterPart.this.editingDomain, (Object)EEFTreeMasterPart.this.modelRoot, null, (Object)value);
                            EEFTreeMasterPart.this.editingDomain.getCommandStack().execute(command);
                        }
                        try {
                            EEFTreeMasterPart.this.modelRoot.eResource().save(Collections.EMPTY_MAP);
                        }
                        catch (IOException e1) {
                            e1.printStackTrace();
                        }
                    }
                });
            }
        };
        add.addSelectionListener((SelectionListener)listenerAdd);
    }

    @Override
    public void addFilter(ViewerFilter filter) {
        super.addFilter(filter);
        this.createCommandParameters();
        if (this.modelToolBar != null) {
            if (this.commandParameters.size() == 0) {
                this.modelToolBar.setVisible(false);
            } else if (this.showModelToolBar) {
                this.modelToolBar.setVisible(true);
            }
        }
    }

    public void showToolBar(boolean value) {
        if (this.modelToolBar != null) {
            this.modelToolBar.setVisible(value);
            this.showModelToolBar = value;
        }
    }
}

