/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.diagram.part;

import java.util.ArrayDeque;
import java.util.Deque;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.emf.henshin.diagram.part.ValidateAction;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.notation.View;

public class ValidateScheduler {
    private final DiagramEditPart diagramEditPart;
    private final Deque<ValidateJob> scheduledJobs;
    private ValidateJob activeJob;
    private long delay;
    private final JobChangeAdapter jobListener = new JobChangeAdapter(){

        public void done(IJobChangeEvent event) {
            if (event.getJob() == ValidateScheduler.this.activeJob) {
                ValidateScheduler.this.processQueue();
            }
        }
    };

    public ValidateScheduler(DiagramEditPart diagramEditPart, long delay) {
        this.diagramEditPart = diagramEditPart;
        this.scheduledJobs = new ArrayDeque<ValidateJob>();
        this.delay = delay;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleValidation() {
        ValidateScheduler validateScheduler = this;
        synchronized (validateScheduler) {
            if (this.activeJob != null) {
                this.activeJob.cancel();
            }
            this.scheduledJobs.push(new ValidateJob());
        }
        this.processQueue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processQueue() {
        ValidateScheduler validateScheduler = this;
        synchronized (validateScheduler) {
            if (!this.scheduledJobs.isEmpty()) {
                this.activeJob = this.scheduledJobs.pop();
                this.activeJob.addJobChangeListener((IJobChangeListener)this.jobListener);
                this.activeJob.schedule(this.delay);
            }
        }
    }

    private class ValidateJob
    extends Job {
        public ValidateJob() {
            super("Henshin Validation");
            this.setPriority(40);
        }

        protected IStatus run(IProgressMonitor monitor) {
            ValidateAction.runValidation(ValidateScheduler.this.diagramEditPart, (View)ValidateScheduler.this.diagramEditPart.getDiagramView());
            return Status.OK_STATUS;
        }
    }
}

