/*
 * Decompiled with CFR 0.152.
 */
package nestedcondition.util.extensions;

import graph.Edge;
import graph.Graph;
import graph.Node;
import laxcondition.Operator;
import laxcondition.Quantifier;
import nestedcondition.EdgeMapping;
import nestedcondition.Formula;
import nestedcondition.Morphism;
import nestedcondition.NestedCondition;
import nestedcondition.NestedConstraint;
import nestedcondition.NestedconditionFactory;
import nestedcondition.NodeMapping;
import nestedcondition.QuantifiedCondition;
import nestedcondition.True;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class NestedConditionSimplifier {
    private NestedConstraint constraint;
    private NestedconditionFactory factory;

    public NestedConditionSimplifier(NestedConstraint constraint) {
        this.constraint = constraint;
        this.factory = NestedconditionFactory.eINSTANCE;
    }

    public boolean simplify() {
        if (this.simplifyTrueOrFalseInFormula()) {
            return this.simplify();
        }
        if (this.simplifyNotNot()) {
            return this.simplify();
        }
        if (this.simplifyImplies()) {
            return this.simplify();
        }
        if (this.simplifyEquivalent()) {
            return this.simplify();
        }
        if (this.simplifyXor()) {
            return this.simplify();
        }
        if (this.simplifyExists()) {
            return this.simplify();
        }
        if (this.simplifyForAll()) {
            return this.simplify();
        }
        return true;
    }

    private boolean simplifyExists() {
        TreeIterator iter = this.constraint.eAllContents();
        while (iter.hasNext()) {
            QuantifiedCondition outerCondition;
            NestedCondition cond;
            EObject eObject = (EObject)iter.next();
            if (!this.isExistsCondition(eObject) || !this.isExistsCondition(cond = (outerCondition = (QuantifiedCondition)eObject).getCondition())) continue;
            QuantifiedCondition innerCondition = (QuantifiedCondition)cond;
            Morphism outerMorphism = outerCondition.getMorphism();
            Morphism innerMorphism = innerCondition.getMorphism();
            block1: for (EdgeMapping outerEM : outerMorphism.getEdgeMappings()) {
                Edge gluingEdge = outerEM.getImage();
                for (EdgeMapping innerEM : innerMorphism.getEdgeMappings()) {
                    if (innerEM.getOrigin() != gluingEdge) continue;
                    outerEM.setImage(innerEM.getImage());
                    continue block1;
                }
            }
            block3: for (NodeMapping outerNM : outerMorphism.getNodeMappings()) {
                Node gluingNode = outerNM.getImage();
                for (NodeMapping innerNM : innerMorphism.getNodeMappings()) {
                    if (innerNM.getOrigin() != gluingNode) continue;
                    outerNM.setImage(innerNM.getImage());
                    continue block3;
                }
            }
            outerMorphism.setTo(innerMorphism.getTo());
            Graph innerDomain = innerCondition.getCodomain();
            innerCondition.setCodomain(null);
            outerCondition.setCodomain(innerDomain);
            NestedCondition innerInnerCondition = innerCondition.getCondition();
            innerCondition.setCondition(null);
            outerCondition.setCondition(innerInnerCondition);
        }
        return false;
    }

    private boolean simplifyForAll() {
        TreeIterator iter = this.constraint.eAllContents();
        while (iter.hasNext()) {
            QuantifiedCondition outerCondition;
            NestedCondition cond;
            EObject eObject = (EObject)iter.next();
            if (!this.isForAllCondition(eObject) || !this.isForAllCondition(cond = (outerCondition = (QuantifiedCondition)eObject).getCondition())) continue;
            QuantifiedCondition innerCondition = (QuantifiedCondition)cond;
            Morphism outerMorphism = outerCondition.getMorphism();
            Morphism innerMorphism = innerCondition.getMorphism();
            block1: for (EdgeMapping outerEM : outerMorphism.getEdgeMappings()) {
                Edge gluingEdge = outerEM.getImage();
                for (EdgeMapping innerEM : innerMorphism.getEdgeMappings()) {
                    if (innerEM.getOrigin() != gluingEdge) continue;
                    outerEM.setImage(innerEM.getImage());
                    continue block1;
                }
            }
            block3: for (NodeMapping outerNM : outerMorphism.getNodeMappings()) {
                Node gluingNode = outerNM.getImage();
                for (NodeMapping innerNM : innerMorphism.getNodeMappings()) {
                    if (innerNM.getOrigin() != gluingNode) continue;
                    outerNM.setImage(innerNM.getImage());
                    continue block3;
                }
            }
            outerMorphism.setTo(innerMorphism.getTo());
            Graph innerDomain = innerCondition.getCodomain();
            innerCondition.setCodomain(null);
            outerCondition.setCodomain(innerDomain);
            NestedCondition innerInnerCondition = innerCondition.getCondition();
            innerCondition.setCondition(null);
            outerCondition.setCondition(innerInnerCondition);
        }
        return false;
    }

    private boolean simplifyXor() {
        TreeIterator iter = this.constraint.eAllContents();
        while (iter.hasNext()) {
            EObject eObject = (EObject)iter.next();
            if (!this.isXorFormula(eObject)) continue;
            Formula formula = (Formula)eObject;
            Formula firstArg = (Formula)this.getCopy(formula);
            Formula secondArg = (Formula)this.getCopy(formula);
            this.swapArguments(secondArg);
            this.negateFirstArgument(firstArg);
            this.negateFirstArgument(secondArg);
            firstArg.setOperator(Operator.AND);
            secondArg.setOperator(Operator.AND);
            formula.setOperator(Operator.OR);
            formula.getArguments().set(0, (Object)firstArg);
            formula.getArguments().set(1, (Object)secondArg);
            return true;
        }
        return false;
    }

    private void negateFirstArgument(Formula formula) {
        NestedCondition firstArgument = (NestedCondition)formula.getArguments().get(0);
        Formula notFormula = this.factory.createFormula();
        notFormula.setOperator(Operator.NOT);
        formula.getArguments().set(0, (Object)notFormula);
        notFormula.getArguments().add((Object)firstArgument);
    }

    private boolean simplifyEquivalent() {
        TreeIterator iter = this.constraint.eAllContents();
        while (iter.hasNext()) {
            EObject eObject = (EObject)iter.next();
            if (!this.isEquivalentFormula(eObject)) continue;
            Formula formula = (Formula)eObject;
            Formula firstArg = (Formula)this.getCopy(formula);
            Formula secondArg = (Formula)this.getCopy(formula);
            this.swapArguments(secondArg);
            firstArg.setOperator(Operator.IMPLIES);
            secondArg.setOperator(Operator.IMPLIES);
            formula.setOperator(Operator.AND);
            formula.getArguments().set(0, (Object)firstArg);
            formula.getArguments().set(1, (Object)secondArg);
            return true;
        }
        return false;
    }

    private void swapArguments(Formula formula) {
        NestedCondition arg1 = (NestedCondition)formula.getArguments().get(0);
        NestedCondition arg2 = (NestedCondition)formula.getArguments().get(1);
        formula.getArguments().set(0, (Object)arg2);
        formula.getArguments().set(1, (Object)arg1);
    }

    private EObject getCopy(EObject original) {
        EcoreUtil.Copier copier = new EcoreUtil.Copier();
        EObject copy = copier.copy(original);
        copier.copyReferences();
        return copy;
    }

    private boolean simplifyImplies() {
        TreeIterator iter = this.constraint.eAllContents();
        while (iter.hasNext()) {
            EObject eObject = (EObject)iter.next();
            if (!this.isImpliesFormula(eObject)) continue;
            Formula formula = (Formula)eObject;
            NestedCondition arg1 = (NestedCondition)formula.getArguments().get(0);
            Formula notFormula = this.factory.createFormula();
            notFormula.setDomain(formula.getDomain());
            notFormula.setOperator(Operator.NOT);
            formula.setOperator(Operator.OR);
            formula.getArguments().set(0, (Object)notFormula);
            notFormula.getArguments().add((Object)arg1);
            return true;
        }
        return false;
    }

    private boolean simplifyTrueOrFalseInFormula() {
        TreeIterator iter = this.constraint.eAllContents();
        while (iter.hasNext()) {
            NestedCondition arg2;
            NestedCondition arg1;
            EObject container;
            Formula formula;
            EObject eObject = (EObject)iter.next();
            if (this.isAndFormula(eObject)) {
                formula = (Formula)eObject;
                container = formula.eContainer();
                arg1 = (NestedCondition)formula.getArguments().get(0);
                arg2 = (NestedCondition)formula.getArguments().get(1);
                if (this.isTrue(arg1)) {
                    if (this.twoArguments(formula)) {
                        return this.insert(container, formula, arg2);
                    }
                    return this.removeArgument(formula, arg1);
                }
                if (this.isTrue(arg2)) {
                    if (this.twoArguments(formula)) {
                        return this.insert(container, formula, arg1);
                    }
                    return this.removeArgument(formula, arg2);
                }
                if (this.isFalse(arg1)) {
                    if (this.twoArguments(formula)) {
                        return this.insert(container, formula, arg1);
                    }
                    return this.removeArgument(formula, arg2);
                }
                if (this.isFalse(arg2)) {
                    if (this.twoArguments(formula)) {
                        return this.insert(container, formula, arg2);
                    }
                    return this.removeArgument(formula, arg1);
                }
            }
            if (!this.isOrFormula(eObject)) continue;
            formula = (Formula)eObject;
            container = formula.eContainer();
            arg1 = (NestedCondition)formula.getArguments().get(0);
            arg2 = (NestedCondition)formula.getArguments().get(1);
            if (this.isTrue(arg1)) {
                if (this.twoArguments(formula)) {
                    return this.insert(container, formula, arg1);
                }
                return this.removeArgument(formula, arg2);
            }
            if (this.isTrue(arg2)) {
                if (this.twoArguments(formula)) {
                    return this.insert(container, formula, arg2);
                }
                return this.removeArgument(formula, arg1);
            }
            if (this.isFalse(arg1)) {
                if (this.twoArguments(formula)) {
                    return this.insert(container, formula, arg2);
                }
                return this.removeArgument(formula, arg1);
            }
            if (!this.isFalse(arg2)) continue;
            if (this.twoArguments(formula)) {
                return this.insert(container, formula, arg1);
            }
            return this.removeArgument(formula, arg2);
        }
        return false;
    }

    private boolean removeArgument(Formula formula, NestedCondition cond) {
        return formula.getArguments().remove((Object)cond);
    }

    private boolean twoArguments(Formula formula) {
        return formula.getArguments().size() == 2;
    }

    private boolean isFalse(NestedCondition cond) {
        if (this.isNotFormula(cond)) {
            Formula formula = (Formula)cond;
            return this.isTrue((NestedCondition)formula.getArguments().get(0));
        }
        return false;
    }

    private boolean isTrue(NestedCondition cond) {
        return cond instanceof True;
    }

    private boolean simplifyNotNot() {
        TreeIterator iter = this.constraint.eAllContents();
        while (iter.hasNext()) {
            Formula formula;
            EObject eObject = (EObject)iter.next();
            if (!this.isNotFormula(eObject) || !this.isNotFormula((EObject)(formula = (Formula)eObject).getArguments().get(0))) continue;
            Formula innerFormula = (Formula)formula.getArguments().get(0);
            NestedCondition innerCondition = (NestedCondition)innerFormula.getArguments().get(0);
            EObject container = formula.eContainer();
            return this.insert(container, formula, innerCondition);
        }
        return false;
    }

    private boolean insert(EObject container, NestedCondition oldContent, NestedCondition newContent) {
        if (container == this.constraint) {
            this.constraint.setCondition(newContent);
            return true;
        }
        if (container instanceof QuantifiedCondition) {
            QuantifiedCondition qlc = (QuantifiedCondition)container;
            qlc.setCondition(newContent);
            return true;
        }
        if (container instanceof Formula) {
            Formula f = (Formula)container;
            int index = f.getArguments().indexOf((Object)oldContent);
            f.getArguments().set(index, (Object)newContent);
            return true;
        }
        return false;
    }

    private boolean isNotFormula(EObject eObject) {
        if (eObject instanceof Formula) {
            Formula formula = (Formula)eObject;
            return formula.getOperator().equals((Object)Operator.NOT);
        }
        return false;
    }

    private boolean isAndFormula(EObject eObject) {
        if (eObject instanceof Formula) {
            Formula formula = (Formula)eObject;
            return formula.getOperator().equals((Object)Operator.AND);
        }
        return false;
    }

    private boolean isOrFormula(EObject eObject) {
        if (eObject instanceof Formula) {
            Formula formula = (Formula)eObject;
            return formula.getOperator().equals((Object)Operator.OR);
        }
        return false;
    }

    private boolean isImpliesFormula(EObject eObject) {
        if (eObject instanceof Formula) {
            Formula formula = (Formula)eObject;
            return formula.getOperator().equals((Object)Operator.IMPLIES);
        }
        return false;
    }

    private boolean isEquivalentFormula(EObject eObject) {
        if (eObject instanceof Formula) {
            Formula formula = (Formula)eObject;
            return formula.getOperator().equals((Object)Operator.EQUIVALENT);
        }
        return false;
    }

    private boolean isXorFormula(EObject eObject) {
        if (eObject instanceof Formula) {
            Formula formula = (Formula)eObject;
            return formula.getOperator().equals((Object)Operator.XOR);
        }
        return false;
    }

    private boolean isExistsCondition(EObject eObject) {
        if (eObject instanceof QuantifiedCondition) {
            QuantifiedCondition cond = (QuantifiedCondition)eObject;
            return cond.getQuantifier().equals((Object)Quantifier.EXISTS);
        }
        return false;
    }

    private boolean isForAllCondition(EObject eObject) {
        if (eObject instanceof QuantifiedCondition) {
            QuantifiedCondition cond = (QuantifiedCondition)eObject;
            return cond.getQuantifier().equals((Object)Quantifier.FORALL);
        }
        return false;
    }
}

