/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.printing.render.actions;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gmf.runtime.common.core.util.Log;
import org.eclipse.gmf.runtime.common.core.util.Trace;
import org.eclipse.gmf.runtime.common.ui.action.actions.IPrintActionHelper;
import org.eclipse.gmf.runtime.common.ui.services.editor.EditorService;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramRootEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IDiagramPreferenceSupport;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditor;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramGraphicalViewer;
import org.eclipse.gmf.runtime.diagram.ui.printing.actions.DefaultPrintActionHelper;
import org.eclipse.gmf.runtime.diagram.ui.printing.internal.util.DiagramPrinter;
import org.eclipse.gmf.runtime.diagram.ui.printing.render.internal.DiagramUIPrintingRenderDebugOptions;
import org.eclipse.gmf.runtime.diagram.ui.printing.render.internal.DiagramUIPrintingRenderPlugin;
import org.eclipse.gmf.runtime.diagram.ui.printing.render.util.RenderedDiagramPrinter;
import org.eclipse.gmf.runtime.diagram.ui.printing.util.DiagramPrinterUtil;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.IMapMode;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeUtil;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;

public class EnhancedPrintActionHelper
implements IPrintActionHelper {
    public void doPrint(IWorkbenchPart workbenchPart) {
        IMapMode mapMode;
        DiagramEditor diagramEditor = null;
        if (!(workbenchPart instanceof DiagramEditor)) {
            Log.error((Plugin)DiagramUIPrintingRenderPlugin.getInstance(), (int)4, (String)"Invalid IWorkbenchPart");
            IllegalArgumentException e = new IllegalArgumentException("Invalid IWorkbenchPart.");
            Trace.throwing((Plugin)DiagramUIPrintingRenderPlugin.getInstance(), (String)DiagramUIPrintingRenderDebugOptions.EXCEPTIONS_THROWING, EnhancedPrintActionHelper.class, (String)"doPrint()", (Throwable)e);
            throw e;
        }
        diagramEditor = (DiagramEditor)workbenchPart;
        IDiagramGraphicalViewer viewer = diagramEditor.getDiagramGraphicalViewer();
        RootEditPart rootEP = viewer == null ? null : viewer.getRootEditPart();
        PreferencesHint preferencesHint = rootEP instanceof IDiagramPreferenceSupport ? ((IDiagramPreferenceSupport)rootEP).getPreferencesHint() : PreferencesHint.USE_DEFAULTS;
        IMapMode iMapMode = mapMode = rootEP instanceof DiagramRootEditPart ? ((DiagramRootEditPart)rootEP).getMapMode() : MapModeUtil.getMapMode();
        if (!System.getProperty("os.name").toUpperCase().startsWith("WIN")) {
            DefaultPrintActionHelper.doRun((IEditorPart)diagramEditor, (DiagramPrinter)new RenderedDiagramPrinter(preferencesHint, mapMode));
            return;
        }
        DiagramPrinterUtil.printWithSettings((IEditorPart)diagramEditor, (Map)this.createDiagramMap(), (DiagramPrinter)new RenderedDiagramPrinter(preferencesHint, mapMode));
    }

    private Map createDiagramMap() {
        HashMap<String, Diagram> diagramMap = new HashMap<String, Diagram>();
        List diagramEditors = EditorService.getInstance().getRegisteredEditorParts();
        for (Object obj : diagramEditors) {
            if (!(obj instanceof DiagramEditor)) continue;
            DiagramEditor dEditor = (DiagramEditor)obj;
            String diagramName = null;
            IEditorInput editorInput = dEditor.getEditorInput();
            IFile file = (IFile)editorInput.getAdapter(IFile.class);
            if (file != null) {
                diagramName = file.getFullPath().toOSString();
            } else {
                diagramName = dEditor.getPartName();
                if (diagramName == null) {
                    diagramName = dEditor.getTitle();
                }
            }
            if (diagramName == null) {
                diagramName = dEditor.getDiagram().getName();
            }
            diagramMap.put(diagramName, dEditor.getDiagram());
        }
        return diagramMap;
    }
}

