/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.draw2d.ui.internal.routers;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.draw2d.BendpointConnectionRouter;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gmf.runtime.common.core.util.Trace;
import org.eclipse.gmf.runtime.draw2d.ui.figures.PolylineConnectionEx;
import org.eclipse.gmf.runtime.draw2d.ui.geometry.LineSeg;
import org.eclipse.gmf.runtime.draw2d.ui.internal.Draw2dDebugOptions;
import org.eclipse.gmf.runtime.draw2d.ui.internal.Draw2dPlugin;
import org.eclipse.gmf.runtime.draw2d.ui.internal.routers.RouterHelper;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeUtil;
import org.eclipse.jface.util.Assert;

public class ObliqueRouter
extends BendpointConnectionRouter {
    private ArrayListMap selfRelConnections = new ArrayListMap();
    public static final int ROUTER_FLAG_SKIPNORMALIZATION = 1;
    protected int routerFlags = 0;
    protected static final int SELFRELSIZEINIT = 62;
    protected static final int SELFRELSIZEINCR = 10;

    public boolean isAvoidingObstructions(Connection conn) {
        if (conn instanceof PolylineConnectionEx) {
            return ((PolylineConnectionEx)conn).isAvoidObstacleRouting();
        }
        return false;
    }

    public boolean isClosestDistance(Connection conn) {
        if (conn instanceof PolylineConnectionEx) {
            return ((PolylineConnectionEx)conn).isClosestDistanceRouting();
        }
        return false;
    }

    protected boolean isReorienting(Connection conn) {
        return conn.getSourceAnchor().getOwner() == null || conn.getTargetAnchor().getOwner() == null;
    }

    public final void route(Connection conn) {
        if (conn.isVisible()) {
            this.routeBendpoints(conn);
        }
    }

    public void routeBendpoints(Connection conn) {
        if (conn.getSourceAnchor() == null || conn.getTargetAnchor() == null) {
            return;
        }
        PointList points = new PointList();
        points = this.isAvoidingObstructions(conn) ? RouterHelper.getInstance().routeAroundObstructions(conn) : (this.isClosestDistance(conn) ? RouterHelper.getInstance().routeClosestDistance(conn) : RouterHelper.getInstance().routeFromConstraint(conn));
        this.routeLine(conn, 0, points);
        conn.setPoints(points);
    }

    protected boolean removePointsInViews(Connection conn, PointList newLine) {
        boolean bChanged = false;
        if (conn == null || newLine == null) {
            IllegalArgumentException iae = new IllegalArgumentException();
            Trace.throwing((Plugin)Draw2dPlugin.getInstance(), (String)Draw2dDebugOptions.EXCEPTIONS_THROWING, ((Object)((Object)this)).getClass(), (String)"removePointsInViews()", (Throwable)iae);
            throw iae;
        }
        if (newLine.size() < 3) {
            return false;
        }
        IFigure sourceOwner = conn.getSourceAnchor().getOwner();
        IFigure targetOwner = conn.getTargetAnchor().getOwner();
        if (sourceOwner == null) {
            return false;
        }
        if (targetOwner == null) {
            return false;
        }
        Rectangle startRect = null;
        if (!(sourceOwner instanceof Connection)) {
            startRect = new Rectangle(sourceOwner.getBounds());
            sourceOwner.translateToAbsolute((Translatable)startRect);
            conn.translateToRelative((Translatable)startRect);
        }
        Rectangle endRect = null;
        if (!(targetOwner instanceof Connection)) {
            endRect = new Rectangle(targetOwner.getBounds());
            targetOwner.translateToAbsolute((Translatable)endRect);
            conn.translateToRelative((Translatable)endRect);
        }
        PointList newPoints = new PointList(newLine.size());
        int i = 0;
        while (i < newLine.size()) {
            Point pt = newLine.getPoint(i);
            if (i == 0 || i == newLine.size() - 1) {
                newPoints.addPoint(pt);
            } else if (!(startRect != null && startRect.contains(pt) || endRect != null && endRect.contains(pt))) {
                newPoints.addPoint(pt);
            } else {
                bChanged = true;
            }
            ++i;
        }
        if (newPoints.size() != newLine.size()) {
            newLine.removeAllPoints();
            i = 0;
            while (i < newPoints.size()) {
                newLine.addPoint(new Point(newPoints.getPoint(i)));
                ++i;
            }
        }
        return bChanged;
    }

    public void routeLine(Connection conn, int nestedRoutingDepth, PointList newLine) {
        if (!this.checkSelfRelConnection(conn, newLine)) {
            this.removePointsInViews(conn, newLine);
        }
        this.resetEndPointsToEdge(conn, newLine);
    }

    protected static Point getStraightEdgePoint(Point ptEdge, Point ptRef1, Point ptRef2) {
        LineSeg lineSeg = new LineSeg(ptRef1, ptRef2);
        Point ptProj = lineSeg.perpIntersect(ptEdge.x, ptEdge.y);
        if (Math.abs(ptProj.x - ptRef2.x) < Math.abs(ptProj.y - ptRef2.y)) {
            ptProj.x = ptRef2.x;
        } else {
            ptProj.y = ptRef2.y;
        }
        return ptProj;
    }

    protected void resetEndPointsToEdge(Connection conn, PointList newLine) {
        RouterHelper.getInstance().resetEndPointsToEdge(conn, newLine);
    }

    protected boolean checkSelfRelConnection(Connection conn, PointList newLine) {
        if (conn.getSourceAnchor().getOwner() == conn.getTargetAnchor().getOwner() && newLine.size() < 4) {
            this.getSelfRelVertices(conn, newLine);
            return true;
        }
        this.removeSelfRelConnection(conn);
        return false;
    }

    private void removeSelfRelConnection(Connection conn) {
        if (conn.getSourceAnchor() == null || conn.getTargetAnchor() == null || conn.getSourceAnchor().getOwner() == null || conn.getTargetAnchor().getOwner() == null) {
            return;
        }
        ArrayListKey connectionKey = new ArrayListKey(conn);
        ArrayList connectionList = this.selfRelConnections.get(connectionKey);
        if (connectionList != null) {
            int index = connectionList.indexOf(conn);
            if (index == -1) {
                return;
            }
            this.selfRelConnections.remove(connectionKey, conn);
        }
    }

    protected void getSelfRelVertices(Connection conn, PointList newLine) {
        if (conn.getSourceAnchor().getOwner() == null) {
            return;
        }
        ArrayListKey connectionKey = new ArrayListKey(conn);
        int nSelfIncr = 0;
        int nIndex = 0;
        ArrayList connectionList = this.selfRelConnections.get(connectionKey);
        if (connectionList != null) {
            if (!connectionList.contains(conn)) {
                this.selfRelConnections.put(connectionKey, conn);
                connectionList = this.selfRelConnections.get(connectionKey);
            }
            Assert.isTrue(((nIndex = connectionList.indexOf(conn)) >= 0 ? 1 : 0) != 0);
        } else {
            this.selfRelConnections.put(connectionKey, conn);
        }
        Dimension selfrelsizeincr = new Dimension(10, 0);
        if (!RouterHelper.getInstance().isFeedback(conn)) {
            selfrelsizeincr = (Dimension)MapModeUtil.getMapMode((IFigure)conn).DPtoLP((Translatable)selfrelsizeincr);
        }
        IFigure owner = conn.getSourceAnchor().getOwner();
        Rectangle bBox = owner.getClientArea();
        owner.translateToAbsolute((Translatable)bBox);
        conn.translateToRelative((Translatable)bBox);
        nSelfIncr = selfrelsizeincr.width * (nIndex / 8);
        newLine.removeAllPoints();
        switch (nIndex % 8) {
            case 0: {
                this.getCornerSelfRelVertices(conn, bBox, newLine, nSelfIncr, 1, 1, bBox.getBottomRight());
                break;
            }
            case 1: {
                this.getVerticalSelfRelVertices(conn, bBox, newLine, nSelfIncr, 1, bBox.getBottom());
                break;
            }
            case 2: {
                this.getCornerSelfRelVertices(conn, bBox, newLine, nSelfIncr, -1, 1, bBox.getBottomLeft());
                break;
            }
            case 3: {
                this.getHorizontalSelfRelVertices(conn, bBox, newLine, nSelfIncr, -1, bBox.getLeft());
                break;
            }
            case 4: {
                this.getCornerSelfRelVertices(conn, bBox, newLine, nSelfIncr, -1, -1, bBox.getTopLeft());
                break;
            }
            case 5: {
                this.getVerticalSelfRelVertices(conn, bBox, newLine, nSelfIncr, -1, bBox.getTop());
                break;
            }
            case 6: {
                this.getCornerSelfRelVertices(conn, bBox, newLine, nSelfIncr, 1, -1, bBox.getTopRight());
                break;
            }
            case 7: {
                this.getHorizontalSelfRelVertices(conn, bBox, newLine, nSelfIncr, 1, bBox.getRight());
            }
        }
        Point ptS2 = newLine.getPoint(0);
        Point ptS1 = conn.getSourceAnchor().getReferencePoint();
        conn.translateToRelative((Translatable)ptS1);
        Point ptAbsS2 = new Point(ptS2);
        conn.translateToAbsolute((Translatable)ptAbsS2);
        Point ptEdge = conn.getSourceAnchor().getLocation(ptAbsS2);
        conn.translateToRelative((Translatable)ptEdge);
        ptS1 = ObliqueRouter.getStraightEdgePoint(ptEdge, ptS1, ptS2);
        Point ptE2 = newLine.getPoint(newLine.size() - 1);
        Point ptE1 = conn.getTargetAnchor().getReferencePoint();
        conn.translateToRelative((Translatable)ptE1);
        Point ptAbsE2 = new Point(ptE2);
        conn.translateToAbsolute((Translatable)ptAbsE2);
        ptEdge = conn.getTargetAnchor().getLocation(ptAbsE2);
        conn.translateToRelative((Translatable)ptEdge);
        ptE1 = ObliqueRouter.getStraightEdgePoint(ptEdge, ptE1, ptE2);
        newLine.setPoint(ptS1, 0);
        newLine.setPoint(ptE1, newLine.size() - 1);
    }

    private void getCornerSelfRelVertices(Connection conn, Rectangle bBox, PointList newLine, int nOffset, int nXDir, int nYDir, Point ptOrient) {
        int x = ptOrient.x;
        int y = bBox.getCenter().y + nYDir * bBox.height / 4;
        Point p1 = new Point(x, y);
        newLine.addPoint(p1);
        Dimension selfrelsizeinit = new Dimension(62, 0);
        if (!RouterHelper.getInstance().isFeedback(conn)) {
            selfrelsizeinit = (Dimension)MapModeUtil.getMapMode((IFigure)conn).DPtoLP((Translatable)selfrelsizeinit);
        }
        int xNew = x + nXDir * (selfrelsizeinit.width + nOffset);
        Point p2 = new Point(xNew, y);
        newLine.addPoint(p2);
        int yNew = ptOrient.y + nYDir * (selfrelsizeinit.width + nOffset);
        Point p3 = new Point(xNew, yNew);
        newLine.addPoint(p3);
        xNew = ptOrient.x - nXDir * bBox.width / 4;
        Point p4 = new Point(xNew, yNew);
        newLine.addPoint(p4);
        yNew = ptOrient.y;
        Point p5 = new Point(xNew, yNew);
        newLine.addPoint(p5);
    }

    private void getVerticalSelfRelVertices(Connection conn, Rectangle bBox, PointList newLine, int nOffset, int nDir, Point ptOrient) {
        int nWidth = bBox.width / 4;
        int x = ptOrient.x - nWidth / 2;
        int y = ptOrient.y;
        Point p1 = new Point(x, y);
        newLine.addPoint(p1);
        Dimension selfrelsizeinit = new Dimension(62, 0);
        if (!RouterHelper.getInstance().isFeedback(conn)) {
            selfrelsizeinit = (Dimension)MapModeUtil.getMapMode((IFigure)conn).DPtoLP((Translatable)selfrelsizeinit);
        }
        int yNew = y + nDir * (selfrelsizeinit.width + nOffset);
        Point p2 = new Point(x, yNew);
        newLine.addPoint(p2);
        int xNew = ptOrient.x + nWidth / 2;
        Point p3 = new Point(xNew, yNew);
        newLine.addPoint(p3);
        yNew = ptOrient.y;
        Point p4 = new Point(xNew, yNew);
        newLine.addPoint(p4);
    }

    private void getHorizontalSelfRelVertices(Connection conn, Rectangle bBox, PointList newLine, int nOffset, int nDir, Point ptOrient) {
        int nHeight = bBox.height / 4;
        int y = ptOrient.y - nHeight / 2;
        int x = ptOrient.x;
        Point p1 = new Point(x, y);
        newLine.addPoint(p1);
        Dimension selfrelsizeinit = new Dimension(62, 0);
        if (!RouterHelper.getInstance().isFeedback(conn)) {
            selfrelsizeinit = (Dimension)MapModeUtil.getMapMode((IFigure)conn).DPtoLP((Translatable)selfrelsizeinit);
        }
        int xNew = x + nDir * (selfrelsizeinit.width + nOffset);
        Point p2 = new Point(xNew, y);
        newLine.addPoint(p2);
        int yNew = ptOrient.y + nHeight / 2;
        Point p3 = new Point(xNew, yNew);
        newLine.addPoint(p3);
        xNew = ptOrient.x;
        Point p4 = new Point(xNew, yNew);
        newLine.addPoint(p4);
    }

    public void remove(Connection connection) {
        super.remove(connection);
        RouterHelper.getInstance().remove(connection);
        this.removeSelfRelConnection(connection);
    }

    public void invalidate(Connection connection) {
        super.invalidate(connection);
        RouterHelper.getInstance().invalidate(connection);
    }

    public void setConstraint(Connection connection, Object constraint) {
        super.setConstraint(connection, constraint);
        RouterHelper.getInstance().setConstraint(connection, constraint);
    }

    public static class ArrayListMap {
        private HashMap map = new HashMap();

        public ArrayList get(Object key) {
            Object value = this.map.get(key);
            if (value == null) {
                return null;
            }
            if (value instanceof ArrayList) {
                return (ArrayList)value;
            }
            ArrayList v = new ArrayList(1);
            v.add(value);
            return v;
        }

        public void put(Object key, Object value) {
            Object arrayListObject = this.map.get(key);
            if (arrayListObject == null) {
                this.map.put(key, value);
                return;
            }
            if (arrayListObject instanceof ArrayList) {
                ArrayList arrayList = (ArrayList)arrayListObject;
                if (!arrayList.contains(value)) {
                    arrayList.add(value);
                }
                return;
            }
            if (arrayListObject != value) {
                ArrayList<Object> arrayList = new ArrayList<Object>(2);
                arrayList.add(arrayListObject);
                arrayList.add(value);
                this.map.put(key, arrayList);
            }
        }

        public void remove(Object key, Object value) {
            Object arrayListObject = this.map.get(key);
            if (arrayListObject != null) {
                if (arrayListObject instanceof ArrayList) {
                    ArrayList arrayList = (ArrayList)arrayListObject;
                    arrayList.remove(value);
                    if (arrayList.isEmpty()) {
                        this.map.remove(key);
                    }
                    return;
                }
                this.map.remove(key);
            }
        }

        public int size() {
            return this.map.size();
        }
    }

    private class ArrayListKey {
        private ConnectionAnchor connectAnchor1;
        private ConnectionAnchor connectAnchor2;

        ArrayListKey(Connection conn) {
            this.connectAnchor1 = conn.getSourceAnchor();
            this.connectAnchor2 = conn.getTargetAnchor();
        }

        public ConnectionAnchor getSourceAnchor() {
            return this.connectAnchor1;
        }

        public ConnectionAnchor getTargetAnchor() {
            return this.connectAnchor2;
        }

        public int hashCode() {
            return this.connectAnchor1.hashCode() ^ this.connectAnchor2.hashCode();
        }

        public boolean equals(Object object) {
            boolean isEqual = false;
            if (object instanceof ArrayListKey) {
                ArrayListKey listKey = (ArrayListKey)object;
                ConnectionAnchor lk1 = listKey.getSourceAnchor();
                ConnectionAnchor lk2 = listKey.getTargetAnchor();
                isEqual = lk1.equals(this.connectAnchor1) && lk2.equals(this.connectAnchor2) || lk1.equals(this.connectAnchor2) && lk2.equals(this.connectAnchor1);
            }
            return isEqual;
        }
    }
}

