/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.emf.type.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.dynamichelpers.ExtensionTracker;
import org.eclipse.core.runtime.dynamichelpers.IExtensionChangeHandler;
import org.eclipse.core.runtime.dynamichelpers.IExtensionTracker;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.gmf.runtime.common.core.util.Log;
import org.eclipse.gmf.runtime.emf.type.core.ClientContextManager;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeAddedEvent;
import org.eclipse.gmf.runtime.emf.type.core.IClientContext;
import org.eclipse.gmf.runtime.emf.type.core.IEditHelperContext;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.IElementTypeFactory;
import org.eclipse.gmf.runtime.emf.type.core.IElementTypeRegistryListener;
import org.eclipse.gmf.runtime.emf.type.core.IMetamodelType;
import org.eclipse.gmf.runtime.emf.type.core.ISpecializationType;
import org.eclipse.gmf.runtime.emf.type.core.NullElementType;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.IEditHelperAdvice;
import org.eclipse.gmf.runtime.emf.type.core.internal.EMFTypePlugin;
import org.eclipse.gmf.runtime.emf.type.core.internal.descriptors.ElementTypeDescriptor;
import org.eclipse.gmf.runtime.emf.type.core.internal.descriptors.ElementTypeFactoryDescriptor;
import org.eclipse.gmf.runtime.emf.type.core.internal.descriptors.MetamodelDescriptor;
import org.eclipse.gmf.runtime.emf.type.core.internal.descriptors.MetamodelTypeDescriptor;
import org.eclipse.gmf.runtime.emf.type.core.internal.descriptors.SpecializationTypeDescriptor;
import org.eclipse.gmf.runtime.emf.type.core.internal.impl.DefaultMetamodelType;
import org.eclipse.gmf.runtime.emf.type.core.internal.impl.EClassUtil;
import org.eclipse.gmf.runtime.emf.type.core.internal.impl.SpecializationTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.internal.l10n.EMFTypeCoreMessages;

public class ElementTypeRegistry {
    private static final String ELEMENT_TYPES_EXT_P_NAME = "elementTypes";
    private static final IElementType[] EMPTY_ELEMENT_TYPE_ARRAY = new IElementType[0];
    private final SpecializationTypeRegistry specializationTypeRegistry = new SpecializationTypeRegistry();
    private final Map metamodelTypeDescriptorsByNsURI = new HashMap();
    private final Map metamodelTypeDescriptorsById = new HashMap();
    private final Map elementTypeFactoryMap = new HashMap();
    private final List elementTypeRegistryListeners = new ArrayList();
    private static ElementTypeRegistry INSTANCE;
    private ExtensionTracker extensionTracker;
    private IExtensionChangeHandler extensionListener;

    private ElementTypeRegistry(IConfigurationElement[] configs) {
        this.registerNullElementType();
        if (EMFTypePlugin.isDynamicAware()) {
            this.startExtensionTracking();
        }
        this.load(configs);
    }

    private void startExtensionTracking() {
        this.extensionListener = new IExtensionChangeHandler(){

            public void addExtension(IExtensionTracker tracker, IExtension extension) {
                ElementTypeRegistry.this.load(extension.getConfigurationElements());
            }

            public void removeExtension(IExtension extension, Object[] objects) {
            }
        };
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint(EMFTypePlugin.getPluginId(), ELEMENT_TYPES_EXT_P_NAME);
        this.extensionTracker = new ExtensionTracker();
        this.extensionTracker.registerHandler(this.extensionListener, ExtensionTracker.createExtensionPointFilter((IExtensionPoint)point));
    }

    public static ElementTypeRegistry getInstance() {
        if (INSTANCE == null) {
            IConfigurationElement[] configs = Platform.getExtensionRegistry().getConfigurationElementsFor(EMFTypePlugin.getPluginId(), ELEMENT_TYPES_EXT_P_NAME);
            INSTANCE = new ElementTypeRegistry(configs);
        }
        return INSTANCE;
    }

    public IEditHelperAdvice[] getEditHelperAdvice(IElementType type) {
        IClientContext clientContext = ClientContextManager.getInstance().getBinding(type);
        return this.getEditHelperAdvice(type, clientContext);
    }

    public IEditHelperAdvice[] getEditHelperAdvice(IElementType type, IClientContext clientContext) {
        IClientContext context = clientContext == null ? ClientContextManager.getDefaultClientContext() : clientContext;
        EClass eClass = type.getEClass();
        MetamodelTypeDescriptor metamodelType = eClass != null ? this.getMetamodelTypeDescriptor(eClass, context) : null;
        List result = this.specializationTypeRegistry.getEditHelperAdvice(type, metamodelType, context);
        return result.toArray(new IEditHelperAdvice[0]);
    }

    public IEditHelperAdvice[] getEditHelperAdvice(EObject eObject, IClientContext clientContext) {
        MetamodelTypeDescriptor desc = this.getMetamodelTypeDescriptor(eObject, clientContext);
        List result = desc == null ? this.specializationTypeRegistry.getEditHelperAdvice(eObject, DefaultMetamodelType.getDescriptorInstance(), clientContext) : this.specializationTypeRegistry.getEditHelperAdvice(eObject, desc, clientContext);
        return result.toArray(new IEditHelperAdvice[0]);
    }

    public IEditHelperAdvice[] getEditHelperAdvice(EObject eObject) {
        IClientContext clientContext = ClientContextManager.getInstance().getClientContextFor(eObject);
        return this.getEditHelperAdvice(eObject, clientContext);
    }

    public IEditHelperAdvice[] getEditHelperAdvice(Object o) {
        if (o instanceof EObject) {
            return this.getEditHelperAdvice((EObject)o);
        }
        if (o instanceof IElementType) {
            return this.getEditHelperAdvice((IElementType)o);
        }
        if (o instanceof IEditHelperContext) {
            IEditHelperContext editHelperContext = (IEditHelperContext)o;
            IClientContext clientContext = editHelperContext.getClientContext();
            IElementType elementType = editHelperContext.getElementType();
            EObject eObject = editHelperContext.getEObject();
            if (clientContext != null) {
                if (elementType != null) {
                    return this.getEditHelperAdvice(elementType, clientContext);
                }
                if (eObject != null) {
                    return this.getEditHelperAdvice(eObject, clientContext);
                }
            } else {
                if (elementType != null) {
                    return this.getEditHelperAdvice(elementType);
                }
                if (eObject != null) {
                    return this.getEditHelperAdvice(eObject);
                }
            }
        }
        return null;
    }

    public IElementType[] getContainedTypes(EObject eContainer, EReference reference, IClientContext clientContext) {
        HashSet<IElementType> result = new HashSet<IElementType>();
        EClass containerEClass = eContainer.eClass();
        if (reference.isContainment() && containerEClass.getEAllReferences().contains((Object)reference)) {
            EClass eType = (EClass)reference.getEType();
            Set types = this.getSubtypes(containerEClass.getEPackage(), eType);
            types.add(eType);
            List metamodelTypeDescriptors = this.getMetamodelTypeDescriptors(types, clientContext);
            for (MetamodelTypeDescriptor nextMetamodelTypeDescriptor : metamodelTypeDescriptors) {
                IMetamodelType nextMetamodelType = (IMetamodelType)nextMetamodelTypeDescriptor.getElementType();
                if (nextMetamodelType == null || nextMetamodelType.getEClass().isAbstract()) continue;
                result.add(nextMetamodelType);
                List specializationDescriptors = this.specializationTypeRegistry.getMatchingSpecializations(nextMetamodelTypeDescriptor, eContainer, reference, clientContext);
                for (ElementTypeDescriptor nextDescriptor : specializationDescriptors) {
                    IElementType nextElementType = nextDescriptor.getElementType();
                    if (nextElementType == null) continue;
                    result.add(nextElementType);
                }
            }
        }
        return result.toArray(EMPTY_ELEMENT_TYPE_ARRAY);
    }

    public IElementType[] getContainedTypes(EObject eContainer, EReference reference) {
        IClientContext clientContext = ClientContextManager.getInstance().getClientContextFor(eContainer);
        return this.getContainedTypes(eContainer, reference, clientContext);
    }

    private Set getSubtypes(EPackage pkg, EClass eType) {
        HashSet<EClassifier> result = new HashSet<EClassifier>();
        EList classifiers = pkg.getEClassifiers();
        for (EClassifier nextClassifier : classifiers) {
            if (!(nextClassifier instanceof EClass) || eType != EcorePackage.Literals.EOBJECT && !((EClass)nextClassifier).getEAllSuperTypes().contains((Object)eType)) continue;
            result.add(nextClassifier);
        }
        return result;
    }

    private IMetamodelType getMetamodelType(EClass eClass, IClientContext context) {
        MetamodelTypeDescriptor descriptor = this.getMetamodelTypeDescriptor(eClass, context);
        if (descriptor != null) {
            return (IMetamodelType)descriptor.getElementType();
        }
        return null;
    }

    private IMetamodelType getMetamodelType(EObject eObject, IClientContext clientContext) {
        return this.getMetamodelType(eObject.eClass(), clientContext);
    }

    public IElementType getElementType(Object o) {
        if (o instanceof EObject) {
            return this.getElementType((EObject)o);
        }
        if (o instanceof IElementType) {
            return (IElementType)o;
        }
        if (o instanceof IEditHelperContext) {
            IEditHelperContext editHelperContext = (IEditHelperContext)o;
            IElementType elementType = editHelperContext.getElementType();
            if (elementType != null) {
                return elementType;
            }
            IClientContext clientContext = editHelperContext.getClientContext();
            EObject eObject = editHelperContext.getEObject();
            if (eObject != null) {
                if (clientContext != null) {
                    return this.getElementType(eObject, clientContext);
                }
                return this.getElementType(eObject);
            }
        }
        return null;
    }

    public IElementType getElementType(EClass eClass) {
        return this.getElementType(eClass, null);
    }

    public IElementType getElementType(EClass eClass, IClientContext clientContext) {
        IMetamodelType result = this.getMetamodelType(eClass, clientContext);
        if (result == null) {
            result = DefaultMetamodelType.getInstance();
        }
        return result;
    }

    public IElementType getElementType(EObject eObject) {
        IClientContext clientContext = ClientContextManager.getInstance().getClientContextFor(eObject);
        return this.getElementType(eObject, clientContext);
    }

    public IElementType getElementType(EObject eObject, IClientContext clientContext) {
        IMetamodelType result = this.getMetamodelType(eObject, clientContext);
        if (result == null) {
            result = DefaultMetamodelType.getInstance();
        }
        return result;
    }

    private MetamodelTypeDescriptor getMetamodelTypeDescriptor(EObject eObject, IClientContext context) {
        return this.getMetamodelTypeDescriptor(eObject.eClass(), context);
    }

    private MetamodelTypeDescriptor getMetamodelTypeDescriptor(EClass eClass, IClientContext context) {
        Map metamodelTypeDescriptorsByEClass;
        Collection descriptors;
        IClientContext clientContext = context;
        if (clientContext == null) {
            clientContext = ClientContextManager.getDefaultClientContext();
        }
        Collection collection = descriptors = (metamodelTypeDescriptorsByEClass = (Map)this.metamodelTypeDescriptorsByNsURI.get(eClass.getEPackage().getNsURI())) != null ? (Collection)metamodelTypeDescriptorsByEClass.get(eClass.getName()) : null;
        if (descriptors != null) {
            for (MetamodelTypeDescriptor descriptor : descriptors) {
                if (!clientContext.includes(descriptor)) continue;
                return descriptor;
            }
        }
        List<EClass> supertypes = EClassUtil.getEAllSuperTypes(eClass);
        int i = supertypes.size() - 1;
        while (i >= 0) {
            EClass nextEClass = supertypes.get(i);
            metamodelTypeDescriptorsByEClass = (Map)this.metamodelTypeDescriptorsByNsURI.get(nextEClass.getEPackage().getNsURI());
            Collection collection2 = descriptors = metamodelTypeDescriptorsByEClass != null ? (Collection)metamodelTypeDescriptorsByEClass.get(nextEClass.getName()) : null;
            if (descriptors != null) {
                for (MetamodelTypeDescriptor descriptor : descriptors) {
                    if (!clientContext.includes(descriptor)) continue;
                    return descriptor;
                }
            }
            --i;
        }
        return null;
    }

    public IElementType[] getAllTypesMatching(EObject eObject, IClientContext clientContext) {
        ArrayList<IElementType> result = new ArrayList<IElementType>();
        IMetamodelType metamodelType = this.getMetamodelType(eObject, clientContext);
        if (metamodelType != null) {
            MetamodelTypeDescriptor desc = this.getMetamodelTypeDescriptor(eObject, clientContext);
            List specializations = desc == null ? Collections.EMPTY_LIST : this.specializationTypeRegistry.getSpecializationDescriptorsMatching(eObject, desc, clientContext);
            for (SpecializationTypeDescriptor next : specializations) {
                IElementType elementType = next.getElementType();
                if (elementType == null) continue;
                result.add(elementType);
            }
            result.add(metamodelType);
            IElementType[] superTypes = metamodelType.getAllSuperTypes();
            int i = superTypes.length - 1;
            while (i >= 0) {
                result.add(superTypes[i]);
                --i;
            }
        }
        if (result.isEmpty()) {
            result.add(DefaultMetamodelType.getInstance());
        }
        return result.toArray(EMPTY_ELEMENT_TYPE_ARRAY);
    }

    public IElementType[] getAllTypesMatching(EObject eObject) {
        IClientContext clientContext = ClientContextManager.getInstance().getClientContextFor(eObject);
        return this.getAllTypesMatching(eObject, clientContext);
    }

    public ISpecializationType[] getSpecializationsOf(String id) {
        ElementTypeDescriptor descriptor = this.getTypeDescriptor(id);
        if (descriptor == null) {
            return new ISpecializationType[0];
        }
        IClientContext clientContext = ClientContextManager.getInstance().getBinding(descriptor);
        return this.specializationTypeRegistry.getAllSpecializationTypes(descriptor, clientContext);
    }

    public IMetamodelType[] getMetamodelTypes(IClientContext clientContext) {
        ArrayList<IElementType> result = new ArrayList<IElementType>();
        for (MetamodelTypeDescriptor descriptor : this.metamodelTypeDescriptorsById.values()) {
            if (!clientContext.includes(descriptor)) continue;
            result.add(descriptor.getElementType());
        }
        return result.toArray(new IMetamodelType[result.size()]);
    }

    public ISpecializationType[] getSpecializationTypes(IClientContext clientContext) {
        ArrayList<IElementType> result = new ArrayList<IElementType>();
        Collection specializations = this.specializationTypeRegistry.getSpecializationTypeDescriptors(clientContext);
        Iterator i = specializations.iterator();
        while (i.hasNext()) {
            result.add(((SpecializationTypeDescriptor)i.next()).getElementType());
        }
        return result.toArray(new ISpecializationType[result.size()]);
    }

    public IElementType[] getElementTypes(IClientContext clientContext) {
        IMetamodelType[] metamodelTypes = this.getMetamodelTypes(clientContext);
        ISpecializationType[] specializationTypes = this.getSpecializationTypes(clientContext);
        IElementType[] result = new IElementType[metamodelTypes.length + specializationTypes.length];
        int i = 0;
        while (i < metamodelTypes.length) {
            result[i] = metamodelTypes[i];
            ++i;
        }
        i = 0;
        while (i < specializationTypes.length) {
            result[i + metamodelTypes.length] = specializationTypes[i];
            ++i;
        }
        return result;
    }

    public IElementType getType(String id) {
        ElementTypeDescriptor typeDescriptor = this.getTypeDescriptor(id);
        if (typeDescriptor != null) {
            return typeDescriptor.getElementType();
        }
        if ("org.eclipse.gmf.runtime.emf.type.core.default".equals(id)) {
            return DefaultMetamodelType.getInstance();
        }
        return null;
    }

    public IElementTypeFactory getElementTypeFactory(String kindName) {
        ElementTypeFactoryDescriptor descriptor = (ElementTypeFactoryDescriptor)this.elementTypeFactoryMap.get(kindName);
        if (descriptor != null) {
            return descriptor.getElementTypeFactory();
        }
        return null;
    }

    public boolean register(IMetamodelType metamodelType) {
        if (metamodelType == null || this.getType(metamodelType.getId()) != null) {
            return false;
        }
        MetamodelTypeDescriptor descriptor = new MetamodelTypeDescriptor(metamodelType);
        boolean result = this.register(descriptor);
        if (result) {
            this.fireElementTypeAddedEvent(new ElementTypeAddedEvent(metamodelType.getId()));
        }
        return result;
    }

    public boolean register(ISpecializationType specializationType) {
        if (specializationType == null || this.getType(specializationType.getId()) != null) {
            return false;
        }
        boolean result = this.specializationTypeRegistry.registerSpecializationType(specializationType);
        if (result) {
            this.fireElementTypeAddedEvent(new ElementTypeAddedEvent(specializationType.getId()));
        }
        return result;
    }

    private void removeInvalidSpecializations() {
        ArrayList<SpecializationTypeDescriptor> specializationsToReject = new ArrayList<SpecializationTypeDescriptor>();
        Collection specializationTypes = this.specializationTypeRegistry.getSpecializationTypeDescriptors();
        for (SpecializationTypeDescriptor nextSpecialization : specializationTypes) {
            MetamodelTypeDescriptor metamodelTypeDescriptor = this.getMetamodelTypeDescriptor(nextSpecialization);
            if (metamodelTypeDescriptor != null) continue;
            specializationsToReject.add(nextSpecialization);
        }
        Iterator i = specializationsToReject.iterator();
        while (i.hasNext()) {
            this.specializationTypeRegistry.removeSpecializationType((SpecializationTypeDescriptor)i.next());
        }
    }

    private void loadMetamodel(IConfigurationElement configElement) throws CoreException {
        MetamodelDescriptor descriptor = new MetamodelDescriptor(configElement);
        IConfigurationElement[] typeConfigs = configElement.getChildren();
        int i = 0;
        while (i < typeConfigs.length) {
            IConfigurationElement next = typeConfigs[i];
            String name = next.getName();
            if (name.equals("metamodelType")) {
                this.registerMetamodelType(next, descriptor);
            } else if (name.equals("specializationType")) {
                this.registerSpecializationType(next, descriptor);
            } else if (name.equals("adviceBinding")) {
                this.specializationTypeRegistry.registerAdviceBinding(next, descriptor);
            }
            ++i;
        }
    }

    private void registerMetamodelType(IConfigurationElement configElement, MetamodelDescriptor metamodelDescriptor) throws CoreException {
        MetamodelTypeDescriptor descriptor = new MetamodelTypeDescriptor(configElement, metamodelDescriptor);
        this.register(descriptor);
    }

    private SpecializationTypeDescriptor registerSpecializationType(IConfigurationElement configElement, MetamodelDescriptor metamodelDescriptor) throws CoreException {
        return this.specializationTypeRegistry.registerSpecializationType(configElement, metamodelDescriptor);
    }

    private boolean register(MetamodelTypeDescriptor typeDescriptor) {
        ArrayList<MetamodelTypeDescriptor> descriptors;
        if (this.checkForDuplicate(typeDescriptor)) {
            return false;
        }
        String nsURI = typeDescriptor.getNsURI();
        String eClassName = typeDescriptor.getEClassName();
        HashMap<String, ArrayList<MetamodelTypeDescriptor>> metamodelTypeDescriptorsByEClass = (HashMap<String, ArrayList<MetamodelTypeDescriptor>>)this.metamodelTypeDescriptorsByNsURI.get(nsURI);
        if (metamodelTypeDescriptorsByEClass == null) {
            metamodelTypeDescriptorsByEClass = new HashMap<String, ArrayList<MetamodelTypeDescriptor>>();
            this.metamodelTypeDescriptorsByNsURI.put(nsURI, metamodelTypeDescriptorsByEClass);
        }
        if ((descriptors = (ArrayList<MetamodelTypeDescriptor>)metamodelTypeDescriptorsByEClass.get(eClassName)) == null) {
            descriptors = new ArrayList<MetamodelTypeDescriptor>();
            metamodelTypeDescriptorsByEClass.put(eClassName, descriptors);
        }
        descriptors.add(typeDescriptor);
        this.metamodelTypeDescriptorsById.put(typeDescriptor.getId(), typeDescriptor);
        return true;
    }

    private void loadElementTypeFactory(IConfigurationElement configElement) throws CoreException {
        ElementTypeFactoryDescriptor descriptor = new ElementTypeFactoryDescriptor(configElement);
        this.elementTypeFactoryMap.put(descriptor.getKindName(), descriptor);
    }

    private boolean checkForDuplicate(ElementTypeDescriptor typeDescriptor) {
        if (this.metamodelTypeDescriptorsById.containsKey(typeDescriptor.getId())) {
            Log.error((Plugin)EMFTypePlugin.getPlugin(), (int)11, (String)EMFTypeCoreMessages.bind((String)EMFTypeCoreMessages.type_not_init_WARN_, (Object)typeDescriptor.getId(), (Object)EMFTypeCoreMessages.type_reason_duplicate_id_WARN_));
            return true;
        }
        return false;
    }

    private List getMetamodelTypeDescriptors(Set eClasses, IClientContext context) {
        ArrayList<MetamodelTypeDescriptor> result = new ArrayList<MetamodelTypeDescriptor>();
        for (EClass nextType : eClasses) {
            MetamodelTypeDescriptor metamodelTypeDescriptor = this.getMetamodelTypeDescriptor(nextType, context);
            if (metamodelTypeDescriptor == null) continue;
            result.add(metamodelTypeDescriptor);
        }
        return result;
    }

    private ElementTypeDescriptor getTypeDescriptor(String id) {
        ElementTypeDescriptor typeDescriptor = (ElementTypeDescriptor)this.metamodelTypeDescriptorsById.get(id);
        if (typeDescriptor == null) {
            typeDescriptor = this.specializationTypeRegistry.getSpecializationTypeDescriptor(id);
        }
        return typeDescriptor;
    }

    private MetamodelTypeDescriptor getMetamodelTypeDescriptor(SpecializationTypeDescriptor specializationTypeDescriptor) {
        MetamodelTypeDescriptor metamodelTypeDescriptor = null;
        String[] specializedTypeIds = specializationTypeDescriptor.getSpecializationTypeIds();
        int j = 0;
        while (j < specializedTypeIds.length) {
            ElementTypeDescriptor nextSpecializedType = this.getTypeDescriptor(specializedTypeIds[j]);
            if (nextSpecializedType == null) {
                Log.error((Plugin)EMFTypePlugin.getPlugin(), (int)28, (String)EMFTypeCoreMessages.bind((String)EMFTypeCoreMessages.specializationType_specializes_invalid_id_ERROR_, (Object)specializationTypeDescriptor.getId(), (Object)specializedTypeIds[j]));
                return null;
            }
            MetamodelTypeDescriptor specializedMetamodelType = null;
            if (nextSpecializedType instanceof MetamodelTypeDescriptor) {
                specializedMetamodelType = (MetamodelTypeDescriptor)nextSpecializedType;
            } else if (nextSpecializedType instanceof SpecializationTypeDescriptor) {
                SpecializationTypeDescriptor nextSpecializationType = (SpecializationTypeDescriptor)nextSpecializedType;
                specializedMetamodelType = this.getMetamodelTypeDescriptor(nextSpecializationType);
            }
            if (specializedMetamodelType == null) {
                metamodelTypeDescriptor = null;
                break;
            }
            if (metamodelTypeDescriptor == null) {
                metamodelTypeDescriptor = specializedMetamodelType;
            } else if (metamodelTypeDescriptor != specializedMetamodelType) {
                metamodelTypeDescriptor = null;
                break;
            }
            ++j;
        }
        if (metamodelTypeDescriptor == null) {
            Log.error((Plugin)EMFTypePlugin.getPlugin(), (int)27, (String)EMFTypeCoreMessages.bind((String)EMFTypeCoreMessages.specializationType_specializes_multiple_metamodel_types_ERROR_, (Object)specializationTypeDescriptor.getId()));
        }
        return metamodelTypeDescriptor;
    }

    private synchronized void load(IConfigurationElement[] configs) {
        int i = 0;
        while (i < configs.length) {
            String sourcePluginId;
            IConfigurationElement next = configs[i];
            try {
                String name = next.getName();
                if (name.equals("metamodel")) {
                    this.loadMetamodel(next);
                } else if (name.equals("elementTypeFactory")) {
                    this.loadElementTypeFactory(next);
                } else if (name.equals("specializationType")) {
                    this.registerSpecializationType(next, null);
                }
            }
            catch (CoreException ce) {
                sourcePluginId = next.getDeclaringExtension().getContributor().getName();
                Log.error((Plugin)EMFTypePlugin.getPlugin(), (int)ce.getStatus().getCode(), (String)EMFTypeCoreMessages.bind((String)EMFTypeCoreMessages.xml_parsing_ERROR_, (Object)sourcePluginId, (Object)ce.getStatus().getMessage()), null);
            }
            catch (Exception e) {
                sourcePluginId = next.getDeclaringExtension().getContributor().getName();
                Log.error((Plugin)EMFTypePlugin.getPlugin(), (int)10, (String)EMFTypeCoreMessages.bind((String)EMFTypeCoreMessages.xml_parsing_ERROR_, (Object)sourcePluginId, (Object)e.getMessage()), (Throwable)e);
            }
            ++i;
        }
        this.removeInvalidSpecializations();
    }

    public void addElementTypeRegistryListener(IElementTypeRegistryListener l) {
        if (!this.elementTypeRegistryListeners.contains(l)) {
            this.elementTypeRegistryListeners.add(l);
        }
    }

    public void removeElementTypeRegistryListener(IElementTypeRegistryListener l) {
        if (this.elementTypeRegistryListeners.contains(l)) {
            this.elementTypeRegistryListeners.remove(l);
        }
    }

    private void fireElementTypeAddedEvent(ElementTypeAddedEvent e) {
        for (IElementTypeRegistryListener nextListener : this.elementTypeRegistryListeners) {
            nextListener.elementTypeAdded(e);
        }
    }

    private void registerNullElementType() {
        this.register(NullElementType.getInstance());
    }
}

