/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.common.ui.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.gmf.runtime.common.core.util.Log;
import org.eclipse.gmf.runtime.common.core.util.Trace;
import org.eclipse.gmf.runtime.common.ui.dialogs.ExpansionType;
import org.eclipse.gmf.runtime.common.ui.dialogs.IShowRelatedElementsWithDetails;
import org.eclipse.gmf.runtime.common.ui.dialogs.SelectableElement;
import org.eclipse.gmf.runtime.common.ui.dialogs.ShowRelatedElementsComposite;
import org.eclipse.gmf.runtime.common.ui.dialogs.ShowRelatedElementsPredefinedComposite;
import org.eclipse.gmf.runtime.common.ui.dialogs.ShowRelatedElementsPreset;
import org.eclipse.gmf.runtime.common.ui.internal.CommonUIDebugOptions;
import org.eclipse.gmf.runtime.common.ui.internal.CommonUIPlugin;
import org.eclipse.gmf.runtime.common.ui.internal.l10n.CommonUIMessages;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class ShowRelatedElementsDialog
extends Dialog
implements IShowRelatedElementsWithDetails {
    private SelectableElement rootElement;
    private String helpContextId;
    private ShowRelatedElementsComposite showRelatedElementsComposite;
    protected boolean detailsShown = false;
    IDialogSettings dialogSettings = CommonUIPlugin.getDefault().getDialogSettings();
    protected static final String DIALOG_SETTINGS_KEY = "ShowRelatedElementsDetails";
    protected List queriesList;
    protected int cachedExpandLevels = 1;
    protected int cachedExpansionType = ExpansionType.BOTH.getOrdinal();
    protected List cachedRelationshipTypes;
    protected Composite placeholderForShowRelatedElementsComposite = null;
    protected ShowRelatedElementsPredefinedComposite showRelatedElementsPredefinedComposite;
    protected Composite body;
    protected int preferredViewerWidth = -1;
    public static int MAX_VIEWER_WIDTH = 360;

    static {
        try {
            MAX_VIEWER_WIDTH = Integer.parseInt(CommonUIMessages.ShowRelatedElementsDialog_MAX_VIEWER_WIDTH);
        }
        catch (NumberFormatException e) {
            Trace.catching((Plugin)CommonUIPlugin.getDefault(), (String)CommonUIDebugOptions.EXCEPTIONS_CATCHING, ((Object)((Object)CommonUIPlugin.getDefault())).getClass(), (String)"NumberFormatException", (Throwable)e);
            Log.error((Plugin)CommonUIPlugin.getDefault(), (int)5, (String)"Failed to parse Show Related Elements Composite's localized size", (Throwable)e);
        }
    }

    public ShowRelatedElementsDialog(Shell parentShell, SelectableElement aRootElement) {
        this(parentShell, aRootElement, null);
    }

    public ShowRelatedElementsDialog(Shell parentShell, SelectableElement aRootElement, List aQueriesList) {
        super(parentShell);
        this.rootElement = aRootElement;
        this.queriesList = aQueriesList;
        this.initDialogSettings();
    }

    protected ShowRelatedElementsPredefinedComposite makePredefinedComposite(Composite parent, SelectableElement root, List queries, int viewerWidth) {
        return new ShowRelatedElementsPredefinedComposite(parent, this, root, queries, viewerWidth, this.detailsShown);
    }

    protected int getPreferredViewerWidth() {
        if (this.preferredViewerWidth == -1) {
            this.preferredViewerWidth = SelectableElement.calculateLongestStringLength(this.rootElement, (Control)this.getShell()) + 96;
            if (this.preferredViewerWidth > MAX_VIEWER_WIDTH) {
                this.preferredViewerWidth = MAX_VIEWER_WIDTH;
            }
        }
        return this.preferredViewerWidth;
    }

    protected ShowRelatedElementsComposite makeShowRelatedElementsCompositeInPlaceholder(Composite parent, SelectableElement root) {
        if (this.placeholderForShowRelatedElementsComposite == null) {
            this.placeholderForShowRelatedElementsComposite = new Composite(parent, 0);
            GridLayout gridLayout = new GridLayout(1, false);
            gridLayout.marginHeight = 0;
            gridLayout.marginWidth = 0;
            this.placeholderForShowRelatedElementsComposite.setLayout((Layout)gridLayout);
        }
        if (this.detailsShown) {
            ShowRelatedElementsComposite sreComposite = this.makeShowRelatedElementsComposite(this.placeholderForShowRelatedElementsComposite, root, this.getPreferredViewerWidth());
            sreComposite.setDetailsChangedListener(this);
            this.placeholderForShowRelatedElementsComposite.setLayoutData((Object)new GridData(1042));
            return sreComposite;
        }
        this.placeholderForShowRelatedElementsComposite.setLayoutData((Object)new GridData(0, 0));
        return null;
    }

    protected ShowRelatedElementsComposite makeShowRelatedElementsComposite(Composite parent, SelectableElement root, int aViewerWidth) {
        return new ShowRelatedElementsComposite(parent, root, aViewerWidth);
    }

    protected Control createDialogArea(Composite parent) {
        this.body = new Composite(parent, 0);
        this.body.setLayout((Layout)new GridLayout(2, false));
        this.showRelatedElementsPredefinedComposite = this.makePredefinedComposite(this.body, this.rootElement, this.queriesList, this.getPreferredViewerWidth());
        this.showRelatedElementsComposite = this.makeShowRelatedElementsCompositeInPlaceholder(this.body, this.rootElement);
        assert (!this.detailsShown || this.detailsShown && this.showRelatedElementsComposite != null);
        if (this.showRelatedElementsComposite != null) {
            this.showRelatedElementsComposite.getTreeViewer().refresh();
        }
        this.getShell().setText(CommonUIMessages.ShowRelatedElementsDialog_Title);
        if (this.helpContextId != null) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, this.helpContextId);
        } else {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.gmf.runtime.common.ui.egmf0200");
        }
        return parent;
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.getButton(0).setFocus();
        return control;
    }

    protected void okPressed() {
        if (this.getShowRelatedElementsComposite() != null) {
            if (this.getShowRelatedElementsComposite().validate(true) != null) {
                return;
            }
            this.getShowRelatedElementsComposite().saveCachedValues();
            this.saveCachedValues();
        }
        this.setReturnCode(0);
        this.close();
    }

    protected void cancelPressed() {
        this.setReturnCode(1);
        this.close();
    }

    public boolean getExpandIndefinitely() {
        return this.cachedExpandLevels == -1;
    }

    public int getExpandLevels() {
        return this.cachedExpandLevels;
    }

    public boolean getConsumerToSelection() {
        return this.cachedExpansionType == ExpansionType.INCOMING.getOrdinal() || this.cachedExpansionType == ExpansionType.BOTH.getOrdinal();
    }

    public boolean getSelectionToSupplier() {
        return this.cachedExpansionType == ExpansionType.OUTGOING.getOrdinal() || this.cachedExpansionType == ExpansionType.BOTH.getOrdinal();
    }

    public ExpansionType getExpansionType() {
        return ExpansionType.VALUES[this.cachedExpansionType];
    }

    public List getSelectedRelationshipTypes() {
        return this.cachedRelationshipTypes != null ? this.cachedRelationshipTypes : this.getRootElement().getSelectedElementTypes();
    }

    public SelectableElement getRootElement() {
        return this.rootElement;
    }

    public ShowRelatedElementsComposite getShowRelatedElementsComposite() {
        return this.showRelatedElementsComposite;
    }

    public void initHelpContextId(String helpId) {
        this.helpContextId = helpId;
    }

    protected void saveCachedValues() {
        this.showRelatedElementsComposite.saveCachedValues();
        this.cachedExpandLevels = this.getShowRelatedElementsComposite().getExpandIndefinitely() ? -1 : this.getShowRelatedElementsComposite().getExpandLevel();
        this.cachedExpansionType = this.getShowRelatedElementsComposite().getExpansionType().getOrdinal();
        this.cachedRelationshipTypes = this.getShowRelatedElementsComposite().getSelectedRelationshipTypes();
    }

    public void showOrHideDetails() {
        if (this.detailsShown) {
            this.detailsShown = false;
            this.saveCachedValues();
            this.showRelatedElementsComposite.dispose();
            this.showRelatedElementsComposite = this.makeShowRelatedElementsCompositeInPlaceholder(this.body, this.rootElement);
        } else {
            this.detailsShown = true;
            this.showRelatedElementsComposite = this.makeShowRelatedElementsCompositeInPlaceholder(this.body, this.rootElement);
        }
        this.placeholderForShowRelatedElementsComposite.pack();
        this.placeholderForShowRelatedElementsComposite.getParent().pack();
        this.getShell().pack();
    }

    public void updateRelationships(ShowRelatedElementsPreset preset) {
        if (this.detailsShown) {
            this.showRelatedElementsComposite.updateRelationships(preset);
        } else {
            if (preset == null) {
                return;
            }
            this.cachedExpandLevels = preset.getLevels();
            this.cachedExpansionType = preset.getExpansionType();
            this.cachedRelationshipTypes = new ArrayList();
            this.rootElement.getHintsThatMatchTheseIds(this.cachedRelationshipTypes, preset.getIds());
        }
    }

    public ShowRelatedElementsPreset getCurrentSettings() {
        if (this.detailsShown) {
            return this.showRelatedElementsComposite.getCurrentSettings();
        }
        return null;
    }

    public void detailsChanged() {
        if (this.showRelatedElementsPredefinedComposite != null) {
            this.showRelatedElementsPredefinedComposite.detailsChanged();
        }
    }

    protected ShowRelatedElementsPredefinedComposite getPredefinedComposite() {
        return this.showRelatedElementsPredefinedComposite;
    }

    protected void initDialogSettings() {
        this.detailsShown = this.dialogSettings.getBoolean(DIALOG_SETTINGS_KEY);
    }

    protected void saveDialogSettings() {
        this.dialogSettings.put(DIALOG_SETTINGS_KEY, this.detailsShown);
    }

    public boolean close() {
        this.saveDialogSettings();
        return super.close();
    }
}

