/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.actions;

import java.util.List;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.util.ViewType;
import org.eclipse.gmf.runtime.diagram.ui.actions.AttachShapeAction;
import org.eclipse.gmf.runtime.diagram.ui.actions.internal.l10n.DiagramUIActionsMessages;
import org.eclipse.gmf.runtime.diagram.ui.actions.internal.l10n.DiagramUIActionsPluginImages;
import org.eclipse.gmf.runtime.diagram.ui.commands.DeferredCreateConnectionViewCommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.INodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.internal.editparts.IEditableEditPart;
import org.eclipse.gmf.runtime.diagram.ui.internal.util.DiagramNotationType;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramWorkbenchPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.ui.IWorkbenchPage;

public class AddNoteAction
extends AttachShapeAction {
    public AddNoteAction(IWorkbenchPage page) {
        super(page);
    }

    public void init() {
        super.init();
        this.setText(DiagramUIActionsMessages.AddNoteAction_ActionLabelText);
        this.setId("addNoteLinkAction");
        this.setToolTipText(DiagramUIActionsMessages.AddNoteAction_ActionToolTipText);
        this.setImageDescriptor(DiagramUIActionsPluginImages.DESC_NOTE_ATTACHMENT);
        this.setHoverImageDescriptor(this.getImageDescriptor());
    }

    protected boolean calculateEnabled() {
        if (this.getSelectedObjects().isEmpty()) {
            return true;
        }
        List parts = this.getSelectedObjects();
        int i = 0;
        while (i < parts.size()) {
            Object o = parts.get(i);
            if (!(o instanceof INodeEditPart)) {
                return false;
            }
            INodeEditPart nodeEditPart = (INodeEditPart)o;
            if (!nodeEditPart.canAttachNote()) {
                return false;
            }
            if (nodeEditPart instanceof IEditableEditPart && !((IEditableEditPart)nodeEditPart).isEditModeEnabled()) {
                return false;
            }
            EditPart parentPart = nodeEditPart.getParent();
            if (parentPart instanceof IEditableEditPart && !((IEditableEditPart)parentPart).isEditModeEnabled()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected void doRun(IProgressMonitor progressMonitor) {
        List selectedEditParts = this.getSelectedObjects();
        IDiagramWorkbenchPart editor = this.getDiagramWorkbenchPart();
        CreateViewRequest.ViewDescriptor viewDescriptor = new CreateViewRequest.ViewDescriptor(null, Node.class, DiagramNotationType.NOTE.getSemanticHint(), this.getPreferencesHint());
        CreateViewRequest noteRequest = new CreateViewRequest(viewDescriptor);
        noteRequest.setLocation(this.getLocation(selectedEditParts));
        IGraphicalEditPart primaryPart = (IGraphicalEditPart)selectedEditParts.get(0);
        if (primaryPart instanceof ConnectionEditPart) {
            primaryPart = (IGraphicalEditPart)((ConnectionEditPart)primaryPart).getSource();
        }
        Command createNoteCmd = this.getContainer((EditPart)primaryPart).getCommand((Request)noteRequest);
        IAdaptable noteViewAdapter = (IAdaptable)((List)noteRequest.getNewObject()).get(0);
        CompositeCommand noteAttachmentCC = new CompositeCommand(this.getToolTipText());
        for (IGraphicalEditPart targetEditPart : selectedEditParts) {
            noteAttachmentCC.compose((IUndoableOperation)new DeferredCreateConnectionViewCommand(targetEditPart.getEditingDomain(), ViewType.NOTEATTACHMENT, noteViewAdapter, (IAdaptable)new EObjectAdapter((EObject)targetEditPart.getModel()), (EditPartViewer)editor.getDiagramGraphicalViewer(), this.getPreferencesHint()));
        }
        CompoundCommand cc = new CompoundCommand(this.getToolTipText());
        cc.add(createNoteCmd);
        cc.add((Command)new ICommandProxy((ICommand)noteAttachmentCC));
        if (cc.canExecute()) {
            editor.getDiagramEditDomain().getDiagramCommandStack().execute((Command)cc);
            this.selectAddedObject((EditPartViewer)editor.getDiagramGraphicalViewer(), (CreateRequest)noteRequest);
        }
    }
}

