/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile;

import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.IOException;
import org.apache.batik.transcoder.TranscoderException;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.BitmapHelper;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.DeviceContext;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.IEmf2SvgConverter;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.IWmf2SvgConverter;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.Record;

public class BitBlt
implements IEmf2SvgConverter,
IWmf2SvgConverter {
    private static final int EMF_XDEST_OFFSET = 16;
    private static final int EMF_YDEST_OFFSET = 20;
    private static final int EMF_WDEST_OFFSET = 24;
    private static final int EMF_HDEST_OFFSET = 28;
    private static final int EMF_XSRC_OFFSET = 36;
    private static final int EMF_YSRC_OFFSET = 40;
    private static final int EMF_BMI_OFFSET_OFFSET = 76;
    private static final int EMF_BMI_SIZE_OFFSET = 80;
    private static final int EMF_DATA_OFFSET_OFFSET = 84;
    private static final int EMF_DATA_SIZE_OFFSET = 88;
    private static final int WMF_XDEST_OFFSET = 14;
    private static final int WMF_YDEST_OFFSET = 12;
    private static final int WMF_WDEST_OFFSET = 10;
    private static final int WMF_HDEST_OFFSET = 8;
    private static final int WMF_XSRC_OFFSET = 6;
    private static final int WMF_YSRC_OFFSET = 4;
    private static final int WMF_BMI_OFFSET = 16;
    protected int m_xDest = 0;
    protected int m_yDest = 0;
    protected int m_wDest = 0;
    protected int m_hDest = 0;
    protected int m_xSrc = 0;
    protected int m_ySrc = 0;
    protected BufferedImage m_image = null;

    public void readWMFRecord(Record rec) throws IOException {
        if (rec.getSize() > 12) {
            this.m_xDest = rec.getShortAt(14);
            this.m_yDest = rec.getShortAt(12);
            this.m_wDest = rec.getShortAt(10);
            this.m_hDest = rec.getShortAt(8);
            this.m_xSrc = rec.getShortAt(6);
            this.m_ySrc = rec.getShortAt(4);
            int bmiSize = BitmapHelper.getHeaderSize(rec, 16, 0);
            int dataOffset = 16 + bmiSize;
            int dataSize = rec.getSize() - dataOffset;
            this.m_image = BitmapHelper.readBitmap(rec, 16, bmiSize, dataOffset, dataSize);
        }
    }

    public void readEMFRecord(Record rec) throws IOException {
        this.m_xDest = rec.getIntAt(16);
        this.m_yDest = rec.getIntAt(20);
        this.m_wDest = rec.getIntAt(24);
        this.m_hDest = rec.getIntAt(28);
        this.m_xSrc = rec.getIntAt(36);
        this.m_ySrc = rec.getIntAt(40);
        int bmiOffset = rec.getIntAt(76) - 8;
        int bmiSize = rec.getIntAt(80);
        int dataOffset = rec.getIntAt(84) - 8;
        int dataSize = rec.getIntAt(88);
        if (bmiSize == 0) {
            return;
        }
        this.m_image = BitmapHelper.readBitmap(rec, bmiOffset, bmiSize, dataOffset, dataSize);
    }

    public void render(Graphics2D g, DeviceContext context) throws TranscoderException {
        if (this.m_image != null) {
            int w = this.m_image.getWidth();
            int h = this.m_image.getHeight();
            int xSrc = context.convertXToSVGLogicalUnits(this.m_xSrc);
            int ySrc = context.convertYToSVGLogicalUnits(this.m_ySrc);
            int xDest = context.convertXToSVGLogicalUnits(this.m_xDest);
            int yDest = context.convertYToSVGLogicalUnits(this.m_yDest);
            int wDest = context.scaleX(this.m_wDest);
            int hDest = context.scaleY(this.m_hDest);
            if (xSrc >= w || ySrc >= h) {
                return;
            }
            if (xSrc + wDest > w) {
                wDest = w - xSrc;
            }
            if (ySrc + hDest > h) {
                hDest = h - ySrc;
            }
            BufferedImage image = this.m_image.getSubimage(xSrc, ySrc, wDest, hDest);
            g.drawImage(image, new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, xDest, yDest), null);
        }
    }
}

