/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.lite.handles;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.Locator;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.draw2d.TreeSearch;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.editparts.ZoomListener;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.handles.AbstractHandle;
import org.eclipse.gmf.runtime.lite.figures.ICompartmentHandleLocatorProvider;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;

public class CompartmentNameHandle
extends AbstractHandle
implements ZoomListener {
    private final Label myLabel;
    private ZoomManager myZoomManager;

    public CompartmentNameHandle(GraphicalEditPart owner, String title) {
        this.setOwner(owner);
        this.setLocator(new CompartmentHandleLocator());
        this.myLabel = new Label();
        this.setLayoutManager((LayoutManager)new StackLayout());
        this.add((IFigure)this.myLabel);
        this.myZoomManager = (ZoomManager)this.getOwner().getViewer().getProperty(ZoomManager.class.toString());
        double zoomLevel = this.myZoomManager == null ? 1.0 : this.myZoomManager.getZoom();
        zoomLevel *= this.getFontScaleFactor();
        if (this.getOwnerFigure().getFont() != null) {
            Font font = this.getScaledFont(zoomLevel);
            this.myLabel.setFont(font);
            if (this.myZoomManager != null) {
                this.myZoomManager.addZoomListener((ZoomListener)this);
            }
        }
        this.myLabel.setLabelAlignment(32);
        this.myLabel.setText(title);
    }

    public void ancestorRemoved(IFigure ancestor) {
        this.replaceFont(null);
        if (this.myZoomManager != null) {
            this.myZoomManager.removeZoomListener((ZoomListener)this);
        }
    }

    public void zoomChanged(double zoom) {
        Font font = this.getScaledFont(zoom * this.getFontScaleFactor());
        this.replaceFont(font);
    }

    protected void replaceFont(Font newFont) {
        Font font = this.myLabel.getFont();
        this.myLabel.setFont(newFont);
        if (font != null) {
            font.dispose();
        }
    }

    private Font getScaledFont(double scaleFactor) {
        FontData[] datas = this.getOwnerFigure().getFont().getFontData();
        int i = 0;
        while (i < datas.length) {
            datas[i].height = (float)((double)datas[i].height * scaleFactor);
            ++i;
        }
        return new Font(this.getOwnerFigure().getFont().getDevice(), datas);
    }

    protected double getFontScaleFactor() {
        return 0.6666666666666666;
    }

    protected final Label getLabel() {
        return this.myLabel;
    }

    public IFigure findFigureAt(int x, int y, TreeSearch search) {
        IFigure result = super.findFigureAt(x, y, search);
        if (result == this.myLabel) {
            return this;
        }
        return result;
    }

    protected DragTracker createDragTracker() {
        return null;
    }

    protected class CompartmentHandleLocator
    implements Locator {
        protected CompartmentHandleLocator() {
        }

        public void relocate(IFigure target) {
            if (CompartmentNameHandle.this.getOwnerFigure() instanceof ICompartmentHandleLocatorProvider) {
                ((ICompartmentHandleLocatorProvider)CompartmentNameHandle.this.getOwnerFigure()).getCompartmentHandleLocator().relocate(target);
                return;
            }
            Rectangle theBounds = CompartmentNameHandle.this.getOwnerFigure().getClientArea();
            CompartmentNameHandle.this.getOwnerFigure().translateToAbsolute((Translatable)theBounds);
            target.translateToRelative((Translatable)theBounds);
            Dimension preferredSize = target.getPreferredSize();
            theBounds.height = Math.min(theBounds.height, preferredSize.height);
            theBounds.width = Math.max(theBounds.width, preferredSize.width);
            target.setSize(theBounds.getSize().expand(-1, -1));
            target.setLocation(theBounds.getLocation().translate(0, -target.getSize().height / 2));
        }
    }
}

