/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.runtime.diagram.ui.label;

import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.NoteEditPart;
import org.eclipse.gmf.runtime.diagram.ui.l10n.SharedImages;
import org.eclipse.gmf.runtime.diagram.ui.label.ILabelDelegate;
import org.eclipse.gmf.runtime.diagram.ui.type.DiagramNotationType;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrapLabel;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.tests.runtime.diagram.ui.AbstractTestBase;
import org.eclipse.gmf.tests.runtime.diagram.ui.label.LabelNotationType;
import org.eclipse.gmf.tests.runtime.diagram.ui.label.OriginalWrapLabel;
import org.eclipse.gmf.tests.runtime.diagram.ui.logic.LogicTestFixture;

public class LabelTests
extends AbstractTestBase {
    public LabelTests(String name) {
        super(name);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)LabelTests.suite());
    }

    public static Test suite() {
        return new TestSuite(LabelTests.class);
    }

    protected void setTestFixture() {
        this.testFixture = new LogicTestFixture();
    }

    protected LogicTestFixture getFixture() {
        return (LogicTestFixture)this.testFixture;
    }

    public void testWrapLabelDelegate() throws Exception {
        this.getFixture().openDiagram();
        NoteEditPart oldWrapLabelEP = (NoteEditPart)this.getFixture().createShapeUsingTool((IElementType)LabelNotationType.OLDWRAPLABEL_NOTE, new Point(10, 10), new Dimension(200, 50), (IGraphicalEditPart)this.getDiagramEditPart());
        OriginalWrapLabel oldWrapLabel = (OriginalWrapLabel)oldWrapLabelEP.getChildBySemanticHint("OldWrapLabel").getFigure();
        NoteEditPart wrapLabelDelegateEP = (NoteEditPart)this.getFixture().createShapeUsingTool((IElementType)LabelNotationType.WRAPLABEL_NOTE, new Point(10, 10), new Dimension(200, 50), (IGraphicalEditPart)this.getDiagramEditPart());
        WrapLabel wrapLabel = (WrapLabel)wrapLabelDelegateEP.getChildBySemanticHint("WrapLabel").getFigure();
        oldWrapLabel.setText("Let's put a bit of text in here that would cause the label to wrap.");
        oldWrapLabel.setIcon(SharedImages.get((String)"icons/note.gif"));
        wrapLabel.setText("Let's put a bit of text in here that would cause the label to wrap.");
        wrapLabel.setIcon(SharedImages.get((String)"icons/note.gif"));
        this.flushEventQueue();
        LabelTests.assertEquals((int)oldWrapLabel.getIconAlignment(), (int)wrapLabel.getIconAlignment());
        LabelTests.assertEquals((int)oldWrapLabel.getIconTextGap(), (int)wrapLabel.getIconTextGap());
        LabelTests.assertEquals((String)oldWrapLabel.getText(), (String)wrapLabel.getText());
        LabelTests.assertEquals((int)oldWrapLabel.getTextAlignment(), (int)wrapLabel.getTextAlignment());
        LabelTests.assertEquals((int)oldWrapLabel.getTextPlacement(), (int)wrapLabel.getTextPlacement());
        LabelTests.assertEquals((boolean)oldWrapLabel.isTextTruncated(), (boolean)wrapLabel.isTextTruncated());
        LabelTests.assertEquals((boolean)oldWrapLabel.isTextUnderlined(), (boolean)wrapLabel.isTextUnderlined());
        LabelTests.assertEquals((boolean)oldWrapLabel.isTextStrikedThrough(), (boolean)wrapLabel.isTextStrikedThrough());
        LabelTests.assertEquals((boolean)oldWrapLabel.isTextWrapped(), (boolean)wrapLabel.isTextWrapped());
        LabelTests.assertEquals((int)oldWrapLabel.getTextWrapAlignment(), (int)wrapLabel.getTextWrapAlignment());
        LabelTests.assertEquals((boolean)oldWrapLabel.isSelected(), (boolean)wrapLabel.isSelected());
        LabelTests.assertEquals((boolean)oldWrapLabel.hasFocus(), (boolean)wrapLabel.hasFocus());
    }

    public void testLabelAlignment() throws Exception {
        this.getFixture().openDiagram();
        NoteEditPart noteEP = (NoteEditPart)this.getFixture().createShapeUsingTool((IElementType)DiagramNotationType.NOTE, new Point(10, 10), new Dimension(300, 300), (IGraphicalEditPart)this.getDiagramEditPart());
        IGraphicalEditPart labelEP = noteEP.getChildBySemanticHint("Description");
        ILabelDelegate label = (ILabelDelegate)labelEP.getAdapter(ILabelDelegate.class);
        label.setText("hi");
        Point[][] loc = new Point[3][3];
        label.setAlignment(9);
        this.flushEventQueue();
        loc[0][0] = label.getTextBounds().getLocation();
        label.setAlignment(8);
        this.flushEventQueue();
        loc[0][1] = label.getTextBounds().getLocation();
        label.setAlignment(12);
        this.flushEventQueue();
        loc[0][2] = label.getTextBounds().getLocation();
        label.setAlignment(1);
        this.flushEventQueue();
        loc[1][0] = label.getTextBounds().getLocation();
        label.setAlignment(2);
        this.flushEventQueue();
        loc[1][1] = label.getTextBounds().getLocation();
        label.setAlignment(4);
        this.flushEventQueue();
        loc[1][2] = label.getTextBounds().getLocation();
        label.setAlignment(33);
        this.flushEventQueue();
        loc[2][0] = label.getTextBounds().getLocation();
        label.setAlignment(32);
        this.flushEventQueue();
        loc[2][1] = label.getTextBounds().getLocation();
        label.setAlignment(36);
        this.flushEventQueue();
        loc[2][2] = label.getTextBounds().getLocation();
        int i = 0;
        while (i < 2) {
            LabelTests.assertTrue((loc[i][0].x < loc[i][1].x && loc[i][1].x < loc[i][2].x ? 1 : 0) != 0);
            LabelTests.assertTrue((loc[i][0].y == loc[i][1].y && loc[i][1].y == loc[i][2].y ? 1 : 0) != 0);
            ++i;
        }
    }
}

