/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.runtime.diagram.ui.logic;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.Request;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.geoshapes.type.GeoshapeType;
import org.eclipse.gmf.runtime.diagram.ui.requests.ArrangeRequest;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.tests.runtime.diagram.ui.AbstractTestBase;
import org.eclipse.gmf.tests.runtime.diagram.ui.logic.LogicTestFixture;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;

public class LayoutTests
extends AbstractTestBase {
    IElementType CIRCUIT_TYPE = ElementTypeRegistry.getInstance().getType("logic.circuit");
    IElementType LED_TYPE = ElementTypeRegistry.getInstance().getType("logic.led");

    public static Test suite() {
        TestSuite s = new TestSuite(LayoutTests.class);
        return s;
    }

    public LayoutTests() {
        super("Layout Tests");
    }

    protected void setTestFixture() {
        this.testFixture = new LayoutTestFixture();
    }

    protected LayoutTestFixture getFixture() {
        return (LayoutTestFixture)this.testFixture;
    }

    protected IGraphicalEditPart getContainerEP() {
        return this.getDiagramEditPart();
    }

    protected void assertNotEquals(Object object1, Object object2) {
        LayoutTests.assertFalse((boolean)object1.equals(object2));
    }

    public void test151214MultipleArrangeOneCircuit() throws Exception {
        this.getTestFixture().openDiagram();
        ShapeEditPart circuitEP = this.getFixture().createShapeUsingTool(this.CIRCUIT_TYPE, new Point(25, 55), new Dimension(100, 100), this.getContainerEP());
        this.flushEventQueue();
        Rectangle prevBounds = circuitEP.getFigure().getBounds().getCopy();
        this.getContainerEP().getViewer().setSelection((ISelection)new StructuredSelection((Object)this.getContainerEP()));
        ArrangeRequest request = new ArrangeRequest("arrangeAllAction");
        this.getCommandStack().execute(this.getContainerEP().getCommand((Request)request));
        this.flushEventQueue();
        this.assertNotEquals(prevBounds, circuitEP.getFigure().getBounds());
        prevBounds = circuitEP.getFigure().getBounds().getCopy();
        this.getCommandStack().execute(this.getContainerEP().getCommand((Request)request));
        this.flushEventQueue();
        LayoutTests.assertEquals((Object)prevBounds, (Object)circuitEP.getFigure().getBounds());
    }

    public void test151214DoesNotAssumeAutosizeIsOn() throws Exception {
        this.getTestFixture().openDiagram();
        ShapeEditPart circuit1EP = this.getFixture().createShapeUsingTool(this.CIRCUIT_TYPE, new Point(22, 58), this.getContainerEP());
        ShapeEditPart circuit2EP = this.getFixture().createShapeUsingTool(this.CIRCUIT_TYPE, new Point(27, 199), new Dimension(111, 111), this.getContainerEP());
        ShapeEditPart circuit3EP = this.getFixture().createShapeUsingTool(this.CIRCUIT_TYPE, new Point(373, 55), this.getContainerEP());
        EObject circuit2 = circuit2EP.getNotationView().getElement();
        this.getFixture().createLED(circuit2);
        this.getFixture().createLED(circuit2);
        this.getFixture().createLED(circuit2);
        this.getFixture().createLED(circuit2);
        this.getFixture().createLED(circuit2);
        this.flushEventQueue();
        this.getContainerEP().getViewer().setSelection((ISelection)new StructuredSelection((Object)this.getContainerEP()));
        ArrangeRequest request = new ArrangeRequest("arrangeAllAction");
        this.getCommandStack().execute(this.getContainerEP().getCommand((Request)request));
        this.flushEventQueue();
        int diffX_12 = circuit2EP.getFigure().getBounds().getLeft().x - circuit1EP.getFigure().getBounds().getRight().x;
        int diffX_23 = circuit3EP.getFigure().getBounds().getLeft().x - circuit2EP.getFigure().getBounds().getRight().x;
        LayoutTests.assertTrue((diffX_23 < diffX_12 * 2 ? 1 : 0) != 0);
    }

    public void test151214CompositeLayoutRespectsNewSize() throws Exception {
        this.getTestFixture().openDiagram();
        ShapeEditPart circuitEP = this.getFixture().createShapeUsingTool(this.CIRCUIT_TYPE, new Point(39, 81), this.getContainerEP());
        EObject circuit = circuitEP.getNotationView().getElement();
        this.getFixture().createLED(circuit);
        this.getFixture().createLED(circuit);
        this.getFixture().createLED(circuit);
        this.getFixture().createLED(circuit);
        this.getFixture().createLED(circuit);
        this.flushEventQueue();
        IGraphicalEditPart compartmentEP = circuitEP.getChildBySemanticHint("LogicCompartment");
        ShapeEditPart innerLed1EP = (ShapeEditPart)compartmentEP.getChildren().get(0);
        ShapeEditPart innerLed2EP = (ShapeEditPart)compartmentEP.getChildren().get(1);
        ShapeEditPart geoshapeEP = this.getFixture().createShapeUsingTool((IElementType)GeoshapeType.DIAMOND, new Point(161, 25), this.getContainerEP());
        this.getFixture().createConnectorUsingTool((IGraphicalEditPart)innerLed1EP, (IGraphicalEditPart)innerLed2EP, (IElementType)GeoshapeType.LINE);
        this.getFixture().createConnectorUsingTool((IGraphicalEditPart)innerLed2EP, (IGraphicalEditPart)geoshapeEP, (IElementType)GeoshapeType.LINE);
        this.flushEventQueue();
        this.getContainerEP().getViewer().setSelection((ISelection)new StructuredSelection((Object)this.getContainerEP()));
        ArrangeRequest request = new ArrangeRequest("arrangeAllAction");
        this.getCommandStack().execute(this.getContainerEP().getCommand((Request)request));
        this.flushEventQueue();
        LayoutTests.assertFalse((boolean)geoshapeEP.getFigure().getBounds().intersects(circuitEP.getFigure().getBounds()));
    }

    public class LayoutTestFixture
    extends LogicTestFixture {
        protected void createShapesAndConnectors() throws Exception {
        }
    }
}

