/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.gef;

import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.ScrollPane;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gmf.codegen.gmfgen.GenCommonBase;
import org.eclipse.gmf.codegen.gmfgen.GenCompartment;
import org.eclipse.gmf.codegen.gmfgen.GenNode;
import org.eclipse.gmf.runtime.diagram.ui.editparts.CompartmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.ResizableCompartmentEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.figures.ResizableCompartmentFigure;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrapLabel;
import org.eclipse.gmf.runtime.notation.DrawerStyle;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.TitleStyle;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.tests.rt.GeneratedCanvasTest;

public final class CompartmentPropertiesTest
extends GeneratedCanvasTest {
    private static final NotationPackage NOTATION = NotationPackage.eINSTANCE;

    public CompartmentPropertiesTest(String name) {
        super(name);
    }

    public void testCompartmentTitles_Static() {
        this.checkNoTitle(this.getCompartmentEditPartB());
        this.checkHasTitle(this.getCompartmentEditPartA());
    }

    public void testCompartmentTitles() {
        CompartmentEditPart newCompartmentA = this.createNewCompartment(this.getSetup().getGenModel().getNodeA());
        this.checkHasTitle(newCompartmentA);
        Node withTitleStyle = this.getNotation((EditPart)newCompartmentA);
        TitleStyle titleStyle = (TitleStyle)withTitleStyle.getStyle(NOTATION.getTitleStyle());
        CompartmentPropertiesTest.assertNotNull((Object)titleStyle);
        CompartmentPropertiesTest.assertTrue((boolean)titleStyle.isShowTitle());
        CompartmentEditPart newCompartmentB = this.createNewCompartment(this.getSetup().getGenModel().getNodeB());
        this.checkNoTitle(newCompartmentB);
        Node withoutTitleStyle = this.getNotation((EditPart)newCompartmentB);
        CompartmentPropertiesTest.assertNull((String)"[#143934] Required to disable title configuration in property sheet", (Object)withoutTitleStyle.getStyle(NOTATION.getTitleStyle()));
    }

    public void testCompartmentCollapsed_Static() {
        this.checkIsCollapsed(this.getCompartmentEditPartA(), false);
        this.checkIsCollapsed(this.getCompartmentEditPartB(), false);
        this.checkHasCollapseHandler("Collapsible compartment should show collapse handler", this.getCompartmentEditPartA(), true);
        this.checkHasCollapseHandler("Not-collapsible compartment should not show collapse handler", this.getCompartmentEditPartB(), false);
    }

    public void testCompartmentCollapsed() {
        CompartmentEditPart newCompartmentA = this.createNewCompartment(this.getSetup().getGenModel().getNodeA());
        this.checkIsCollapsed(newCompartmentA, false);
        Node collapsible = this.getNotation((EditPart)newCompartmentA);
        DrawerStyle drawerStyle = (DrawerStyle)collapsible.getStyle(NOTATION.getDrawerStyle());
        CompartmentPropertiesTest.assertNotNull((Object)drawerStyle);
        CompartmentPropertiesTest.assertFalse((boolean)drawerStyle.isCollapsed());
        CompartmentEditPart newCompartmentB = this.createNewCompartment(this.getSetup().getGenModel().getNodeB());
        this.checkIsCollapsed(newCompartmentB, false);
        Node notCollapsible = this.getNotation((EditPart)newCompartmentB);
        CompartmentPropertiesTest.assertNull((Object)notCollapsible.getStyle(NOTATION.getDrawerStyle()));
    }

    private void checkIsCollapsed(CompartmentEditPart editPart, boolean expected) {
        this.checkCompartmentFigure(editPart);
        ResizableCompartmentFigure figure = (ResizableCompartmentFigure)editPart.getFigure();
        ScrollPane scrollPane = figure.getScrollPane();
        CompartmentPropertiesTest.assertEquals((boolean)expected, (scrollPane.getVerticalScrollBarVisibility() == 0 ? 1 : 0) != 0);
    }

    private void checkHasCollapseHandler(String message, CompartmentEditPart editPart, boolean expected) {
        EditPolicy policy = editPart.getEditPolicy((Object)"PrimaryDrag Policy");
        CompartmentPropertiesTest.assertEquals((String)message, (boolean)expected, (boolean)(policy instanceof ResizableCompartmentEditPolicy));
    }

    private void checkNoTitle(CompartmentEditPart editPart) {
        this.checkCompartmentFigure(editPart);
        ResizableCompartmentFigure noTitle = (ResizableCompartmentFigure)editPart.getFigure();
        Figure textPane = noTitle.getTextPane();
        CompartmentPropertiesTest.assertTrue((!textPane.isVisible() || textPane.getChildren().isEmpty() || !((IFigure)textPane.getChildren().get(0)).isVisible() ? 1 : 0) != 0);
    }

    private void checkHasTitle(CompartmentEditPart editPart) {
        this.checkCompartmentFigure(editPart);
        ResizableCompartmentFigure withTitle = (ResizableCompartmentFigure)editPart.getFigure();
        Figure textPane = withTitle.getTextPane();
        CompartmentPropertiesTest.assertNotNull((Object)textPane);
        CompartmentPropertiesTest.assertTrue((boolean)textPane.isVisible());
        CompartmentPropertiesTest.assertFalse((boolean)textPane.getChildren().isEmpty());
        IFigure label = (IFigure)textPane.getChildren().get(0);
        CompartmentPropertiesTest.assertTrue((boolean)(label instanceof WrapLabel));
        CompartmentPropertiesTest.assertTrue((boolean)label.isVisible());
        String text = ((WrapLabel)label).getText();
        CompartmentPropertiesTest.assertTrue((text != null && text.trim().length() > 0 ? 1 : 0) != 0);
    }

    private void checkCompartmentFigure(CompartmentEditPart editPart) {
        CompartmentPropertiesTest.assertTrue((boolean)(editPart.getFigure() instanceof ResizableCompartmentFigure));
        ResizableCompartmentFigure figure = (ResizableCompartmentFigure)editPart.getFigure();
        Figure textPane = figure.getTextPane();
        CompartmentPropertiesTest.assertNotNull((Object)textPane);
    }

    private CompartmentEditPart createNewCompartment(GenNode genTopLevelParent) {
        GenCompartment genCompartment = this.getGenCompartment(genTopLevelParent);
        Node notationParent = this.createNode((GenCommonBase)genTopLevelParent, (View)this.getDiagram());
        CompartmentPropertiesTest.assertNotNull((Object)notationParent);
        View notationCompartment = CompartmentPropertiesTest.findChildView((View)notationParent, (GenCommonBase)genCompartment);
        CompartmentPropertiesTest.assertNotNull((Object)notationCompartment);
        CompartmentEditPart editPart = (CompartmentEditPart)this.findEditPart(notationCompartment);
        CompartmentPropertiesTest.assertNotNull((Object)editPart);
        return editPart;
    }

    private final GenCompartment getGenCompartment(GenNode genNode) {
        return (GenCompartment)genNode.getCompartments().get(0);
    }
}

