/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.gen;

import junit.framework.TestCase;
import org.eclipse.gmf.gmfgraph.ChildAccess;
import org.eclipse.gmf.gmfgraph.Connection;
import org.eclipse.gmf.gmfgraph.CustomFigure;
import org.eclipse.gmf.gmfgraph.DiagramLabel;
import org.eclipse.gmf.gmfgraph.Ellipse;
import org.eclipse.gmf.gmfgraph.Figure;
import org.eclipse.gmf.gmfgraph.FigureAccessor;
import org.eclipse.gmf.gmfgraph.FigureDescriptor;
import org.eclipse.gmf.gmfgraph.FigureGallery;
import org.eclipse.gmf.gmfgraph.FigureRef;
import org.eclipse.gmf.gmfgraph.GMFGraphFactory;
import org.eclipse.gmf.gmfgraph.Label;
import org.eclipse.gmf.gmfgraph.Node;
import org.eclipse.gmf.gmfgraph.PolylineConnection;
import org.eclipse.gmf.gmfgraph.RealFigure;
import org.eclipse.gmf.gmfgraph.Rectangle;
import org.eclipse.gmf.tests.setup.DiaDefSetup;

public class HandcodedGraphDefTest
extends TestCase {
    private FigureGallery myGallery;
    private Rectangle myFigureWithLabel;
    private Node myNode;
    private Connection myConnection;
    private ChildAccess myFigureWithLabelAccess;

    public HandcodedGraphDefTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.myGallery = GMFGraphFactory.eINSTANCE.createFigureGallery();
        this.myGallery.setName("g1");
        this.myFigureWithLabel = GMFGraphFactory.eINSTANCE.createRectangle();
        this.myFigureWithLabel.setName("RF");
        Label child = GMFGraphFactory.eINSTANCE.createLabel();
        child.setName("CHLF");
        this.myFigureWithLabel.getChildren().add((Object)child);
        FigureDescriptor fd = DiaDefSetup.newDescriptor("RF_TLF", (Figure)this.myFigureWithLabel);
        this.myGallery.getDescriptors().add((Object)fd);
        this.myNode = GMFGraphFactory.eINSTANCE.createNode();
        this.myNode.setName("N1");
        this.myNode.setFigure(fd);
        this.myFigureWithLabelAccess = DiaDefSetup.newAccess(fd, (RealFigure)child);
        this.myConnection = GMFGraphFactory.eINSTANCE.createConnection();
        this.myConnection.setName("C1");
        PolylineConnection c1 = GMFGraphFactory.eINSTANCE.createPolylineConnection();
        c1.setName("c1fig");
        fd = DiaDefSetup.newDescriptor("c1tlf", (Figure)c1);
        this.myGallery.getDescriptors().add((Object)fd);
        this.myConnection.setFigure(fd);
    }

    public void testGetDescriptor() {
        HandcodedGraphDefTest.assertNotNull((Object)this.myFigureWithLabel.getDescriptor());
        HandcodedGraphDefTest.assertEquals((Object)this.myNode.getFigure(), (Object)this.myFigureWithLabel.getDescriptor());
        HandcodedGraphDefTest.assertNotNull((Object)((Figure)this.myFigureWithLabel.getChildren().get(0)).getDescriptor());
        HandcodedGraphDefTest.assertEquals((Object)this.myNode.getFigure(), (Object)((Figure)this.myFigureWithLabel.getChildren().get(0)).getDescriptor());
        HandcodedGraphDefTest.assertNotNull((Object)this.myConnection.getFigure().getActualFigure().getDescriptor());
    }

    public void testIsLabelExternalLogic() {
        DiagramLabel l = GMFGraphFactory.eINSTANCE.createDiagramLabel();
        Label figure = GMFGraphFactory.eINSTANCE.createLabel();
        figure.setName("LF");
        l.setFigure(DiaDefSetup.newDescriptor("x", (Figure)figure));
        l.setName("L");
        HandcodedGraphDefTest.assertTrue((String)"Label out from figure hierarchy should be treated as external", (boolean)l.isExternal());
        l.setFigure(this.myFigureWithLabel.getDescriptor());
        l.setAccessor(this.myFigureWithLabelAccess);
        HandcodedGraphDefTest.assertFalse((String)"Label from figures hierarchy should be treated as internal", (boolean)l.isExternal());
    }

    public void testGetAccessor() {
        HandcodedGraphDefTest.assertNotNull((Object)this.myFigureWithLabelAccess.getAccessor());
        ChildAccess ca = GMFGraphFactory.eINSTANCE.createChildAccess();
        ca.setAccessor("a1");
        HandcodedGraphDefTest.assertEquals((String)"a1", (String)ca.getAccessor());
        Ellipse el = GMFGraphFactory.eINSTANCE.createEllipse();
        ca.setFigure((Figure)el);
        HandcodedGraphDefTest.assertEquals((String)"a1", (String)ca.getAccessor());
        el.setName("ElliName");
        HandcodedGraphDefTest.assertEquals((String)"a1", (String)ca.getAccessor());
        ca.setAccessor("");
        HandcodedGraphDefTest.assertEquals((String)"getFigureElliName", (String)ca.getAccessor());
        ca.setFigure(null);
        HandcodedGraphDefTest.assertEquals((String)"getFigureNull", (String)ca.getAccessor());
        FigureRef fr = GMFGraphFactory.eINSTANCE.createFigureRef();
        fr.setFigure((RealFigure)el);
        ca.setFigure((Figure)fr);
        HandcodedGraphDefTest.assertEquals((String)"getFigureElliName", (String)ca.getAccessor());
        FigureAccessor fa = GMFGraphFactory.eINSTANCE.createFigureAccessor();
        fa.setAccessor("ThroughFA");
        CustomFigure cf = GMFGraphFactory.eINSTANCE.createCustomFigure();
        cf.setQualifiedClassName("org.eclipse.draw2d.IFigure");
        fa.setTypedFigure((RealFigure)cf);
        ca.setFigure((Figure)cf);
        HandcodedGraphDefTest.assertEquals((String)"ThroughFA", (String)ca.getAccessor());
    }
}

